/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.search.FieldDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.FieldSortedHitQueue;
import com.google.appengine.repackaged.org.apache.lucene.search.ScoreDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.Sort;
import com.google.appengine.repackaged.org.apache.lucene.search.TopDocCollector;
import com.google.appengine.repackaged.org.apache.lucene.search.TopDocs;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocs;
import java.io.IOException;

public class TopFieldDocCollector
extends TopDocCollector {
    private FieldDoc reusableFD;

    public TopFieldDocCollector(IndexReader reader, Sort sort, int numHits) throws IOException {
        super(new FieldSortedHitQueue(reader, sort.fields, numHits));
    }

    public void collect(int doc, float score) {
        if (score > 0.0f) {
            ++this.totalHits;
            if (this.reusableFD == null) {
                this.reusableFD = new FieldDoc(doc, score);
            } else {
                this.reusableFD.score = score;
                this.reusableFD.doc = doc;
            }
            this.reusableFD = (FieldDoc)this.hq.insertWithOverflow(this.reusableFD);
        }
    }

    public TopDocs topDocs() {
        FieldSortedHitQueue fshq = (FieldSortedHitQueue)this.hq;
        ScoreDoc[] scoreDocs = new ScoreDoc[fshq.size()];
        for (int i = fshq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = fshq.fillFields((FieldDoc)fshq.pop());
        }
        return new TopFieldDocs(this.totalHits, scoreDocs, fshq.getFields(), fshq.getMaxScore());
    }
}

