/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.FilteredTermEnum;
import com.google.appengine.repackaged.org.apache.lucene.search.MultiTermQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.TermQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.WildcardTermEnum;
import com.google.appengine.repackaged.org.apache.lucene.util.ToStringUtils;
import java.io.IOException;

public class WildcardQuery
extends MultiTermQuery {
    private boolean termContainsWildcard;
    protected Term term;

    public WildcardQuery(Term term) {
        super(term);
        this.term = term;
        this.termContainsWildcard = term.text().indexOf(42) != -1 || term.text().indexOf(63) != -1;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new WildcardTermEnum(reader, this.getTerm());
    }

    public Term getTerm() {
        return this.term;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (!this.termContainsWildcard) {
            return new TermQuery(this.getTerm());
        }
        return super.rewrite(reader);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardQuery other = (WildcardQuery)obj;
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }
}

