/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.datastore.core.rep.AutoValue_WriteResult;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.OriginalMutationInfo;
import com.google.cloud.datastore.core.rep.WriteResult;
import com.google.cloud.datastore.core.rep.WriteStats;

abstract class $AutoValue_WriteResult
extends WriteResult {
    private final long commitTimestamp;
    private final ImmutableList<MutationResult> collapsedMutationResults;
    private final ImmutableList<OriginalMutationInfo> originalMutationInfos;
    private final WriteStats stats;

    $AutoValue_WriteResult(long commitTimestamp, ImmutableList<MutationResult> collapsedMutationResults, ImmutableList<OriginalMutationInfo> originalMutationInfos, WriteStats stats) {
        this.commitTimestamp = commitTimestamp;
        if (collapsedMutationResults == null) {
            throw new NullPointerException("Null collapsedMutationResults");
        }
        this.collapsedMutationResults = collapsedMutationResults;
        if (originalMutationInfos == null) {
            throw new NullPointerException("Null originalMutationInfos");
        }
        this.originalMutationInfos = originalMutationInfos;
        if (stats == null) {
            throw new NullPointerException("Null stats");
        }
        this.stats = stats;
    }

    @Override
    public long commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public ImmutableList<MutationResult> collapsedMutationResults() {
        return this.collapsedMutationResults;
    }

    @Override
    public ImmutableList<OriginalMutationInfo> originalMutationInfos() {
        return this.originalMutationInfos;
    }

    @Override
    public WriteStats stats() {
        return this.stats;
    }

    public String toString() {
        long l = this.commitTimestamp;
        String string = String.valueOf(this.collapsedMutationResults);
        String string2 = String.valueOf(this.originalMutationInfos);
        String string3 = String.valueOf(this.stats);
        return new StringBuilder(108 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("WriteResult{commitTimestamp=").append(l).append(", collapsedMutationResults=").append(string).append(", originalMutationInfos=").append(string2).append(", stats=").append(string3).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WriteResult) {
            WriteResult that = (WriteResult)o;
            return this.commitTimestamp == that.commitTimestamp() && this.collapsedMutationResults.equals(that.collapsedMutationResults()) && this.originalMutationInfos.equals(that.originalMutationInfos()) && this.stats.equals(that.stats());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.commitTimestamp >>> 32 ^ this.commitTimestamp);
        h$ *= 1000003;
        h$ ^= this.collapsedMutationResults.hashCode();
        h$ *= 1000003;
        h$ ^= this.originalMutationInfos.hashCode();
        h$ *= 1000003;
        return h$ ^= this.stats.hashCode();
    }

    @Override
    public WriteResult.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends WriteResult.Builder {
        private Long commitTimestamp;
        private ImmutableList<MutationResult> collapsedMutationResults;
        private ImmutableList<OriginalMutationInfo> originalMutationInfos;
        private WriteStats stats;

        Builder() {
        }

        private Builder(WriteResult source) {
            this.commitTimestamp = source.commitTimestamp();
            this.collapsedMutationResults = source.collapsedMutationResults();
            this.originalMutationInfos = source.originalMutationInfos();
            this.stats = source.stats();
        }

        @Override
        public WriteResult.Builder commitTimestamp(long commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public WriteResult.Builder collapsedMutationResults(Iterable<MutationResult> collapsedMutationResults) {
            this.collapsedMutationResults = ImmutableList.copyOf(collapsedMutationResults);
            return this;
        }

        @Override
        public WriteResult.Builder originalMutationInfos(ImmutableList<OriginalMutationInfo> originalMutationInfos) {
            if (originalMutationInfos == null) {
                throw new NullPointerException("Null originalMutationInfos");
            }
            this.originalMutationInfos = originalMutationInfos;
            return this;
        }

        @Override
        public WriteResult.Builder stats(WriteStats stats) {
            if (stats == null) {
                throw new NullPointerException("Null stats");
            }
            this.stats = stats;
            return this;
        }

        @Override
        public WriteResult build() {
            String missing = "";
            if (this.commitTimestamp == null) {
                missing = String.valueOf(missing).concat(" commitTimestamp");
            }
            if (this.collapsedMutationResults == null) {
                missing = String.valueOf(missing).concat(" collapsedMutationResults");
            }
            if (this.originalMutationInfos == null) {
                missing = String.valueOf(missing).concat(" originalMutationInfos");
            }
            if (this.stats == null) {
                missing = String.valueOf(missing).concat(" stats");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_WriteResult(this.commitTimestamp, this.collapsedMutationResults, this.originalMutationInfos, this.stats);
        }
    }
}

