/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.common.base.Equivalence;
import autovalue.shaded.com.google.common.collect.ImmutableBiMap;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableMultimap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import autovalue.shaded.com.google.common.collect.Iterables;
import autovalue.shaded.com.google.common.collect.LinkedListMultimap;
import autovalue.shaded.com.google.common.collect.Multimap;
import com.google.auto.value.processor.AnnotatedTypeMirror;
import com.google.auto.value.processor.AutoValueishProcessor;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.MethodSignature;
import com.google.auto.value.processor.Nullables;
import com.google.auto.value.processor.Optionalish;
import com.google.auto.value.processor.PropertyBuilderClassifier;
import com.google.auto.value.processor.PropertyNames;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeVariables;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class BuilderMethodClassifier<E extends Element> {
    private static final Equivalence<TypeMirror> TYPE_EQUIVALENCE = MoreTypes.equivalence();
    private final ErrorReporter errorReporter;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeMirror builtType;
    private final TypeElement builderType;
    private final ImmutableSet<String> propertiesWithDefaults;
    private final ImmutableMap<String, AnnotatedTypeMirror> rewrittenPropertyTypes;
    private final Set<ExecutableElement> buildMethods = new LinkedHashSet<ExecutableElement>();
    private final Map<String, BuilderSpec.PropertyGetter> builderGetters = new LinkedHashMap<String, BuilderSpec.PropertyGetter>();
    private final Map<String, PropertyBuilderClassifier.PropertyBuilder> propertyNameToPropertyBuilder = new LinkedHashMap<String, PropertyBuilderClassifier.PropertyBuilder>();
    private final Multimap<String, BuilderSpec.PropertySetter> propertyNameToPrefixedSetters = LinkedListMultimap.create();
    private final Multimap<String, BuilderSpec.PropertySetter> propertyNameToUnprefixedSetters = LinkedListMultimap.create();
    private final Nullables nullables;
    private boolean settersPrefixed;

    BuilderMethodClassifier(ErrorReporter errorReporter, ProcessingEnvironment processingEnv, TypeMirror builtType, TypeElement builderType, ImmutableMap<String, AnnotatedTypeMirror> rewrittenPropertyTypes, ImmutableSet<String> propertiesWithDefaults, Nullables nullables) {
        this.errorReporter = errorReporter;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.builtType = builtType;
        this.builderType = builderType;
        this.rewrittenPropertyTypes = rewrittenPropertyTypes;
        this.propertiesWithDefaults = propertiesWithDefaults;
        this.nullables = nullables;
    }

    ImmutableMultimap<String, BuilderSpec.PropertySetter> propertyNameToSetters() {
        return ImmutableMultimap.copyOf(this.settersPrefixed ? this.propertyNameToPrefixedSetters : this.propertyNameToUnprefixedSetters);
    }

    Map<String, PropertyBuilderClassifier.PropertyBuilder> propertyNameToPropertyBuilder() {
        return this.propertyNameToPropertyBuilder;
    }

    ImmutableMap<String, BuilderSpec.PropertyGetter> builderGetters() {
        return ImmutableMap.copyOf(this.builderGetters);
    }

    Set<ExecutableElement> buildMethods() {
        return ImmutableSet.copyOf(this.buildMethods);
    }

    boolean classifyMethods(Iterable<ExecutableElement> methods, boolean autoValueHasToBuilder) {
        Multimap<String, BuilderSpec.PropertySetter> propertyNameToSetter;
        int startErrorCount = this.errorReporter.errorCount();
        for (ExecutableElement method : methods) {
            this.classifyMethod(method);
        }
        if (this.errorReporter.errorCount() > startErrorCount) {
            return false;
        }
        if (this.propertyNameToPrefixedSetters.isEmpty()) {
            propertyNameToSetter = this.propertyNameToUnprefixedSetters;
            this.settersPrefixed = false;
        } else if (this.propertyNameToUnprefixedSetters.isEmpty()) {
            propertyNameToSetter = this.propertyNameToPrefixedSetters;
            this.settersPrefixed = true;
        } else {
            this.errorReporter.reportError(this.propertyNameToUnprefixedSetters.values().iterator().next().getSetter(), "[%sSetNotSet] If any setter methods use the setFoo convention then all must", this.autoWhat());
            return false;
        }
        for (String property : this.rewrittenPropertyTypes.keySet()) {
            boolean hasBuilder;
            TypeMirror propertyType = this.rewrittenPropertyTypes.get(property).getType();
            boolean hasSetter = propertyNameToSetter.containsKey(property);
            PropertyBuilderClassifier.PropertyBuilder propertyBuilder = this.propertyNameToPropertyBuilder.get(property);
            boolean bl = hasBuilder = propertyBuilder != null;
            if (hasBuilder) {
                boolean canMakeBarBuilder = propertyBuilder.getBuiltToBuilder() != null || propertyBuilder.getCopyAll() != null;
                boolean needToMakeBarBuilder = autoValueHasToBuilder || hasSetter;
                if (!needToMakeBarBuilder || canMakeBarBuilder) continue;
                this.errorReporter.reportError(propertyBuilder.getPropertyBuilderMethod(), "[AutoValueCantMakeBuilder] Property builder method returns %1$s but there is no way to make that type from %2$s: %2$s does not have a non-static toBuilder() method that returns %1$s, and %1$s does not have a method addAll or putAll that accepts an argument of type %2$s", propertyBuilder.getBuilderTypeMirror(), propertyType);
                continue;
            }
            if (hasSetter || this.propertiesWithDefaults.contains(property)) continue;
            String setterName = this.settersPrefixed ? BuilderMethodClassifier.prefixWithSet(property) : property;
            this.errorReporter.reportError(this.builderType, "[%sBuilderMissingMethod] Expected a method with this signature: %s %s(%s), or a %sBuilder() method", this.autoWhat(), this.builderType.asType(), setterName, propertyType, property);
        }
        return this.errorReporter.errorCount() == startErrorCount;
    }

    private void classifyMethod(ExecutableElement method) {
        switch (method.getParameters().size()) {
            case 0: {
                this.classifyMethodNoArgs(method);
                break;
            }
            case 1: {
                this.classifyMethodOneArg(method);
                break;
            }
            default: {
                this.errorReporter.reportError(method, "[%sBuilderArgs] Builder methods must have 0 or 1 parameters", this.autoWhat());
            }
        }
    }

    private void classifyMethodNoArgs(ExecutableElement method) {
        Optional<String> getterProperty = this.propertyForBuilderGetter(method);
        if (getterProperty.isPresent()) {
            this.classifyGetter(method, getterProperty.get());
            return;
        }
        String methodName = method.getSimpleName().toString();
        TypeMirror returnType = this.builderMethodReturnType(method).getType();
        if (methodName.endsWith("Builder")) {
            String property;
            String prefix = methodName.substring(0, methodName.length() - "Builder".length());
            String string = property = this.rewrittenPropertyTypes.containsKey(prefix) ? prefix : (String)this.rewrittenPropertyTypes.keySet().stream().filter(p -> PropertyNames.decapitalizeNormally(p).equals(prefix)).findFirst().orElse(null);
            if (property != null) {
                PropertyBuilderClassifier propertyBuilderClassifier = new PropertyBuilderClassifier(this.errorReporter, this.typeUtils, this.elementUtils, this, this::propertyIsNullable, this.rewrittenPropertyTypes, this.nullables);
                Optional<PropertyBuilderClassifier.PropertyBuilder> propertyBuilder = propertyBuilderClassifier.makePropertyBuilder(method, property);
                if (propertyBuilder.isPresent()) {
                    this.propertyNameToPropertyBuilder.put(property, propertyBuilder.get());
                }
                return;
            }
        }
        if (TYPE_EQUIVALENCE.equivalent(returnType, this.builtType)) {
            this.buildMethods.add(method);
        } else {
            this.errorReporter.reportError(method, "[%1$sBuilderNoArg] Method without arguments should be a build method returning %2$s, or a getter method with the same name and type as %3$s, or fooBuilder() where %4$s is %3$s", this.autoWhat(), this.builtType, this.getterMustMatch(), this.fooBuilderMustMatch());
        }
    }

    private void classifyGetter(ExecutableElement builderGetter, String propertyName) {
        TypeMirror originalGetterType = this.rewrittenPropertyTypes.get(propertyName).getType();
        AnnotatedTypeMirror builderGetterType = this.builderMethodReturnType(builderGetter);
        String builderGetterTypeString = TypeEncoder.encodeWithAnnotations(builderGetterType);
        if (TYPE_EQUIVALENCE.equivalent(builderGetterType.getType(), originalGetterType)) {
            this.builderGetters.put(propertyName, new BuilderSpec.PropertyGetter(builderGetter, builderGetterTypeString, null));
            return;
        }
        Optionalish optional = Optionalish.createIfOptional(builderGetterType.getType());
        if (optional != null) {
            TypeMirror boxedOriginalType;
            TypeMirror containedType = optional.getContainedType(this.typeUtils);
            TypeMirror typeMirror = boxedOriginalType = originalGetterType.getKind().isPrimitive() ? this.typeUtils.boxedClass(MoreTypes.asPrimitiveType(originalGetterType)).asType() : null;
            if (TYPE_EQUIVALENCE.equivalent(containedType, originalGetterType) || TYPE_EQUIVALENCE.equivalent(containedType, boxedOriginalType)) {
                this.builderGetters.put(propertyName, new BuilderSpec.PropertyGetter(builderGetter, builderGetterTypeString, optional));
                return;
            }
        }
        this.errorReporter.reportError(builderGetter, "[AutoValueBuilderReturnType] Method matches a property of %1$s but has return type %2$s instead of %3$s or an Optional wrapping of %3$s", this.builtType, builderGetterType, originalGetterType);
    }

    private void classifyMethodOneArg(ExecutableElement method) {
        Multimap<String, BuilderSpec.PropertySetter> propertyNameToSetters;
        Element propertyElement;
        String propertyName;
        String methodName;
        block8: {
            ImmutableBiMap<String, E> propertyElements;
            block9: {
                block7: {
                    if (this.classifyPropertyBuilderOneArg(method)) {
                        return;
                    }
                    methodName = method.getSimpleName().toString();
                    propertyElements = this.propertyElements();
                    propertyName = null;
                    propertyElement = (Element)propertyElements.get(methodName);
                    propertyNameToSetters = null;
                    if (propertyElement == null) break block7;
                    propertyNameToSetters = this.propertyNameToUnprefixedSetters;
                    propertyName = methodName;
                    break block8;
                }
                if (!methodName.startsWith("set") || methodName.length() <= 3) break block9;
                propertyNameToSetters = this.propertyNameToPrefixedSetters;
                propertyName = PropertyNames.decapitalizeLikeJavaBeans(methodName.substring(3));
                propertyElement = (Element)propertyElements.get(propertyName);
                if (propertyElement != null) break block8;
                propertyName = PropertyNames.decapitalizeNormally(methodName.substring(3));
                propertyElement = (Element)propertyElements.get(propertyName);
                break block8;
            }
            propertyNameToSetters = this.propertyNameToUnprefixedSetters;
            for (Map.Entry entry : propertyElements.entrySet()) {
                if (!methodName.equals(PropertyNames.decapitalizeNormally((String)entry.getKey()))) continue;
                propertyName = (String)entry.getKey();
                propertyElement = (Element)entry.getValue();
                break;
            }
        }
        if (propertyElement == null || propertyNameToSetters == null) {
            this.errorReporter.reportError(method, "[%sBuilderWhatProp] Method %s does not correspond to %s", this.autoWhat(), methodName, this.getterMustMatch());
            this.checkForFailedJavaBean(method);
            return;
        }
        Optional<BuilderSpec.Copier> function = this.getSetterFunction(propertyElement, method);
        if (function.isPresent()) {
            MethodSignature methodSignature = MethodSignature.asMemberOf(this.typeUtils, this.builderType, method);
            TypeMirror returnType = methodSignature.returnType().getType();
            if (this.typeUtils.isSubtype(this.builderType.asType(), returnType) && !MoreTypes.isTypeOf(Object.class, returnType)) {
                if (AutoValueishProcessor.nullableAnnotationFor(method, returnType).isPresent()) {
                    this.errorReporter.reportWarning(method, "[%sBuilderSetterNullable] Setter methods always return the Builder so @Nullable is not appropriate", this.autoWhat());
                }
                AnnotatedTypeMirror parameterType = Iterables.getOnlyElement(methodSignature.parameterTypes());
                propertyNameToSetters.put(propertyName, new BuilderSpec.PropertySetter(method, parameterType, function.get()));
            } else {
                this.errorReporter.reportError(method, "[%sBuilderRet] Setter methods must return %s or a supertype", this.autoWhat(), this.builderType.asType());
            }
        }
    }

    private boolean classifyPropertyBuilderOneArg(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (!methodName.endsWith("Builder")) {
            return false;
        }
        String property = methodName.substring(0, methodName.length() - "Builder".length());
        if (!this.rewrittenPropertyTypes.containsKey(property)) {
            return false;
        }
        PropertyBuilderClassifier propertyBuilderClassifier = new PropertyBuilderClassifier(this.errorReporter, this.typeUtils, this.elementUtils, this, this::propertyIsNullable, this.rewrittenPropertyTypes, this.nullables);
        Optional<PropertyBuilderClassifier.PropertyBuilder> maybePropertyBuilder = propertyBuilderClassifier.makePropertyBuilder(method, property);
        maybePropertyBuilder.ifPresent(propertyBuilder -> this.propertyNameToPropertyBuilder.put(property, (PropertyBuilderClassifier.PropertyBuilder)propertyBuilder));
        return maybePropertyBuilder.isPresent();
    }

    private Optional<BuilderSpec.Copier> getSetterFunction(E propertyElement, ExecutableElement setter) {
        VariableElement parameterElement = Iterables.getOnlyElement(setter.getParameters());
        boolean nullableParameter = AutoValueishProcessor.nullableAnnotationFor(parameterElement, parameterElement.asType()).isPresent();
        String property = (String)((ImmutableMap)((Object)this.propertyElements().inverse())).get(propertyElement);
        TypeMirror targetType = this.rewrittenPropertyTypes.get(property).getType();
        TypeMirror parameterType = ((AnnotatedTypeMirror)MethodSignature.asMemberOf(this.typeUtils, this.builderType, setter).parameterTypes().get(0)).getType();
        if (this.typeUtils.isAssignable(parameterType, targetType) && this.typeUtils.isAssignable(targetType, parameterType)) {
            boolean nullableProperty;
            if (nullableParameter && !(nullableProperty = AutoValueishProcessor.nullableAnnotationFor(propertyElement, this.originalPropertyType(propertyElement)).isPresent())) {
                this.errorReporter.reportError(setter, "[%sNullNotNull] Parameter of setter method is @Nullable but %s is not", this.autoWhat(), this.propertyString(propertyElement));
                return Optional.empty();
            }
            if (!parameterElement.asType().getKind().isPrimitive() && this.originalPropertyType(propertyElement).getKind().isPrimitive()) {
                this.errorReporter.reportWarning(setter, "[%sUnnecessaryBoxing] %s is primitive but parameter of setter method is not", this.autoWhat(), this.propertyString(propertyElement));
            }
            return Optional.of(BuilderSpec.Copier.IDENTITY);
        }
        ImmutableList<ExecutableElement> copyOfMethods = this.copyOfMethods(targetType, nullableParameter);
        if (!copyOfMethods.isEmpty()) {
            return this.getConvertingSetterFunction(copyOfMethods, propertyElement, setter, parameterType);
        }
        this.errorReporter.reportError(setter, "[%sGetVsSet] Parameter type %s of setter method should be %s to match %s", this.autoWhat(), parameterType, targetType, this.propertyString(propertyElement));
        return Optional.empty();
    }

    private Optional<BuilderSpec.Copier> getConvertingSetterFunction(ImmutableList<ExecutableElement> copyOfMethods, E propertyElement, ExecutableElement setter, TypeMirror parameterType) {
        String property = (String)((ImmutableMap)((Object)this.propertyElements().inverse())).get(propertyElement);
        DeclaredType targetType = MoreTypes.asDeclared(this.rewrittenPropertyTypes.get(property).getType());
        for (ExecutableElement copyOfMethod : copyOfMethods) {
            Optional<BuilderSpec.Copier> function = this.getConvertingSetterFunction(copyOfMethod, targetType, parameterType);
            if (!function.isPresent()) continue;
            return function;
        }
        String targetTypeSimpleName = targetType.asElement().getSimpleName().toString();
        this.errorReporter.reportError(setter, "[%sGetVsSetOrConvert] Parameter type %s of setter method should be %s to match %s, or it should be a type that can be passed to %s.%s to produce %s", this.autoWhat(), parameterType, targetType, this.propertyString(propertyElement), targetTypeSimpleName, ((ExecutableElement)copyOfMethods.get(0)).getSimpleName(), targetType);
        return Optional.empty();
    }

    private Optional<BuilderSpec.Copier> getConvertingSetterFunction(ExecutableElement copyOfMethod, DeclaredType targetType, TypeMirror parameterType) {
        if (TypeVariables.canAssignStaticMethodResult(copyOfMethod, parameterType, targetType, this.typeUtils)) {
            String method = TypeEncoder.encodeRaw(targetType) + "." + copyOfMethod.getSimpleName();
            Function<String, String> callMethod = s -> method + "(" + s + ")";
            BuilderSpec.Copier copier = method.contains("Nullable") ? BuilderSpec.Copier.acceptingNull(callMethod) : BuilderSpec.Copier.notAcceptingNull(callMethod);
            return Optional.of(copier);
        }
        return Optional.empty();
    }

    private ImmutableList<ExecutableElement> copyOfMethods(TypeMirror targetType, boolean nullableParameter) {
        if (!targetType.getKind().equals((Object)TypeKind.DECLARED)) {
            return ImmutableList.of();
        }
        Optionalish optionalish = Optionalish.createIfOptional(targetType);
        ImmutableSet<String> copyOfNames = optionalish == null ? ImmutableSet.of("copyOfSorted", "copyOf") : ImmutableSet.of(nullableParameter ? optionalish.ofNullable() : "of");
        TypeElement targetTypeElement = MoreElements.asType(this.typeUtils.asElement(targetType));
        ImmutableList.Builder copyOfMethods = ImmutableList.builder();
        for (String copyOfName : copyOfNames) {
            for (ExecutableElement method : ElementFilter.methodsIn(targetTypeElement.getEnclosedElements())) {
                if (!method.getSimpleName().contentEquals(copyOfName) || method.getParameters().size() != 1 || !method.getModifiers().contains((Object)Modifier.STATIC)) continue;
                copyOfMethods.add(method);
            }
        }
        return copyOfMethods.build();
    }

    AnnotatedTypeMirror builderMethodReturnType(ExecutableElement builderMethod) {
        return MethodSignature.asMemberOf(this.typeUtils, this.builderType, builderMethod).returnType();
    }

    private static String prefixWithSet(String propertyName) {
        return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private boolean propertyIsNullable(String property) {
        Element propertyElement = (Element)this.propertyElements().get(property);
        return Stream.of(propertyElement, this.originalPropertyType(propertyElement)).flatMap(ac -> ac.getAnnotationMirrors().stream()).map(a -> a.getAnnotationType().asElement().getSimpleName()).anyMatch(n -> n.contentEquals("Nullable"));
    }

    abstract ImmutableBiMap<String, E> propertyElements();

    abstract TypeMirror originalPropertyType(E var1);

    abstract String propertyString(E var1);

    abstract Optional<String> propertyForBuilderGetter(ExecutableElement var1);

    abstract void checkForFailedJavaBean(ExecutableElement var1);

    abstract String autoWhat();

    abstract String getterMustMatch();

    abstract String fooBuilderMustMatch();
}

