/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.convert;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.Value;
import com.google.cloud.spring.data.datastore.core.convert.DatastoreEntityConverter;
import com.google.cloud.spring.data.datastore.core.convert.DatastoreNativeTypes;
import com.google.cloud.spring.data.datastore.core.convert.ObjectToKeyFactory;
import com.google.cloud.spring.data.datastore.core.convert.ReadWriteConversions;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntity;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentProperty;
import com.google.cloud.spring.data.datastore.core.mapping.EmbeddedType;
import com.google.cloud.spring.data.datastore.core.util.ValueUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TwoStepsConversions
implements ReadWriteConversions {
    private static final Converter<Blob, byte[]> BLOB_TO_BYTE_ARRAY_CONVERTER = new Converter<Blob, byte[]>(){

        public byte[] convert(Blob source) {
            return source.toByteArray();
        }
    };
    private static final Converter<byte[], Blob> BYTE_ARRAY_TO_BLOB_CONVERTER = new Converter<byte[], Blob>(){

        public Blob convert(byte[] source) {
            return Blob.copyFrom((byte[])source);
        }
    };
    private final GenericConversionService conversionService;
    private final GenericConversionService internalConversionService;
    private final CustomConversions customConversions;
    private final ObjectToKeyFactory objectToKeyFactory;
    private final DatastoreMappingContext datastoreMappingContext;
    private DatastoreEntityConverter datastoreEntityConverter;
    private final Map<Class, Optional<Class<?>>> writeConverters = new ConcurrentHashMap();

    public TwoStepsConversions(CustomConversions customConversions, ObjectToKeyFactory objectToKeyFactory, DatastoreMappingContext datastoreMappingContext) {
        this.objectToKeyFactory = objectToKeyFactory;
        this.datastoreMappingContext = datastoreMappingContext;
        this.conversionService = new DefaultConversionService();
        this.internalConversionService = new DefaultConversionService();
        this.customConversions = customConversions;
        this.customConversions.registerConvertersIn((ConverterRegistry)this.conversionService);
        this.internalConversionService.addConverter(BYTE_ARRAY_TO_BLOB_CONVERTER);
        this.internalConversionService.addConverter(BLOB_TO_BYTE_ARRAY_CONVERTER);
    }

    @Override
    public <T> T convertOnRead(Object val, Class targetCollectionType, Class targetComponentType) {
        return this.convertOnRead(val, EmbeddedType.NOT_EMBEDDED, targetCollectionType, TypeInformation.of((Class)targetComponentType));
    }

    @Override
    public <T> T convertOnRead(Object val, EmbeddedType embeddedType, TypeInformation targetTypeInformation) {
        TypeInformation componentTypeInformation;
        Class collectionType = null;
        if (ValueUtil.isCollectionLike(targetTypeInformation.getType())) {
            componentTypeInformation = targetTypeInformation.getComponentType();
            collectionType = targetTypeInformation.getType();
        } else {
            componentTypeInformation = targetTypeInformation;
        }
        return this.convertOnRead(val, embeddedType, collectionType, componentTypeInformation);
    }

    private <T> T convertOnRead(Object val, EmbeddedType embeddedType, Class targetCollectionType, TypeInformation<?> targetComponentType) {
        BiFunction<Object, TypeInformation, Object> readConverter;
        if (val == null) {
            return null;
        }
        switch (embeddedType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EMBEDDED_MAP: {
                BiFunction<Object, TypeInformation, Object> biFunction = (x, typeInformation) -> this.convertOnReadSingleEmbeddedMap(x, Objects.requireNonNull(typeInformation.getComponentType()).getType(), typeInformation.getMapValueType(), targetComponentType);
                break;
            }
            case EMBEDDED_ENTITY: {
                BiFunction<Object, TypeInformation, Object> biFunction = this::convertOnReadSingleEmbedded;
                break;
            }
            case NOT_EMBEDDED: {
                BiFunction<Object, TypeInformation, Object> biFunction = readConverter = this::convertOnReadSingle;
            }
        }
        if (ValueUtil.isCollectionLike(val.getClass()) && targetCollectionType != null && targetComponentType != null) {
            try {
                Assert.isInstanceOf(Iterable.class, (Object)val, (String)"Value passed to convertOnRead expected to be Iterable");
                List<Object> elements = StreamSupport.stream(((Iterable)val).spliterator(), false).map(v -> {
                    Object o = v instanceof Value ? ((Value)v).get() : v;
                    return readConverter.apply(o, targetComponentType);
                }).toList();
                return this.convertCollection(elements, targetCollectionType);
            }
            catch (DatastoreDataException | ConversionException ex) {
                throw new DatastoreDataException("Unable process elements of a collection", (Throwable)ex);
            }
        }
        return (T)readConverter.apply(val, targetComponentType);
    }

    private <T, R> Map<T, R> convertOnReadSingleEmbeddedMap(Object value, Class<T> keyType, TypeInformation<R> targetComponentType, TypeInformation<?> componentType) {
        Assert.notNull((Object)value, (String)"Cannot convert a null value.");
        if (value instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)value;
            return this.datastoreEntityConverter.readAsMap(baseEntity, componentType);
        }
        throw new DatastoreDataException("Embedded entity was expected, but " + value.getClass() + " found");
    }

    private <T> T convertOnReadSingleEmbedded(Object value, TypeInformation<?> targetTypeInformation) {
        Assert.notNull((Object)value, (String)"Cannot convert a null value.");
        if (value instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)value;
            return (T)this.datastoreEntityConverter.read(targetTypeInformation.getType(), baseEntity);
        }
        throw new DatastoreDataException("Embedded entity was expected, but " + value.getClass() + " found");
    }

    private <T> T convertOnReadSingle(Object val, TypeInformation<?> targetTypeInformation) {
        if (val == null) {
            return null;
        }
        Class targetType = ValueUtil.boxIfNeeded(targetTypeInformation.getType());
        Class<?> sourceType = val.getClass();
        Object result = null;
        TypeTargets typeTargets = this.computeTypeTargets(targetType);
        if (typeTargets.getFirstStepTarget() == null && typeTargets.getSecondStepTarget() == null && ClassUtils.isAssignable((Class)targetType, val.getClass())) {
            result = val;
        } else if (typeTargets.getFirstStepTarget() == null && typeTargets.getSecondStepTarget() != null) {
            result = this.internalConversionService.convert(val, targetType);
        } else if (typeTargets.getFirstStepTarget() != null && typeTargets.getSecondStepTarget() == null) {
            result = this.conversionService.convert(val, targetType);
        } else if (typeTargets.getFirstStepTarget() != null && typeTargets.getSecondStepTarget() != null) {
            Object secondStepVal = this.internalConversionService.convert(val, typeTargets.getFirstStepTarget());
            result = this.conversionService.convert(secondStepVal, targetType);
        } else if (DatastoreNativeTypes.isNativeType(sourceType) && this.conversionService.canConvert(sourceType, targetType)) {
            result = this.conversionService.convert(val, targetType);
        } else if (DatastoreNativeTypes.isNativeType(sourceType) && this.internalConversionService.canConvert(sourceType, targetType)) {
            result = this.internalConversionService.convert(val, targetType);
        }
        if (result != null) {
            return (T)result;
        }
        throw new DatastoreDataException("Unable to convert " + val.getClass() + " to " + targetType);
    }

    @Override
    public Value convertOnWrite(Object propertyVal, DatastorePersistentProperty persistentProperty) {
        return this.convertOnWrite(propertyVal, persistentProperty.getEmbeddedType(), persistentProperty.getFieldName(), persistentProperty.getTypeInformation());
    }

    private Value convertOnWrite(Object propertyVal, EmbeddedType embeddedType, String fieldName, TypeInformation typeInformation) {
        Object val = propertyVal;
        Function<Object, Value> writeConverter = this::convertOnWriteSingle;
        if (propertyVal != null) {
            switch (embeddedType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case EMBEDDED_MAP: {
                    Function<Object, Value> function = x -> this.convertOnWriteSingleEmbeddedMap(x, fieldName, typeInformation.getMapValueType());
                    break;
                }
                case EMBEDDED_ENTITY: {
                    Function<Object, Value> function = x -> this.convertOnWriteSingleEmbedded(x, fieldName);
                    break;
                }
                case NOT_EMBEDDED: {
                    Function<Object, Value> function = writeConverter = this::convertOnWriteSingle;
                }
            }
        }
        if ((val = ValueUtil.toListIfArray(val)) instanceof Iterable) {
            Iterable iterable = (Iterable)val;
            ArrayList<Value> values = new ArrayList<Value>();
            for (Object propEltValue : iterable) {
                values.add(writeConverter.apply(propEltValue));
            }
            return ListValue.of(values);
        }
        return writeConverter.apply(val);
    }

    private EntityValue applyEntityValueBuilder(Object val, String kindName, Consumer<FullEntity.Builder> consumer, boolean createKey) {
        FullEntity.Builder builder;
        if (!createKey) {
            builder = FullEntity.newBuilder();
        } else {
            Optional<Object> idProp = Optional.ofNullable(val).map(v -> (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(v.getClass())).map(PersistentEntity::getIdProperty).map(id -> Objects.requireNonNull((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(val.getClass())).getPropertyAccessor(val).getProperty((PersistentProperty)id));
            IncompleteKey key = idProp.isPresent() ? this.objectToKeyFactory.getKeyFromId(idProp.get(), kindName) : this.objectToKeyFactory.getIncompleteKey(kindName);
            builder = FullEntity.newBuilder((IncompleteKey)key);
        }
        consumer.accept(builder);
        return EntityValue.of((FullEntity)builder.build());
    }

    private EntityValue convertOnWriteSingleEmbeddedMap(Object val, String kindName, TypeInformation valueTypeInformation) {
        return this.applyEntityValueBuilder(null, kindName, builder -> {
            for (Map.Entry e : ((Map)val).entrySet()) {
                String field = (String)this.convertOnReadSingle(this.convertOnWriteSingle(e.getKey()).get(), TypeInformation.of(String.class));
                builder.set(field, this.convertOnWrite(e.getValue(), EmbeddedType.of(valueTypeInformation), field, valueTypeInformation));
            }
        }, false);
    }

    private EntityValue convertOnWriteSingleEmbedded(Object val, String kindName) {
        return this.applyEntityValueBuilder(val, kindName, builder -> this.datastoreEntityConverter.write(val, builder), true);
    }

    @Override
    public Value convertOnWriteSingle(Object propertyVal) {
        Object result = propertyVal;
        if (result != null) {
            TypeTargets typeTargets = this.computeTypeTargets(result.getClass());
            if (typeTargets.getFirstStepTarget() != null) {
                result = this.conversionService.convert(propertyVal, typeTargets.getFirstStepTarget());
            }
            if (typeTargets.getSecondStepTarget() != null) {
                result = this.internalConversionService.convert(result, typeTargets.getSecondStepTarget());
            }
        }
        return DatastoreNativeTypes.wrapValue(result);
    }

    private TypeTargets computeTypeTargets(Class<?> firstStepSource) {
        Class firstStepTarget = null;
        Class<?> secondStepTarget = null;
        if (!DatastoreNativeTypes.isNativeType(firstStepSource)) {
            Class effectiveFirstStepTarget;
            Optional<Class<?>> datastoreBasicType;
            Optional simpleType = this.customConversions.getCustomWriteTarget(firstStepSource);
            if (simpleType.isPresent()) {
                firstStepTarget = (Class)simpleType.get();
            }
            if ((datastoreBasicType = this.getCustomWriteTarget(effectiveFirstStepTarget = firstStepTarget != null ? firstStepTarget : firstStepSource)).isPresent()) {
                secondStepTarget = datastoreBasicType.get();
            }
        }
        return new TypeTargets(firstStepTarget, secondStepTarget);
    }

    public <T> T convertCollection(Object collection, Class<?> target) {
        if (collection == null || target == null || ClassUtils.isAssignableValue(target, (Object)collection)) {
            return (T)collection;
        }
        return (T)this.conversionService.convert(collection, target);
    }

    private Optional<Class<?>> getCustomWriteTarget(Class<?> sourceType) {
        if (DatastoreNativeTypes.isNativeType(sourceType)) {
            return Optional.empty();
        }
        return this.writeConverters.computeIfAbsent(sourceType, this::getDatastoreCompatibleType);
    }

    @Override
    public Optional<Class<?>> getDatastoreCompatibleType(Class inputType) {
        if (DatastoreNativeTypes.DATASTORE_NATIVE_TYPES.contains(inputType)) {
            return Optional.of(inputType);
        }
        return DatastoreNativeTypes.DATASTORE_NATIVE_TYPES.stream().filter(simpleType -> this.internalConversionService.canConvert(inputType, simpleType) && this.internalConversionService.canConvert(simpleType, inputType)).findAny();
    }

    @Override
    public void registerEntityConverter(DatastoreEntityConverter datastoreEntityConverter) {
        this.datastoreEntityConverter = datastoreEntityConverter;
    }

    private record TypeTargets(Class<?> firstStepTarget, Class<?> secondStepTarget) {
        Class<?> getFirstStepTarget() {
            return this.firstStepTarget;
        }

        Class<?> getSecondStepTarget() {
            return this.secondStepTarget;
        }
    }
}

