/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.mapping;

import com.google.cloud.spring.data.datastore.core.convert.DatastoreNativeTypes;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntity;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntityImpl;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentProperty;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentPropertyImpl;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;

public class DatastoreMappingContext
extends AbstractMappingContext<DatastorePersistentEntity<?>, DatastorePersistentProperty>
implements ApplicationContextAware {
    private static final FieldNamingStrategy DEFAULT_NAMING_STRATEGY;
    private static final FieldNamingStrategy FIELD_NAMING_STRATEGY;
    private ApplicationContext applicationContext;
    private static final Map<Class, Set<Class>> discriminationFamilies;
    private final boolean skipNullValue;

    public DatastoreMappingContext() {
        this(false);
    }

    public DatastoreMappingContext(boolean skipNullValue) {
        this.setSimpleTypeHolder(DatastoreNativeTypes.HOLDER);
        this.skipNullValue = skipNullValue;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public static void addDiscriminationClassConnection(Class parentClass, Class subClass) {
        Set setParent = discriminationFamilies.computeIfAbsent(parentClass, unused -> new HashSet());
        Set setSubClass = discriminationFamilies.computeIfAbsent(subClass, unused -> new HashSet());
        setParent.add(subClass);
        setSubClass.forEach(x -> {
            if (!discriminationFamilies.get(parentClass).contains(x)) {
                DatastoreMappingContext.addDiscriminationClassConnection(parentClass, x);
            }
        });
        Class grandParent = parentClass.getSuperclass();
        if (grandParent != null) {
            DatastoreMappingContext.addDiscriminationClassConnection(grandParent, subClass);
        }
    }

    public static Set<Class> getDiscriminationFamily(Class clazz) {
        return discriminationFamilies.get(clazz);
    }

    protected <T> DatastorePersistentEntityImpl<T> constructPersistentEntity(TypeInformation<T> typeInformation) {
        return new DatastorePersistentEntityImpl<T>(typeInformation, this);
    }

    protected <T> DatastorePersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        DatastorePersistentEntityImpl<T> persistentEntity = this.constructPersistentEntity(typeInformation);
        if (this.applicationContext != null) {
            persistentEntity.setApplicationContext(this.applicationContext);
        }
        return persistentEntity;
    }

    protected DatastorePersistentProperty createPersistentProperty(Property property, DatastorePersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new DatastorePersistentPropertyImpl(property, (PersistentEntity<?, DatastorePersistentProperty>)owner, simpleTypeHolder, FIELD_NAMING_STRATEGY, this.skipNullValue);
    }

    @NonNull
    public DatastorePersistentEntity<?> getDatastorePersistentEntity(Class<?> entityClass) {
        DatastorePersistentEntity persistentEntity = (DatastorePersistentEntity)this.getPersistentEntity(entityClass);
        if (persistentEntity != null) {
            return persistentEntity;
        }
        throw new DatastoreDataException("Unable to find a DatastorePersistentEntity for: " + entityClass);
    }

    public boolean isSkipNullValue() {
        return this.skipNullValue;
    }

    static {
        FIELD_NAMING_STRATEGY = DEFAULT_NAMING_STRATEGY = PropertyNameFieldNamingStrategy.INSTANCE;
        discriminationFamilies = new ConcurrentHashMap<Class, Set<Class>>();
    }
}

