/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.repository.query;

import com.google.cloud.spring.data.datastore.core.DatastoreOperations;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import com.google.cloud.spring.data.datastore.repository.query.DatastoreQueryMethod;
import com.google.cloud.spring.data.datastore.repository.query.GqlDatastoreQuery;
import com.google.cloud.spring.data.datastore.repository.query.PartTreeDatastoreQuery;
import java.lang.reflect.Method;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class DatastoreQueryLookupStrategy
implements QueryLookupStrategy {
    private final DatastoreOperations datastoreOperations;
    private final DatastoreMappingContext datastoreMappingContext;
    private final ValueExpressionDelegate valueExpressionDelegate;
    private final QueryMethodEvaluationContextProvider queryEvaluationContextProvider;

    public DatastoreQueryLookupStrategy(DatastoreMappingContext datastoreMappingContext, DatastoreOperations datastoreOperations, ValueExpressionDelegate valueExpressionDelegate) {
        Assert.notNull((Object)((Object)datastoreMappingContext), (String)"A non-null DatastoreMappingContext is required.");
        Assert.notNull((Object)datastoreOperations, (String)"A non-null DatastoreOperations is required.");
        Assert.notNull((Object)valueExpressionDelegate, (String)"A non-null ValueExpressionDelegate is required.");
        this.datastoreMappingContext = datastoreMappingContext;
        this.valueExpressionDelegate = valueExpressionDelegate;
        this.queryEvaluationContextProvider = null;
        this.datastoreOperations = datastoreOperations;
    }

    public DatastoreQueryLookupStrategy(DatastoreMappingContext datastoreMappingContext, DatastoreOperations datastoreOperations, QueryMethodEvaluationContextProvider queryEvaluationContextProvider) {
        Assert.notNull((Object)((Object)datastoreMappingContext), (String)"A non-null DatastoreMappingContext is required.");
        Assert.notNull((Object)datastoreOperations, (String)"A non-null DatastoreOperations is required.");
        Assert.notNull((Object)queryEvaluationContextProvider, (String)"A non-null EvaluationContextProvider is required.");
        this.datastoreMappingContext = datastoreMappingContext;
        this.valueExpressionDelegate = null;
        this.queryEvaluationContextProvider = queryEvaluationContextProvider;
        this.datastoreOperations = datastoreOperations;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        DatastoreQueryMethod queryMethod = this.createQueryMethod(method, metadata, projectionFactory);
        Class<?> entityType = this.getEntityType(queryMethod);
        if (queryMethod.hasAnnotatedQuery()) {
            String sql = queryMethod.getQueryAnnotation().value();
            return this.createGqlDatastoreQuery(entityType, queryMethod, sql);
        }
        if (namedQueries.hasQuery(queryMethod.getNamedQueryName())) {
            String sql = namedQueries.getQuery(queryMethod.getNamedQueryName());
            return this.createGqlDatastoreQuery(entityType, queryMethod, sql);
        }
        return new PartTreeDatastoreQuery(queryMethod, this.datastoreOperations, this.datastoreMappingContext, entityType, projectionFactory);
    }

    <T> GqlDatastoreQuery<T> createGqlDatastoreQuery(Class<T> entityType, DatastoreQueryMethod queryMethod, String gql) {
        if (this.valueExpressionDelegate != null) {
            return new GqlDatastoreQuery<T>(entityType, queryMethod, this.datastoreOperations, gql, this.valueExpressionDelegate, this.datastoreMappingContext);
        }
        return new GqlDatastoreQuery<T>(entityType, queryMethod, this.datastoreOperations, gql, this.queryEvaluationContextProvider, this.datastoreMappingContext);
    }

    Class<?> getEntityType(QueryMethod queryMethod) {
        return queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    DatastoreQueryMethod createQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        return new DatastoreQueryMethod(method, metadata, factory);
    }
}

