/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.repository.support;

import com.google.cloud.spring.data.datastore.core.DatastoreOperations;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntity;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntityInformation;
import com.google.cloud.spring.data.datastore.repository.query.DatastoreQueryLookupStrategy;
import com.google.cloud.spring.data.datastore.repository.support.SimpleDatastoreRepository;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DatastoreRepositoryFactory
extends RepositoryFactorySupport
implements ApplicationContextAware {
    private final DatastoreMappingContext datastoreMappingContext;
    private final DatastoreOperations datastoreOperations;
    private ApplicationContext applicationContext;

    DatastoreRepositoryFactory(DatastoreMappingContext datastoreMappingContext, DatastoreOperations datastoreOperations) {
        Assert.notNull((Object)((Object)datastoreMappingContext), (String)"A non-null Datastore mapping context is required.");
        Assert.notNull((Object)datastoreOperations, (String)"A non-null Datastore template object is required.");
        this.datastoreMappingContext = datastoreMappingContext;
        this.datastoreOperations = datastoreOperations;
    }

    public <T, I> EntityInformation<T, I> getEntityInformation(Class<T> domainClass) {
        DatastorePersistentEntity entity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException("Could not lookup mapping metadata for domain class: " + domainClass.getName());
        }
        return new DatastorePersistentEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.datastoreOperations, metadata.getDomainType()});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleDatastoreRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new DatastoreQueryLookupStrategy(this.datastoreMappingContext, this.datastoreOperations, valueExpressionDelegate));
    }

    @Deprecated(since="6.0")
    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new DatastoreQueryLookupStrategy(this.datastoreMappingContext, this.datastoreOperations, this.delegateContextProvider(evaluationContextProvider)));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private QueryMethodEvaluationContextProvider delegateContextProvider(final QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return new QueryMethodEvaluationContextProvider(){

            public <T extends Parameters<?, ?>> EvaluationContext getEvaluationContext(T parameters, Object[] parameterValues) {
                StandardEvaluationContext evaluationContext = (StandardEvaluationContext)evaluationContextProvider.getEvaluationContext(parameters, parameterValues);
                evaluationContext.setRootObject((Object)DatastoreRepositoryFactory.this.applicationContext);
                evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
                evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)DatastoreRepositoryFactory.this.applicationContext));
                return evaluationContext;
            }

            public <T extends Parameters<?, ?>> EvaluationContext getEvaluationContext(T parameters, Object[] parameterValues, ExpressionDependencies expressionDependencies) {
                StandardEvaluationContext evaluationContext = (StandardEvaluationContext)evaluationContextProvider.getEvaluationContext(parameters, parameterValues, expressionDependencies);
                evaluationContext.setRootObject((Object)DatastoreRepositoryFactory.this.applicationContext);
                evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
                evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)DatastoreRepositoryFactory.this.applicationContext));
                return evaluationContext;
            }

            public EvaluationContextProvider getEvaluationContextProvider() {
                return (EvaluationContextProvider)evaluationContextProvider;
            }
        };
    }
}

