/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSitemapGeneratorOptions<THIS extends AbstractSitemapGeneratorOptions<THIS>> {
    File baseDir;
    String baseUrl;
    String fileNamePrefix = "sitemap";
    boolean allowMultipleSitemaps = true;
    W3CDateFormat dateFormat;
    int maxUrls = 50000;
    boolean autoValidate = false;
    boolean gzip = false;

    public AbstractSitemapGeneratorOptions(URL baseUrl, File baseDir) {
        if (baseDir == null) {
            throw new NullPointerException("baseDir may not be null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl may not be null");
        }
        this.baseDir = baseDir;
        this.baseUrl = baseUrl.toString();
    }

    public THIS fileNamePrefix(String fileNamePrefix) {
        if (fileNamePrefix == null) {
            throw new NullPointerException("fileNamePrefix may not be null");
        }
        this.fileNamePrefix = fileNamePrefix;
        return this.getThis();
    }

    public THIS allowMultipleSitemaps(boolean allowMultipleSitemaps) {
        this.allowMultipleSitemaps = allowMultipleSitemaps;
        return this.getThis();
    }

    public THIS dateFormat(W3CDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this.getThis();
    }

    public THIS maxUrls(int maxUrls) {
        if (maxUrls > 50000) {
            throw new RuntimeException("You can only have 50,000 URLs per sitemap; to use more, allowMultipleSitemaps and generate a sitemap index. You asked for " + maxUrls);
        }
        this.maxUrls = maxUrls;
        return this.getThis();
    }

    public THIS autoValidate(boolean autoValidate) {
        this.autoValidate = autoValidate;
        return this.getThis();
    }

    public THIS gzip(boolean gzip) {
        this.gzip = gzip;
        return this.getThis();
    }

    THIS getThis() {
        return (THIS)this;
    }
}

