/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.AbstractSitemapUrlRenderer;
import com.redfin.sitemapgenerator.GoogleGeoSitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.SitemapGenerator;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.SitemapGeneratorOptions;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleGeoSitemapGenerator
extends SitemapGenerator<GoogleGeoSitemapUrl, GoogleGeoSitemapGenerator> {
    public static SitemapGeneratorBuilder<GoogleGeoSitemapGenerator> builder(URL baseUrl, File baseDir) {
        return new SitemapGeneratorBuilder<GoogleGeoSitemapGenerator>(baseUrl, baseDir, GoogleGeoSitemapGenerator.class);
    }

    public static SitemapGeneratorBuilder<GoogleGeoSitemapGenerator> builder(String baseUrl, File baseDir) throws MalformedURLException {
        return new SitemapGeneratorBuilder<GoogleGeoSitemapGenerator>(baseUrl, baseDir, GoogleGeoSitemapGenerator.class);
    }

    GoogleGeoSitemapGenerator(AbstractSitemapGeneratorOptions<?> options) {
        super(options, new Renderer());
    }

    public GoogleGeoSitemapGenerator(String baseUrl, File baseDir) throws MalformedURLException {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleGeoSitemapGenerator(URL baseUrl, File baseDir) {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Renderer
    extends AbstractSitemapUrlRenderer<GoogleGeoSitemapUrl>
    implements ISitemapUrlRenderer<GoogleGeoSitemapUrl> {
        private Renderer() {
        }

        @Override
        public Class<GoogleGeoSitemapUrl> getUrlClass() {
            return GoogleGeoSitemapUrl.class;
        }

        @Override
        public void render(GoogleGeoSitemapUrl url, OutputStreamWriter out, W3CDateFormat dateFormat) throws IOException {
            StringBuilder sb = new StringBuilder();
            sb.append("    <geo:geo>\n");
            sb.append("      <geo:format>" + (Object)((Object)url.getFormat()) + "</geo:format>\n");
            sb.append("    </geo:geo>\n");
            super.render(url, out, dateFormat, sb.toString());
        }

        @Override
        public String getXmlNamespaces() {
            return "xmlns:geo=\"http://www.google.com/geo/schemas/sitemap/1.0\"";
        }
    }
}

