/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapUrlOptions;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;

public class GoogleNewsSitemapUrl
extends WebSitemapUrl {
    private final Date publicationDate;
    private final String keywords;

    public GoogleNewsSitemapUrl(URL url, Date publicationDate) {
        this(new Options(url, publicationDate));
    }

    public GoogleNewsSitemapUrl(String url, Date publicationDate) throws MalformedURLException {
        this(new Options(url, publicationDate));
    }

    public GoogleNewsSitemapUrl(Options options) {
        super(options);
        this.publicationDate = options.publicationDate;
        this.keywords = options.keywords;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public String getKeywords() {
        return this.keywords;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Options
    extends AbstractSitemapUrlOptions<GoogleNewsSitemapUrl, Options> {
        private Date publicationDate;
        private String keywords;

        public Options(String url, Date publicationDate) throws MalformedURLException {
            this(new URL(url), publicationDate);
        }

        public Options(URL url, Date publicationDate) {
            super(url, GoogleNewsSitemapUrl.class);
            if (publicationDate == null) {
                throw new NullPointerException("publicationDate must not be null");
            }
            this.publicationDate = publicationDate;
        }

        public Options keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public Options keywords(Iterable<String> keywords) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String keyword : keywords) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(keyword);
            }
            this.keywords = sb.toString();
            return this;
        }

        public Options keywords(String ... keywords) {
            return this.keywords(Arrays.asList(keywords));
        }
    }
}

