/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.Binds;
import dagger.BindsInstance;
import dagger.Component;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingGraphPlugins;
import dagger.internal.codegen.BindingGraphPluginsModule;
import dagger.internal.codegen.BindingGraphValidationModule;
import dagger.internal.codegen.BindingMethodProcessingStep;
import dagger.internal.codegen.BindingMethodValidatorsModule;
import dagger.internal.codegen.BindsInstanceProcessingStep;
import dagger.internal.codegen.CanReleaseReferencesProcessingStep;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentHjarProcessingStep;
import dagger.internal.codegen.ComponentProcessingStep;
import dagger.internal.codegen.DaggerComponentProcessor_ProcessorComponent;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.ForReleasableReferencesValidator;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.InjectBindingRegistryImpl;
import dagger.internal.codegen.InjectProcessingStep;
import dagger.internal.codegen.MapKeyProcessingStep;
import dagger.internal.codegen.MembersInjectorGenerator;
import dagger.internal.codegen.ModuleProcessingStep;
import dagger.internal.codegen.MonitoringModuleProcessingStep;
import dagger.internal.codegen.MultibindingAnnotationsProcessingStep;
import dagger.internal.codegen.ProcessingEnvironmentModule;
import dagger.internal.codegen.ProductionExecutorModuleProcessingStep;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.Validation;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.spi.BindingGraphPlugin;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;

public class ComponentProcessor
extends BasicAnnotationProcessor {
    private final Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;
    @Inject
    InjectBindingRegistry injectBindingRegistry;
    @Inject
    FactoryGenerator factoryGenerator;
    @Inject
    MembersInjectorGenerator membersInjectorGenerator;
    @Inject
    ImmutableList<BasicAnnotationProcessor.ProcessingStep> processingSteps;
    @Inject
    BindingGraphPlugins spiPlugins;
    @Inject
    @Validation
    BindingGraphPlugins validationPlugins;

    public ComponentProcessor() {
        this.testingPlugins = Optional.empty();
    }

    private ComponentProcessor(Iterable<BindingGraphPlugin> testingPlugins) {
        this.testingPlugins = Optional.of(ImmutableSet.copyOf(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(BindingGraphPlugin ... testingPlugins) {
        return ComponentProcessor.forTesting(Arrays.asList(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(Iterable<BindingGraphPlugin> testingPlugins) {
        return new ComponentProcessor(testingPlugins);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        ImmutableSet.Builder options = ImmutableSet.builder();
        options.addAll(CompilerOptions.SUPPORTED_OPTIONS);
        options.addAll(this.spiPlugins.allSupportedOptions());
        options.addAll(this.validationPlugins.allSupportedOptions());
        return options.build();
    }

    @Override
    protected Iterable<? extends BasicAnnotationProcessor.ProcessingStep> initSteps() {
        ProcessorComponent.builder().processingEnvironmentModule(new ProcessingEnvironmentModule(this.processingEnv)).testingPlugins(this.testingPlugins).build().inject(this);
        this.spiPlugins.initializePlugins();
        this.validationPlugins.initializePlugins();
        return this.processingSteps;
    }

    @Override
    protected void postRound(RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            try {
                this.injectBindingRegistry.generateSourcesForRequiredBindings(this.factoryGenerator, this.membersInjectorGenerator);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(this.processingEnv.getMessager());
            }
        }
    }

    @Module
    static interface ProcessingStepsModule {
        @Provides
        public static ImmutableList<BasicAnnotationProcessor.ProcessingStep> processingSteps(MapKeyProcessingStep mapKeyProcessingStep, ForReleasableReferencesValidator forReleasableReferencesValidator, CanReleaseReferencesProcessingStep canReleaseReferencesProcessingStep, InjectProcessingStep injectProcessingStep, MonitoringModuleProcessingStep monitoringModuleProcessingStep, ProductionExecutorModuleProcessingStep productionExecutorModuleProcessingStep, MultibindingAnnotationsProcessingStep multibindingAnnotationsProcessingStep, BindsInstanceProcessingStep bindsInstanceProcessingStep, ModuleProcessingStep moduleProcessingStep, ComponentProcessingStep componentProcessingStep, ComponentHjarProcessingStep componentHjarProcessingStep, BindingMethodProcessingStep bindingMethodProcessingStep, CompilerOptions compilerOptions) {
            return ImmutableList.of((Object)mapKeyProcessingStep, (Object)forReleasableReferencesValidator, (Object)canReleaseReferencesProcessingStep, (Object)injectProcessingStep, (Object)monitoringModuleProcessingStep, (Object)productionExecutorModuleProcessingStep, (Object)multibindingAnnotationsProcessingStep, (Object)bindsInstanceProcessingStep, (Object)moduleProcessingStep, (Object)(compilerOptions.headerCompilation() ? componentHjarProcessingStep : componentProcessingStep), (Object)bindingMethodProcessingStep);
        }

        @Binds
        public InjectBindingRegistry injectBindingRegistry(InjectBindingRegistryImpl var1);
    }

    @Singleton
    @Component(modules={ProcessingEnvironmentModule.class, BindingGraphPluginsModule.class, BindingGraphValidationModule.class, BindingMethodValidatorsModule.class, ProcessingStepsModule.class})
    static interface ProcessorComponent {
        public void inject(ComponentProcessor var1);

        public static Builder builder() {
            return DaggerComponentProcessor_ProcessorComponent.builder();
        }

        @CanIgnoreReturnValue
        @Component.Builder
        public static interface Builder {
            public Builder processingEnvironmentModule(ProcessingEnvironmentModule var1);

            @BindsInstance
            public Builder testingPlugins(@BindingGraphPlugins.TestingPlugins Optional<ImmutableSet<BindingGraphPlugin>> var1);

            @CheckReturnValue
            public ProcessorComponent build();
        }
    }
}

