/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.Module;
import dagger.Subcomponent;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.MoreAnnotationValues;
import dagger.producers.ProducerModule;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

final class ConfigurationAnnotations {
    private static final String MODULES_ATTRIBUTE = "modules";
    private static final String DEPENDENCIES_ATTRIBUTE = "dependencies";
    private static final String INCLUDES_ATTRIBUTE = "includes";
    private static final String SUBCOMPONENTS_ATTRIBUTE = "subcomponents";
    private static final String INJECTS_ATTRIBUTE = "injects";

    static Optional<AnnotationMirror> getComponentAnnotation(TypeElement component) {
        return DaggerElements.getAnyAnnotation(component, Component.class, ProductionComponent.class);
    }

    static Optional<AnnotationMirror> getSubcomponentAnnotation(TypeElement subcomponent) {
        return DaggerElements.getAnyAnnotation(subcomponent, Subcomponent.class, ProductionSubcomponent.class);
    }

    static Optional<AnnotationMirror> getComponentOrSubcomponentAnnotation(TypeElement type) {
        Optional<AnnotationMirror> componentAnnotation = ConfigurationAnnotations.getComponentAnnotation(type);
        if (componentAnnotation.isPresent()) {
            return componentAnnotation;
        }
        return ConfigurationAnnotations.getSubcomponentAnnotation(type);
    }

    static boolean isSubcomponent(Element element) {
        return DaggerElements.isAnyAnnotationPresent(element, Subcomponent.class, ProductionSubcomponent.class);
    }

    static Optional<TypeElement> getSubcomponentBuilder(TypeElement subcomponent) {
        Preconditions.checkArgument((boolean)ConfigurationAnnotations.isSubcomponent(subcomponent));
        for (TypeElement nestedType : ElementFilter.typesIn(subcomponent.getEnclosedElements())) {
            if (!ConfigurationAnnotations.isSubcomponentBuilder(nestedType)) continue;
            return Optional.of(nestedType);
        }
        return Optional.empty();
    }

    static boolean isSubcomponentBuilder(Element element) {
        return DaggerElements.isAnyAnnotationPresent(element, Subcomponent.Builder.class, ProductionSubcomponent.Builder.class);
    }

    static ImmutableList<AnnotationValue> getModules(TypeElement annotatedType, AnnotationMirror annotation) {
        if (ComponentDescriptor.Kind.forAnnotatedElement(annotatedType).isPresent()) {
            return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, MODULES_ATTRIBUTE));
        }
        if (ModuleDescriptor.Kind.forAnnotatedElement(annotatedType).isPresent()) {
            return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, INCLUDES_ATTRIBUTE));
        }
        throw new IllegalArgumentException(String.format("unsupported annotation: %s", annotation));
    }

    static ImmutableList<TypeMirror> getComponentModules(AnnotationMirror componentAnnotation) {
        Preconditions.checkNotNull((Object)componentAnnotation);
        return MoreAnnotationMirrors.getTypeListValue(componentAnnotation, MODULES_ATTRIBUTE);
    }

    static ImmutableList<TypeMirror> getComponentDependencies(AnnotationMirror componentAnnotation) {
        Preconditions.checkNotNull((Object)componentAnnotation);
        return MoreAnnotationMirrors.getTypeListValue(componentAnnotation, DEPENDENCIES_ATTRIBUTE);
    }

    static Optional<AnnotationMirror> getModuleAnnotation(TypeElement moduleElement) {
        return DaggerElements.getAnyAnnotation(moduleElement, Module.class, ProducerModule.class);
    }

    static ImmutableList<TypeMirror> getModuleIncludes(AnnotationMirror moduleAnnotation) {
        Preconditions.checkNotNull((Object)moduleAnnotation);
        return MoreAnnotationMirrors.getTypeListValue(moduleAnnotation, INCLUDES_ATTRIBUTE);
    }

    static ImmutableList<TypeMirror> getModuleSubcomponents(AnnotationMirror moduleAnnotation) {
        Preconditions.checkNotNull((Object)moduleAnnotation);
        return MoreAnnotationMirrors.getTypeListValue(moduleAnnotation, SUBCOMPONENTS_ATTRIBUTE);
    }

    static ImmutableList<TypeMirror> getModuleInjects(AnnotationMirror moduleAnnotation) {
        Preconditions.checkNotNull((Object)moduleAnnotation);
        return MoreAnnotationMirrors.getTypeListValue(moduleAnnotation, INJECTS_ATTRIBUTE);
    }

    static Optional<DeclaredType> getNullableType(Element element) {
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
            return Optional.of(annotationMirror.getAnnotationType());
        }
        return Optional.empty();
    }

    @Deprecated
    static ImmutableSet<TypeElement> getTransitiveModules(Types types, DaggerElements elements, Iterable<TypeElement> seedModules) {
        TypeMirror objectType = elements.getTypeElement(Object.class).asType();
        ArrayDeque<TypeElement> moduleQueue = new ArrayDeque<TypeElement>();
        Iterables.addAll(moduleQueue, seedModules);
        LinkedHashSet moduleElements = Sets.newLinkedHashSet();
        TypeElement moduleElement = (TypeElement)moduleQueue.poll();
        while (moduleElement != null) {
            Optional<AnnotationMirror> moduleMirror = ConfigurationAnnotations.getModuleAnnotation(moduleElement);
            if (moduleMirror.isPresent()) {
                ImmutableSet.Builder moduleDependenciesBuilder = ImmutableSet.builder();
                moduleDependenciesBuilder.addAll(MoreTypes.asTypeElements(ConfigurationAnnotations.getModuleIncludes(moduleMirror.get())));
                ConfigurationAnnotations.addIncludesFromSuperclasses(types, moduleElement, (ImmutableSet.Builder<TypeElement>)moduleDependenciesBuilder, objectType);
                ImmutableSet moduleDependencies = moduleDependenciesBuilder.build();
                moduleElements.add(moduleElement);
                for (TypeElement dependencyType : moduleDependencies) {
                    if (moduleElements.contains(dependencyType)) continue;
                    moduleQueue.add(dependencyType);
                }
            }
            moduleElement = (TypeElement)moduleQueue.poll();
        }
        return ImmutableSet.copyOf((Collection)moduleElements);
    }

    static ImmutableList<DeclaredType> enclosedBuilders(TypeElement typeElement, Class<? extends Annotation> annotation) {
        ImmutableList.Builder builders = ImmutableList.builder();
        for (TypeElement element : ElementFilter.typesIn(typeElement.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(element, annotation)) continue;
            builders.add((Object)MoreTypes.asDeclared(element.asType()));
        }
        return builders.build();
    }

    private static void addIncludesFromSuperclasses(Types types, TypeElement element, ImmutableSet.Builder<TypeElement> builder, TypeMirror objectType) {
        TypeMirror superclass = element.getSuperclass();
        while (!types.isSameType(objectType, superclass) && superclass.getKind().equals((Object)TypeKind.DECLARED)) {
            element = MoreElements.asType(types.asElement(superclass));
            ConfigurationAnnotations.getModuleAnnotation(element).ifPresent(moduleMirror -> builder.addAll(MoreTypes.asTypeElements(ConfigurationAnnotations.getModuleIncludes(moduleMirror))));
            superclass = element.getSuperclass();
        }
    }

    private ConfigurationAnnotations() {
    }
}

