/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.SuccessorsFunction;
import java.util.ArrayDeque;
import java.util.HashMap;

final class DaggerGraphs {
    static <N> ImmutableList<N> shortestPath(SuccessorsFunction<N> graph, N nodeU, N nodeV) {
        if (nodeU.equals(nodeV)) {
            return ImmutableList.of(nodeU);
        }
        ImmutableSet successors = ImmutableSet.copyOf((Iterable)graph.successors(nodeU));
        if (successors.contains(nodeV)) {
            return ImmutableList.of(nodeU, nodeV);
        }
        HashMap<Object, Object> visitedNodeToPathPredecessor = new HashMap<Object, Object>();
        ArrayDeque currentNodes = new ArrayDeque();
        ArrayDeque nextNodes = new ArrayDeque();
        for (Object node : successors) {
            visitedNodeToPathPredecessor.put(node, nodeU);
        }
        currentNodes.addAll(successors);
        while (!currentNodes.isEmpty()) {
            while (!currentNodes.isEmpty()) {
                Object currentNode = currentNodes.remove();
                for (Object nextNode : graph.successors(currentNode)) {
                    if (visitedNodeToPathPredecessor.containsKey(nextNode)) continue;
                    visitedNodeToPathPredecessor.put(nextNode, currentNode);
                    if (nextNode.equals(nodeV)) {
                        ImmutableList.Builder builder = ImmutableList.builder();
                        Object node = nodeV;
                        builder.add(node);
                        while (!node.equals(nodeU)) {
                            node = visitedNodeToPathPredecessor.get(node);
                            builder.add(node);
                        }
                        return builder.build().reverse();
                    }
                    nextNodes.add(nextNode);
                }
            }
            ArrayDeque emptyQueue = currentNodes;
            currentNodes = nextNodes;
            nextNodes = emptyQueue;
        }
        return ImmutableList.of();
    }

    private DaggerGraphs() {
    }
}

