/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;

final class InjectBindingValidation
implements BindingGraphPlugin {
    private final InjectValidator injectValidator;

    @Inject
    InjectBindingValidation(InjectValidator injectValidator) {
        this.injectValidator = injectValidator.whenGeneratingCode();
    }

    public String pluginName() {
        return "Dagger/InjectBinding";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        bindingGraph.bindingNodes().stream().filter(node -> node.binding().kind().equals((Object)BindingKind.INJECTION)).forEach(node -> this.validateInjectionBinding((BindingGraph.BindingNode)node, diagnosticReporter));
    }

    private void validateInjectionBinding(BindingGraph.BindingNode node, DiagnosticReporter diagnosticReporter) {
        ValidationReport<TypeElement> typeReport = this.injectValidator.validateType(MoreTypes.asTypeElement(node.binding().key().type()));
        for (ValidationReport.Item item : typeReport.allItems()) {
            diagnosticReporter.reportBinding(item.kind(), node, item.message());
        }
    }
}

