/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.DaggerTypes;
import dagger.model.BindingGraph;
import dagger.shaded.auto.common.MoreElements;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;

final class MembersInjectionBindingValidation
implements BindingGraphPlugin {
    private final DaggerTypes types;
    private static final TypeVisitor<Boolean, Void> DECLARED_OR_ARRAY = new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

        @Override
        public Boolean visitArray(ArrayType arrayType, Void p) {
            return arrayType.getComponentType().accept(new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

                @Override
                public Boolean visitDeclared(DeclaredType declaredType, Void p) {
                    for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                        if (typeMirror.accept(this, null).booleanValue()) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public Boolean visitArray(ArrayType arrayType, Void p) {
                    return arrayType.getComponentType().accept(this, null);
                }

                @Override
                public Boolean visitPrimitive(PrimitiveType primitiveType, Void p) {
                    return true;
                }
            }, null);
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            return true;
        }
    };

    @Inject
    MembersInjectionBindingValidation(DaggerTypes types) {
        this.types = types;
    }

    public String pluginName() {
        return "Dagger/MembersInjection";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        for (BindingGraph.BindingNode bindingNode : bindingGraph.bindingNodes()) {
            this.membersInjectedType(bindingNode).ifPresent(type -> this.validateMembersInjectionType((TypeMirror)type, bindingNode, diagnosticReporter));
        }
    }

    private Optional<TypeMirror> membersInjectedType(BindingGraph.BindingNode bindingNode) {
        switch (bindingNode.binding().kind()) {
            case MEMBERS_INJECTION: {
                return Optional.of(bindingNode.binding().key().type());
            }
            case MEMBERS_INJECTOR: {
                return Optional.of(this.types.unwrapType(bindingNode.binding().key().type()));
            }
        }
        return Optional.empty();
    }

    private void validateMembersInjectionType(TypeMirror membersInjectedType, final BindingGraph.BindingNode bindingNode, final DiagnosticReporter diagnosticReporter) {
        membersInjectedType.accept(new SimpleTypeVisitor8<Void, Void>(){

            @Override
            protected Void defaultAction(TypeMirror e, Void v) {
                diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, bindingNode, "Cannot inject members into %s", (Object)e, new Object[0]);
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType type, Void v) {
                if (type.getTypeArguments().isEmpty()) {
                    if (!MoreElements.asType(type.asElement()).getTypeParameters().isEmpty()) {
                        diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, bindingNode, "Cannot inject members into raw type %s", (Object)type, new Object[0]);
                    }
                } else {
                    for (TypeMirror typeMirror : type.getTypeArguments()) {
                        if (((Boolean)typeMirror.accept(DECLARED_OR_ARRAY, null)).booleanValue()) continue;
                        diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, bindingNode, "Cannot inject members into types with unbounded type arguments: %s", (Object)type, new Object[0]);
                    }
                }
                return null;
            }
        }, null);
    }
}

