/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SourceFiles;
import dagger.producers.Produced;

final class SetFactoryCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final GeneratedComponentModel generatedComponentModel;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final BindingGraph graph;
    private final ContributionBinding binding;

    SetFactoryCreationExpression(ContributionBinding binding, GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions componentBindingExpressions, BindingGraph graph) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
    }

    @Override
    public CodeBlock creationExpression() {
        boolean useRawType;
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.setFactoryClassName(this.binding)});
        boolean bl = useRawType = !this.generatedComponentModel.isTypeAccessible(this.binding.key().type());
        if (!useRawType) {
            SetType setType = SetType.from(this.binding.key());
            builder.add("<$T>", new Object[]{setType.elementsAreTypeOf(Produced.class) ? setType.unwrappedElementType(Produced.class) : setType.elementType()});
        }
        int individualProviders = 0;
        int setProviders = 0;
        CodeBlock.Builder builderMethodCalls = CodeBlock.builder();
        for (FrameworkDependency frameworkDependency : this.binding.frameworkDependencies()) {
            String methodName;
            ContributionType contributionType = ((ResolvedBindings)this.graph.contributionBindings().get((Object)frameworkDependency.key())).contributionType();
            String methodNameSuffix = frameworkDependency.frameworkClass().getSimpleName();
            switch (contributionType) {
                case SET: {
                    ++individualProviders;
                    methodName = "add" + methodNameSuffix;
                    break;
                }
                case SET_VALUES: {
                    ++setProviders;
                    methodName = "addCollection" + methodNameSuffix;
                    break;
                }
                default: {
                    throw new AssertionError((Object)(frameworkDependency + " is not a set multibinding"));
                }
            }
            CodeBlock argument = this.componentBindingExpressions.getDependencyExpression(frameworkDependency, this.generatedComponentModel.name()).codeBlock();
            builderMethodCalls.add(".$L($L)", new Object[]{methodName, useRawType ? CodeBlocks.cast(argument, frameworkDependency.frameworkClass()) : argument});
        }
        builder.add("builder($L, $L)", new Object[]{individualProviders, setProviders});
        builder.add(builderMethodCalls.build());
        return builder.add(".build()", new Object[0]).build();
    }

    @Override
    public boolean useInnerSwitchingProvider() {
        return !this.binding.dependencies().isEmpty();
    }
}

