/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AutoValue_BindingRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.RequestKinds;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

@AutoValue
abstract class BindingRequest {
    BindingRequest() {
    }

    static BindingRequest bindingRequest(DependencyRequest dependencyRequest) {
        return BindingRequest.bindingRequest(dependencyRequest.key(), dependencyRequest.kind());
    }

    static BindingRequest bindingRequest(Key key, RequestKind requestKind) {
        return new AutoValue_BindingRequest(key, Optional.of(requestKind), FrameworkType.forRequestKind(requestKind));
    }

    static BindingRequest bindingRequest(Key key, FrameworkType frameworkType) {
        return new AutoValue_BindingRequest(key, frameworkType.requestKind(), Optional.of(frameworkType));
    }

    static BindingRequest bindingRequest(FrameworkDependency frameworkDependency) {
        return BindingRequest.bindingRequest(frameworkDependency.key(), frameworkDependency.frameworkType());
    }

    abstract Key key();

    abstract Optional<RequestKind> requestKind();

    abstract Optional<FrameworkType> frameworkType();

    final boolean isRequestKind(RequestKind requestKind) {
        return requestKind.equals(this.requestKind().orElse(null));
    }

    final TypeName typeName() {
        TypeName keyTypeName = TypeName.get((TypeMirror)this.key().type());
        if (this.requestKind().isPresent()) {
            return RequestKinds.requestTypeName(this.requestKind().get(), keyTypeName);
        }
        return this.frameworkType().get().frameworkClassOf(keyTypeName);
    }

    final String kindName() {
        Object requestKindObject = this.requestKind().isPresent() ? this.requestKind().get() : this.frameworkType().get();
        return requestKindObject.toString();
    }
}

