/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentInstanceBindingExpression;
import dagger.internal.codegen.ComponentMethodBindingExpression;
import dagger.internal.codegen.ComponentProvisionBindingExpression;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementBindingExpression;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DelegateBindingExpression;
import dagger.internal.codegen.DelegatingFrameworkInstanceCreationExpression;
import dagger.internal.codegen.DependencyMethodProducerCreationExpression;
import dagger.internal.codegen.DependencyMethodProviderCreationExpression;
import dagger.internal.codegen.DerivedFromFrameworkInstanceBindingExpression;
import dagger.internal.codegen.DoubleCheckedMethodImplementation;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.FrameworkInstanceBindingExpression;
import dagger.internal.codegen.FrameworkInstanceSupplier;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ImmediateFutureBindingExpression;
import dagger.internal.codegen.InjectionOrProvisionProviderCreationExpression;
import dagger.internal.codegen.InnerSwitchingProviders;
import dagger.internal.codegen.InstanceFactoryCreationExpression;
import dagger.internal.codegen.MapBindingExpression;
import dagger.internal.codegen.MapFactoryCreationExpression;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.MembersInjectionBindingExpression;
import dagger.internal.codegen.MembersInjectionMethods;
import dagger.internal.codegen.MembersInjectorProviderCreationExpression;
import dagger.internal.codegen.MethodBindingExpression;
import dagger.internal.codegen.ModifiableBindingExpressions;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.OptionalBindingExpression;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.OptionalFactoryInstanceCreationExpression;
import dagger.internal.codegen.PrivateMethodBindingExpression;
import dagger.internal.codegen.ProducerCreationExpression;
import dagger.internal.codegen.ProducerFromProviderCreationExpression;
import dagger.internal.codegen.ProducerNodeInstanceBindingExpression;
import dagger.internal.codegen.ProviderInstanceBindingExpression;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ReferenceReleasingManagerFields;
import dagger.internal.codegen.ReleasableReferenceManagerProviderCreationExpression;
import dagger.internal.codegen.ReleasableReferenceManagerSetProviderCreationExpression;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SetBindingExpression;
import dagger.internal.codegen.SetFactoryCreationExpression;
import dagger.internal.codegen.SimpleMethodBindingExpression;
import dagger.internal.codegen.SingleCheckedMethodImplementation;
import dagger.internal.codegen.StaticSwitchingProviders;
import dagger.internal.codegen.SubcomponentBuilderBindingExpression;
import dagger.internal.codegen.SubcomponentBuilderProviderCreationExpression;
import dagger.internal.codegen.TypeNames;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.MoreTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class ComponentBindingExpressions {
    private final Optional<ComponentBindingExpressions> parent;
    private final BindingGraph graph;
    private final GeneratedComponentModel generatedComponentModel;
    private final ComponentRequirementFields componentRequirementFields;
    private final ReferenceReleasingManagerFields referenceReleasingManagerFields;
    private final OptionalFactories optionalFactories;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final CompilerOptions compilerOptions;
    private final MembersInjectionMethods membersInjectionMethods;
    private final InnerSwitchingProviders innerSwitchingProviders;
    private final StaticSwitchingProviders staticSwitchingProviders;
    private final ModifiableBindingExpressions modifiableBindingExpressions;
    private final Map<BindingRequest, BindingExpression> expressions = new HashMap<BindingRequest, BindingExpression>();

    ComponentBindingExpressions(BindingGraph graph, GeneratedComponentModel generatedComponentModel, ComponentRequirementFields componentRequirementFields, OptionalFactories optionalFactories, DaggerTypes types, DaggerElements elements, CompilerOptions compilerOptions) {
        this(Optional.empty(), graph, generatedComponentModel, componentRequirementFields, new ReferenceReleasingManagerFields(graph, generatedComponentModel, compilerOptions), new StaticSwitchingProviders(generatedComponentModel, types), optionalFactories, types, elements, compilerOptions);
    }

    private ComponentBindingExpressions(Optional<ComponentBindingExpressions> parent, BindingGraph graph, GeneratedComponentModel generatedComponentModel, ComponentRequirementFields componentRequirementFields, ReferenceReleasingManagerFields referenceReleasingManagerFields, StaticSwitchingProviders staticSwitchingProviders, OptionalFactories optionalFactories, DaggerTypes types, DaggerElements elements, CompilerOptions compilerOptions) {
        this.parent = parent;
        this.graph = graph;
        this.generatedComponentModel = generatedComponentModel;
        this.componentRequirementFields = (ComponentRequirementFields)Preconditions.checkNotNull((Object)componentRequirementFields);
        this.referenceReleasingManagerFields = (ReferenceReleasingManagerFields)Preconditions.checkNotNull((Object)referenceReleasingManagerFields);
        this.optionalFactories = (OptionalFactories)Preconditions.checkNotNull((Object)optionalFactories);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
        this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
        this.membersInjectionMethods = new MembersInjectionMethods(generatedComponentModel, this, graph, elements, types);
        this.innerSwitchingProviders = new InnerSwitchingProviders(generatedComponentModel, this, types);
        this.staticSwitchingProviders = staticSwitchingProviders;
        this.modifiableBindingExpressions = new ModifiableBindingExpressions(parent.map(cbe -> cbe.modifiableBindingExpressions), this, graph, generatedComponentModel, compilerOptions);
    }

    ComponentBindingExpressions forChildComponent(BindingGraph childGraph, GeneratedComponentModel childComponentModel, ComponentRequirementFields childComponentRequirementFields) {
        return new ComponentBindingExpressions(Optional.of(this), childGraph, childComponentModel, childComponentRequirementFields, this.referenceReleasingManagerFields, this.staticSwitchingProviders, this.optionalFactories, this.types, this.elements, this.compilerOptions);
    }

    ModifiableBindingExpressions modifiableBindingExpressions() {
        return this.modifiableBindingExpressions;
    }

    Expression getDependencyExpression(BindingRequest request, ClassName requestingClass) {
        return this.getBindingExpression(request).getDependencyExpression(requestingClass);
    }

    Expression getDependencyExpressionForComponentMethod(BindingRequest request, ComponentDescriptor.ComponentMethodDescriptor componentMethod, GeneratedComponentModel componentModel) {
        return this.getBindingExpression(request).getDependencyExpressionForComponentMethod(componentMethod, componentModel);
    }

    CodeBlock getCreateMethodArgumentsCodeBlock(ContributionBinding binding) {
        return CodeBlocks.makeParametersCodeBlock(this.getCreateMethodArgumentsCodeBlocks(binding));
    }

    private ImmutableList<CodeBlock> getCreateMethodArgumentsCodeBlocks(ContributionBinding binding) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        if (binding.requiresModuleInstance()) {
            arguments.add((Object)this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().asType()), this.generatedComponentModel.name()));
        }
        binding.frameworkDependencies().stream().map(BindingRequest::bindingRequest).map(request -> this.getDependencyExpression((BindingRequest)request, this.generatedComponentModel.name())).map(Expression::codeBlock).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        return arguments.build();
    }

    Expression getDependencyArgumentExpression(DependencyRequest dependencyRequest, ClassName requestingClass) {
        TypeMirror dependencyType = dependencyRequest.key().type();
        Expression dependencyExpression = this.getDependencyExpression(BindingRequest.bindingRequest(dependencyRequest), requestingClass);
        if (dependencyRequest.kind().equals((Object)RequestKind.INSTANCE) && !Accessibility.isTypeAccessibleFrom(dependencyType, requestingClass.packageName()) && Accessibility.isRawTypeAccessible(dependencyType, requestingClass.packageName())) {
            return dependencyExpression.castTo(this.types.erasure(dependencyType));
        }
        return dependencyExpression;
    }

    MethodSpec getComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.dependencyRequest().isPresent());
        BindingRequest request = BindingRequest.bindingRequest(componentMethod.dependencyRequest().get());
        return MethodSpec.overriding((ExecutableElement)componentMethod.methodElement(), (DeclaredType)MoreTypes.asDeclared(this.graph.componentType().asType()), (Types)this.types).addCode(this.getBindingExpression(request).getComponentMethodImplementation(componentMethod, this.generatedComponentModel)).build();
    }

    BindingExpression getBindingExpression(BindingRequest request) {
        ResolvedBindings resolvedBindings;
        if (this.expressions.containsKey(request)) {
            return this.expressions.get(request);
        }
        Optional<BindingExpression> expression = this.modifiableBindingExpressions.maybeCreateModifiableBindingExpression(request);
        if (!expression.isPresent() && (resolvedBindings = this.graph.resolvedBindings(request)) != null && !resolvedBindings.ownedBindings().isEmpty()) {
            expression = Optional.of(this.createBindingExpression(resolvedBindings, request));
        }
        if (expression.isPresent()) {
            this.expressions.put(request, expression.get());
            return expression.get();
        }
        Preconditions.checkArgument((boolean)this.parent.isPresent(), (String)"no expression found for %s", (Object)request);
        return this.parent.get().getBindingExpression(request);
    }

    BindingExpression createBindingExpression(ResolvedBindings resolvedBindings, BindingRequest request) {
        switch (resolvedBindings.bindingType()) {
            case MEMBERS_INJECTION: {
                Preconditions.checkArgument((boolean)request.isRequestKind(RequestKind.MEMBERS_INJECTION));
                return new MembersInjectionBindingExpression(resolvedBindings, this.membersInjectionMethods);
            }
            case PROVISION: {
                return this.provisionBindingExpression(resolvedBindings, request);
            }
            case PRODUCTION: {
                return this.productionBindingExpression(resolvedBindings, request);
            }
        }
        throw new AssertionError(resolvedBindings);
    }

    private FrameworkInstanceBindingExpression frameworkInstanceBindingExpression(ResolvedBindings resolvedBindings) {
        FrameworkFieldInitializer.FrameworkInstanceCreationExpression frameworkInstanceCreationExpression;
        Optional<Object> staticMethod = this.useStaticFactoryCreation(resolvedBindings.contributionBinding()) ? MemberSelect.staticFactoryCreation(resolvedBindings) : Optional.empty();
        FrameworkFieldInitializer.FrameworkInstanceCreationExpression frameworkInstanceCreationExpression2 = frameworkInstanceCreationExpression = resolvedBindings.scope().isPresent() ? this.scope(resolvedBindings, this.frameworkInstanceCreationExpression(resolvedBindings)) : this.frameworkInstanceCreationExpression(resolvedBindings);
        FrameworkInstanceSupplier frameworkInstanceSupplier = staticMethod.isPresent() ? staticMethod::get : new FrameworkFieldInitializer(this.generatedComponentModel, resolvedBindings, frameworkInstanceCreationExpression);
        switch (resolvedBindings.bindingType()) {
            case PROVISION: {
                return new ProviderInstanceBindingExpression(resolvedBindings, frameworkInstanceSupplier, this.types, this.elements);
            }
            case PRODUCTION: {
                return new ProducerNodeInstanceBindingExpression(resolvedBindings, frameworkInstanceSupplier, this.types, this.elements, this.generatedComponentModel);
            }
        }
        throw new AssertionError((Object)("invalid binding type: " + (Object)((Object)resolvedBindings.bindingType())));
    }

    private FrameworkFieldInitializer.FrameworkInstanceCreationExpression scope(ResolvedBindings resolvedBindings, FrameworkFieldInitializer.FrameworkInstanceCreationExpression unscoped) {
        if (this.requiresReleasableReferences(resolvedBindings)) {
            return () -> CodeBlock.of((String)"$T.create($L, $L)", (Object[])new Object[]{TypeNames.REFERENCE_RELEASING_PROVIDER, unscoped.creationExpression(), this.referenceReleasingManagerFields.getExpression(resolvedBindings.scope().get(), this.generatedComponentModel.name())});
        }
        return () -> CodeBlock.of((String)"$T.provider($L)", (Object[])new Object[]{resolvedBindings.scope().get().isReusable() ? TypeNames.SINGLE_CHECK : TypeNames.DOUBLE_CHECK, unscoped.creationExpression()});
    }

    private FrameworkFieldInitializer.FrameworkInstanceCreationExpression frameworkInstanceCreationExpression(ResolvedBindings resolvedBindings) {
        Preconditions.checkArgument((!resolvedBindings.bindingType().equals((Object)BindingType.MEMBERS_INJECTION) ? 1 : 0) != 0);
        ContributionBinding binding = resolvedBindings.contributionBinding();
        switch (binding.kind()) {
            case COMPONENT: {
                return new InstanceFactoryCreationExpression(() -> CodeBlock.of((String)"($T) this", (Object[])new Object[]{binding.key().type()}));
            }
            case BOUND_INSTANCE: {
                return this.instanceFactoryCreationExpression(binding, ComponentRequirement.forBoundInstance(binding));
            }
            case COMPONENT_DEPENDENCY: {
                return this.instanceFactoryCreationExpression(binding, ComponentRequirement.forDependency(binding.key().type()));
            }
            case COMPONENT_PROVISION: {
                return new DependencyMethodProviderCreationExpression(binding, this.generatedComponentModel, this.componentRequirementFields, this.compilerOptions, this.graph);
            }
            case SUBCOMPONENT_BUILDER: {
                return new SubcomponentBuilderProviderCreationExpression(binding.key().type(), this.generatedComponentModel.getSubcomponentName(binding.key()));
            }
            case INJECTION: 
            case PROVISION: {
                return this.compilerOptions.experimentalAndroidMode2() ? this.staticSwitchingProviders.newCreationExpression(binding, this) : new InjectionOrProvisionProviderCreationExpression(binding, this);
            }
            case COMPONENT_PRODUCTION: {
                return new DependencyMethodProducerCreationExpression(binding, this.generatedComponentModel, this.componentRequirementFields, this.graph);
            }
            case PRODUCTION: {
                return new ProducerCreationExpression(binding, this);
            }
            case MULTIBOUND_SET: {
                return new SetFactoryCreationExpression(binding, this.generatedComponentModel, this, this.graph);
            }
            case MULTIBOUND_MAP: {
                return new MapFactoryCreationExpression(binding, this.generatedComponentModel, this, this.graph, this.elements);
            }
            case RELEASABLE_REFERENCE_MANAGER: {
                return new ReleasableReferenceManagerProviderCreationExpression(binding, this.generatedComponentModel, this.referenceReleasingManagerFields);
            }
            case RELEASABLE_REFERENCE_MANAGERS: {
                return new ReleasableReferenceManagerSetProviderCreationExpression(binding, this.generatedComponentModel, this.referenceReleasingManagerFields, this.graph);
            }
            case DELEGATE: {
                return new DelegatingFrameworkInstanceCreationExpression(binding, this.generatedComponentModel, this);
            }
            case OPTIONAL: {
                return new OptionalFactoryInstanceCreationExpression(this.optionalFactories, binding, this.generatedComponentModel, this);
            }
            case MEMBERS_INJECTOR: {
                return new MembersInjectorProviderCreationExpression((ProvisionBinding)binding, this);
            }
        }
        throw new AssertionError(binding);
    }

    private InstanceFactoryCreationExpression instanceFactoryCreationExpression(ContributionBinding binding, ComponentRequirement componentRequirement) {
        return new InstanceFactoryCreationExpression(binding.nullableType().isPresent(), () -> this.componentRequirementFields.getExpressionDuringInitialization(componentRequirement, this.generatedComponentModel.name()));
    }

    private BindingExpression provisionBindingExpression(ResolvedBindings resolvedBindings, BindingRequest request) {
        if (!request.requestKind().isPresent()) {
            Verify.verify((boolean)request.frameworkType().get().equals((Object)FrameworkType.PRODUCER_NODE), (String)"expected a PRODUCER_NODE: %s", (Object)request);
            return this.producerFromProviderBindingExpression(resolvedBindings);
        }
        RequestKind requestKind = request.requestKind().get();
        switch (requestKind) {
            case INSTANCE: {
                return this.instanceBindingExpression(resolvedBindings);
            }
            case PROVIDER: {
                return this.providerBindingExpression(resolvedBindings);
            }
            case LAZY: 
            case PRODUCED: 
            case PROVIDER_OF_LAZY: {
                return new DerivedFromFrameworkInstanceBindingExpression(resolvedBindings, FrameworkType.PROVIDER, requestKind, this, this.types);
            }
            case PRODUCER: {
                return this.producerFromProviderBindingExpression(resolvedBindings);
            }
            case FUTURE: {
                return new ImmediateFutureBindingExpression(resolvedBindings, this, this.types);
            }
            case MEMBERS_INJECTION: {
                throw new IllegalArgumentException();
            }
        }
        throw new AssertionError();
    }

    private BindingExpression productionBindingExpression(ResolvedBindings resolvedBindings, BindingRequest request) {
        if (request.frameworkType().isPresent()) {
            return this.frameworkInstanceBindingExpression(resolvedBindings);
        }
        return new DerivedFromFrameworkInstanceBindingExpression(resolvedBindings, FrameworkType.PRODUCER_NODE, request.requestKind().get(), this, this.types);
    }

    private BindingExpression providerBindingExpression(ResolvedBindings resolvedBindings) {
        if (resolvedBindings.contributionBinding().kind().equals((Object)BindingKind.DELEGATE) && !this.needsCaching(resolvedBindings)) {
            return new DelegateBindingExpression(resolvedBindings, RequestKind.PROVIDER, this, this.types, this.elements);
        }
        if (this.compilerOptions.fastInit() && this.frameworkInstanceCreationExpression(resolvedBindings).useInnerSwitchingProvider() && !(this.instanceBindingExpression(resolvedBindings) instanceof DerivedFromFrameworkInstanceBindingExpression)) {
            return this.wrapInMethod(resolvedBindings, BindingRequest.bindingRequest(resolvedBindings.key(), RequestKind.PROVIDER), this.innerSwitchingProviders.newBindingExpression(resolvedBindings.contributionBinding()));
        }
        return this.frameworkInstanceBindingExpression(resolvedBindings);
    }

    private FrameworkInstanceBindingExpression producerFromProviderBindingExpression(ResolvedBindings resolvedBindings) {
        Preconditions.checkArgument((boolean)resolvedBindings.bindingType().equals((Object)BindingType.PROVISION));
        return new ProducerNodeInstanceBindingExpression(resolvedBindings, new FrameworkFieldInitializer(this.generatedComponentModel, resolvedBindings, new ProducerFromProviderCreationExpression(resolvedBindings.contributionBinding(), this.generatedComponentModel, this)), this.types, this.elements, this.generatedComponentModel);
    }

    private BindingExpression instanceBindingExpression(ResolvedBindings resolvedBindings) {
        Optional<BindingExpression> maybeDirectInstanceExpression = this.unscopedDirectInstanceExpression(resolvedBindings);
        if (this.canUseDirectInstanceExpression(resolvedBindings) && maybeDirectInstanceExpression.isPresent()) {
            BindingExpression directInstanceExpression = maybeDirectInstanceExpression.get();
            return directInstanceExpression.requiresMethodEncapsulation() || this.needsCaching(resolvedBindings) ? this.wrapInMethod(resolvedBindings, BindingRequest.bindingRequest(resolvedBindings.key(), RequestKind.INSTANCE), directInstanceExpression) : directInstanceExpression;
        }
        return new DerivedFromFrameworkInstanceBindingExpression(resolvedBindings, FrameworkType.PROVIDER, RequestKind.INSTANCE, this, this.types);
    }

    private Optional<BindingExpression> unscopedDirectInstanceExpression(ResolvedBindings resolvedBindings) {
        switch (resolvedBindings.contributionBinding().kind()) {
            case DELEGATE: {
                return Optional.of(new DelegateBindingExpression(resolvedBindings, RequestKind.INSTANCE, this, this.types, this.elements));
            }
            case COMPONENT: {
                return Optional.of(new ComponentInstanceBindingExpression(resolvedBindings, this.generatedComponentModel.name()));
            }
            case COMPONENT_DEPENDENCY: {
                return Optional.of(new ComponentRequirementBindingExpression(resolvedBindings, ComponentRequirement.forDependency(resolvedBindings.key().type()), this.componentRequirementFields));
            }
            case COMPONENT_PROVISION: {
                return Optional.of(new ComponentProvisionBindingExpression(resolvedBindings, this.graph, this.componentRequirementFields, this.compilerOptions));
            }
            case SUBCOMPONENT_BUILDER: {
                return Optional.of(new SubcomponentBuilderBindingExpression(resolvedBindings, this.generatedComponentModel.getSubcomponentName(resolvedBindings.key())));
            }
            case MULTIBOUND_SET: {
                return Optional.of(new SetBindingExpression(resolvedBindings, this.generatedComponentModel, this.graph, this, this.types, this.elements));
            }
            case MULTIBOUND_MAP: {
                return Optional.of(new MapBindingExpression(resolvedBindings, this.generatedComponentModel, this.graph, this, this.types, this.elements));
            }
            case OPTIONAL: {
                return Optional.of(new OptionalBindingExpression(resolvedBindings, this, this.types));
            }
            case BOUND_INSTANCE: {
                return Optional.of(new ComponentRequirementBindingExpression(resolvedBindings, ComponentRequirement.forBoundInstance(resolvedBindings.contributionBinding()), this.componentRequirementFields));
            }
            case INJECTION: 
            case PROVISION: {
                return Optional.of(new SimpleMethodBindingExpression(resolvedBindings, this.compilerOptions, this, this.membersInjectionMethods, this.componentRequirementFields, this.elements));
            }
            case RELEASABLE_REFERENCE_MANAGER: 
            case RELEASABLE_REFERENCE_MANAGERS: 
            case MEMBERS_INJECTOR: {
                return Optional.empty();
            }
            case COMPONENT_PRODUCTION: 
            case PRODUCTION: 
            case MEMBERS_INJECTION: {
                throw new IllegalArgumentException(resolvedBindings.contributionBinding().kind().toString());
            }
        }
        throw new AssertionError();
    }

    private boolean useStaticFactoryCreation(ContributionBinding binding) {
        return !this.compilerOptions.experimentalAndroidMode2() && !this.compilerOptions.fastInit() || binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP) || binding.kind().equals((Object)BindingKind.MULTIBOUND_SET);
    }

    private boolean canUseDirectInstanceExpression(ResolvedBindings resolvedBindings) {
        return !this.needsCaching(resolvedBindings) || this.compilerOptions.fastInit() && !this.requiresReleasableReferences(resolvedBindings);
    }

    BindingExpression wrapInMethod(ResolvedBindings resolvedBindings, BindingRequest request, BindingExpression bindingExpression) {
        Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod;
        Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod;
        if (bindingExpression instanceof MethodBindingExpression) {
            return bindingExpression;
        }
        BindingMethodImplementation methodImplementation = this.methodImplementation(resolvedBindings, request, bindingExpression);
        Optional<BindingExpression> modifiableBindingExpression = this.modifiableBindingExpressions.maybeWrapInModifiableMethodBindingExpression(resolvedBindings, request, bindingExpression, methodImplementation, matchingComponentMethod = this.graph.componentDescriptor().findMatchingComponentMethod(request), matchingModifiableBindingMethod = this.generatedComponentModel.getModifiableBindingMethod(request));
        if (modifiableBindingExpression.isPresent()) {
            return modifiableBindingExpression.get();
        }
        return matchingComponentMethod.map(componentMethod -> new ComponentMethodBindingExpression(methodImplementation, this.generatedComponentModel, (ComponentDescriptor.ComponentMethodDescriptor)componentMethod, matchingModifiableBindingMethod)).orElseGet(() -> new PrivateMethodBindingExpression(resolvedBindings, request, methodImplementation, this.generatedComponentModel, matchingModifiableBindingMethod));
    }

    private BindingMethodImplementation methodImplementation(ResolvedBindings resolvedBindings, BindingRequest request, BindingExpression bindingExpression) {
        if (this.compilerOptions.fastInit()) {
            if (request.isRequestKind(RequestKind.PROVIDER)) {
                return new SingleCheckedMethodImplementation(resolvedBindings, request, bindingExpression, this.types, this.generatedComponentModel);
            }
            if (request.isRequestKind(RequestKind.INSTANCE) && this.needsCaching(resolvedBindings)) {
                return resolvedBindings.scope().get().isReusable() ? new SingleCheckedMethodImplementation(resolvedBindings, request, bindingExpression, this.types, this.generatedComponentModel) : new DoubleCheckedMethodImplementation(resolvedBindings, request, bindingExpression, this.types, this.generatedComponentModel);
            }
        }
        return new BindingMethodImplementation(resolvedBindings, request, bindingExpression, this.generatedComponentModel.name(), this.types);
    }

    private boolean needsCaching(ResolvedBindings resolvedBindings) {
        if (!resolvedBindings.scope().isPresent()) {
            return false;
        }
        if (resolvedBindings.contributionBinding().kind().equals((Object)BindingKind.DELEGATE)) {
            return DelegateBindingExpression.isBindsScopeStrongerThanDependencyScope(resolvedBindings, this.graph);
        }
        return true;
    }

    private boolean requiresReleasableReferences(ResolvedBindings resolvedBindings) {
        return resolvedBindings.scope().isPresent() && this.referenceReleasingManagerFields.requiresReleasableReferences(resolvedBindings.scope().get());
    }
}

