/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentHierarchyValidator;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DiagnosticFormatting;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.ValidationType;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class ComponentDescriptorValidator {
    private final Elements elements;
    private final DaggerTypes types;
    private final CompilerOptions compilerOptions;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final ComponentHierarchyValidator componentHierarchyValidator;

    @Inject
    ComponentDescriptorValidator(Elements elements, DaggerTypes types, CompilerOptions compilerOptions, MethodSignatureFormatter methodSignatureFormatter, ComponentHierarchyValidator componentHierarchyValidator) {
        this.elements = elements;
        this.types = types;
        this.compilerOptions = compilerOptions;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.componentHierarchyValidator = componentHierarchyValidator;
    }

    ValidationReport<TypeElement> validate(ComponentDescriptor component) {
        ComponentValidation validation = new ComponentValidation(component);
        validation.visitComponent(component);
        validation.report(component).addSubreport(this.componentHierarchyValidator.validate(component));
        return validation.buildReport();
    }

    private final class ComponentValidation {
        final ComponentDescriptor rootComponent;
        final Map<ComponentDescriptor, ValidationReport.Builder<TypeElement>> reports = new LinkedHashMap<ComponentDescriptor, ValidationReport.Builder<TypeElement>>();

        ComponentValidation(ComponentDescriptor rootComponent) {
            this.rootComponent = (ComponentDescriptor)Preconditions.checkNotNull((Object)rootComponent);
        }

        ValidationReport<TypeElement> buildReport() {
            ValidationReport.Builder<TypeElement> report = ValidationReport.about(this.rootComponent.componentDefinitionType());
            this.reports.values().forEach(subreport -> report.addSubreport(subreport.build()));
            return report.build();
        }

        private ValidationReport.Builder<TypeElement> report(ComponentDescriptor component) {
            return Util.reentrantComputeIfAbsent(this.reports, component, descriptor -> ValidationReport.about(descriptor.componentDefinitionType()));
        }

        void visitComponent(ComponentDescriptor component) {
            this.validateDependencyScopes(component);
            this.validateComponentDependencyHierarchy(component);
            this.validateModules(component);
            this.validateBuilders(component);
            component.subcomponents().forEach(this::visitComponent);
        }

        private void validateComponentDependencyHierarchy(ComponentDescriptor component) {
            this.validateComponentDependencyHierarchy(component, component.componentDefinitionType(), new ArrayDeque<TypeElement>());
        }

        private void validateComponentDependencyHierarchy(ComponentDescriptor component, TypeElement dependency, Deque<TypeElement> dependencyStack) {
            if (dependencyStack.contains(dependency)) {
                StringBuilder message = new StringBuilder();
                message.append(component.componentDefinitionType().getQualifiedName());
                message.append(" contains a cycle in its component dependencies:\n");
                dependencyStack.push(dependency);
                this.appendIndentedComponentsList(message, dependencyStack);
                dependencyStack.pop();
                this.report(component).addItem(message.toString(), ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component.componentDefinitionType(), ConfigurationAnnotations.getComponentAnnotation(component.componentDefinitionType()).get());
            } else {
                Optional<AnnotationMirror> componentAnnotation = ConfigurationAnnotations.getComponentAnnotation(dependency);
                if (componentAnnotation.isPresent()) {
                    dependencyStack.push(dependency);
                    ImmutableSet<TypeElement> dependencies = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentAnnotation.get()));
                    for (TypeElement nextDependency : dependencies) {
                        this.validateComponentDependencyHierarchy(component, nextDependency, dependencyStack);
                    }
                    dependencyStack.pop();
                }
            }
        }

        private void validateDependencyScopes(ComponentDescriptor component) {
            ImmutableSet<Scope> scopes = component.scopes();
            ImmutableSet<TypeElement> scopedDependencies = this.scopedTypesIn((Set)component.dependencies().stream().map(ComponentRequirement::typeElement).collect(DaggerStreams.toImmutableSet()));
            if (!scopes.isEmpty()) {
                Scope singletonScope = Scopes.singletonScope(ComponentDescriptorValidator.this.elements);
                if (ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent() && scopes.contains((Object)singletonScope)) {
                    if (!scopedDependencies.isEmpty()) {
                        StringBuilder message = new StringBuilder("This @Singleton component cannot depend on scoped components:\n");
                        this.appendIndentedComponentsList(message, (Iterable<TypeElement>)scopedDependencies);
                        this.report(component).addItem(message.toString(), ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component.componentDefinitionType(), component.componentAnnotation());
                    }
                } else if (scopedDependencies.size() > 1) {
                    StringBuilder message = new StringBuilder();
                    for (Scope scope : scopes) {
                        message.append(Scopes.getReadableSource(scope)).append(' ');
                    }
                    message.append(component.componentDefinitionType().getQualifiedName()).append(" depends on more than one scoped component:\n");
                    this.appendIndentedComponentsList(message, (Iterable<TypeElement>)scopedDependencies);
                    this.report(component).addError(message.toString(), component.componentDefinitionType(), component.componentAnnotation());
                } else if (!ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().equals((Object)ValidationType.NONE)) {
                    this.validateDependencyScopeHierarchy(component, component.componentDefinitionType(), new ArrayDeque<ImmutableSet<Scope>>(), new ArrayDeque<TypeElement>());
                }
            } else if (!scopedDependencies.isEmpty()) {
                StringBuilder message = new StringBuilder(component.componentDefinitionType().getQualifiedName()).append(" (unscoped) cannot depend on scoped components:\n");
                this.appendIndentedComponentsList(message, (Iterable<TypeElement>)scopedDependencies);
                this.report(component).addError(message.toString(), component.componentDefinitionType(), component.componentAnnotation());
            }
        }

        private void validateModules(ComponentDescriptor component) {
            block0: for (ModuleDescriptor module : component.transitiveModules()) {
                if (!module.moduleElement().getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                for (ContributionBinding binding : module.bindings()) {
                    if (!binding.requiresModuleInstance()) continue;
                    this.report(component).addError(this.abstractModuleHasInstanceBindingMethodsError(module));
                    continue block0;
                }
            }
        }

        private String abstractModuleHasInstanceBindingMethodsError(ModuleDescriptor module) {
            String methodAnnotations;
            switch (module.kind()) {
                case MODULE: {
                    methodAnnotations = "@Provides";
                    break;
                }
                case PRODUCER_MODULE: {
                    methodAnnotations = "@Provides or @Produces";
                    break;
                }
                default: {
                    throw new AssertionError((Object)module.kind());
                }
            }
            return String.format("%s is abstract and has instance %s methods. Consider making the methods static or including a non-abstract subclass of the module instead.", module.moduleElement(), methodAnnotations);
        }

        private void validateBuilders(ComponentDescriptor component) {
            Sets.SetView missingSetters;
            ComponentDescriptor componentDesc = component;
            if (!componentDesc.builderSpec().isPresent()) {
                return;
            }
            ImmutableSet<ComponentRequirement> availableDependencies = component.availableDependencies();
            Set requiredDependencies = Sets.filter(availableDependencies, input -> input.nullPolicy(ComponentDescriptorValidator.this.elements, ComponentDescriptorValidator.this.types).equals((Object)ComponentRequirement.NullPolicy.THROW));
            ComponentDescriptor.BuilderSpec spec = componentDesc.builderSpec().get();
            ImmutableSet declaredSetters = spec.requirementMethods().stream().filter(method -> !method.requirement().kind().equals((Object)ComponentRequirement.Kind.BOUND_INSTANCE)).collect(DaggerStreams.toImmutableSet());
            ImmutableSet declaredRequirements = declaredSetters.stream().map(ComponentDescriptor.BuilderRequirementMethod::requirement).collect(DaggerStreams.toImmutableSet());
            ErrorMessages.ComponentBuilderMessages msgs = ErrorMessages.builderMsgsFor(component.kind());
            Sets.SetView extraSetters = Sets.difference(declaredRequirements, availableDependencies);
            if (!extraSetters.isEmpty()) {
                List excessMethods = declaredSetters.stream().filter(arg_0 -> ComponentValidation.lambda$validateBuilders$4((Set)extraSetters, arg_0)).map(ComponentDescriptor.BuilderRequirementMethod::method).collect(Collectors.toList());
                Optional<DeclaredType> container = Optional.of(MoreTypes.asDeclared(spec.builderDefinitionType().asType()));
                String formatted = excessMethods.stream().map(method -> ComponentDescriptorValidator.this.methodSignatureFormatter.format((ExecutableElement)method, container)).collect(Collectors.joining(", ", "[", "]"));
                this.report(component).addError(String.format(msgs.extraSetters(), formatted), spec.builderDefinitionType());
            }
            if (!(missingSetters = Sets.difference((Set)requiredDependencies, declaredRequirements)).isEmpty()) {
                this.report(component).addError(String.format(msgs.missingSetters(), missingSetters.stream().map(ComponentRequirement::type).collect(Collectors.toList())), spec.builderDefinitionType());
            }
            Map declaredRequirementsByType = spec.requirementMethods().stream().filter(method -> !method.requirement().kind().equals((Object)ComponentRequirement.Kind.BOUND_INSTANCE)).collect(Collectors.groupingBy(method -> method.requirement().wrappedType(), Collectors.mapping(method -> method.method(), Collectors.toList())));
            for (Map.Entry entry : declaredRequirementsByType.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                TypeMirror type = (TypeMirror)entry.getKey().get();
                this.report(component).addError(String.format(msgs.manyMethodsForType(), type, entry.getValue()), spec.builderDefinitionType());
            }
        }

        private void validateDependencyScopeHierarchy(ComponentDescriptor component, TypeElement dependency, Deque<ImmutableSet<Scope>> scopeStack, Deque<TypeElement> scopedDependencyStack) {
            ImmutableSet<Scope> scopes = Scopes.scopesOf(dependency);
            if (this.stackOverlaps(scopeStack, scopes)) {
                scopedDependencyStack.push(dependency);
                StringBuilder message = new StringBuilder();
                message.append(component.componentDefinitionType().getQualifiedName());
                message.append(" depends on scoped components in a non-hierarchical scope ordering:\n");
                this.appendIndentedComponentsList(message, scopedDependencyStack);
                if (ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
                    this.report(component).addItem(message.toString(), ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component.componentDefinitionType(), ConfigurationAnnotations.getComponentAnnotation(component.componentDefinitionType()).get());
                }
                scopedDependencyStack.pop();
            } else {
                DaggerElements.getAnnotationMirror(dependency, Component.class).ifPresent(componentAnnotation -> {
                    ImmutableSet<TypeElement> scopedDependencies = this.scopedTypesIn((Set<TypeElement>)MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentAnnotation)));
                    if (scopedDependencies.size() == 1) {
                        scopeStack.push(scopes);
                        scopedDependencyStack.push(dependency);
                        this.validateDependencyScopeHierarchy(component, (TypeElement)Iterables.getOnlyElement(scopedDependencies), scopeStack, scopedDependencyStack);
                        scopedDependencyStack.pop();
                        scopeStack.pop();
                    }
                });
            }
        }

        private <T> boolean stackOverlaps(Deque<ImmutableSet<T>> stack, ImmutableSet<T> set) {
            for (ImmutableSet<T> entry : stack) {
                if (Sets.intersection(entry, set).isEmpty()) continue;
                return true;
            }
            return false;
        }

        private void appendIndentedComponentsList(StringBuilder message, Iterable<TypeElement> types) {
            for (TypeElement scopedComponent : types) {
                message.append("    ");
                for (Scope scope : Scopes.scopesOf(scopedComponent)) {
                    message.append(Scopes.getReadableSource(scope)).append(' ');
                }
                message.append(DiagnosticFormatting.stripCommonTypePrefixes(scopedComponent.getQualifiedName().toString())).append('\n');
            }
        }

        private ImmutableSet<TypeElement> scopedTypesIn(Set<TypeElement> types) {
            return types.stream().filter(type -> !Scopes.scopesOf(type).isEmpty()).collect(DaggerStreams.toImmutableSet());
        }

        private static /* synthetic */ boolean lambda$validateBuilders$4(Set extraSetters, ComponentDescriptor.BuilderRequirementMethod method) {
            return extraSetters.contains(method.requirement());
        }
    }
}

