/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MethodBindingExpression;
import dagger.internal.codegen.ModifiableBindingMethods;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

final class ComponentMethodBindingExpression
extends MethodBindingExpression {
    private final BindingMethodImplementation methodImplementation;
    private final GeneratedComponentModel generatedComponentModel;
    private final ComponentDescriptor.ComponentMethodDescriptor componentMethod;

    ComponentMethodBindingExpression(BindingMethodImplementation methodImplementation, GeneratedComponentModel generatedComponentModel, ComponentDescriptor.ComponentMethodDescriptor componentMethod, Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod) {
        super(methodImplementation, generatedComponentModel, matchingModifiableBindingMethod);
        this.methodImplementation = (BindingMethodImplementation)Preconditions.checkNotNull((Object)methodImplementation);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.componentMethod = (ComponentDescriptor.ComponentMethodDescriptor)Preconditions.checkNotNull((Object)componentMethod);
    }

    @Override
    protected CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, GeneratedComponentModel component) {
        return componentMethod.equals(this.componentMethod) && component.equals(this.generatedComponentModel) ? this.methodImplementation.body() : super.getComponentMethodImplementation(componentMethod, component);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression expression = super.getDependencyExpression(requestingClass);
        TypeMirror methodReturnType = this.componentMethod.methodElement().getReturnType();
        return methodReturnType.getKind().isPrimitive() ? Expression.create(methodReturnType, expression.codeBlock()) : expression;
    }

    @Override
    protected void addMethod() {
    }

    @Override
    protected String methodName() {
        return this.componentMethod.methodElement().getSimpleName().toString();
    }
}

