/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
final class DaggerStatistics {
    private final Stopwatch totalRuntimeStopwatch;

    @Inject
    DaggerStatistics(Ticker ticker) {
        this.totalRuntimeStopwatch = Stopwatch.createUnstarted((Ticker)ticker);
    }

    void processingStarted() {
        Preconditions.checkState((!this.totalRuntimeStopwatch.isRunning() ? 1 : 0) != 0);
        this.totalRuntimeStopwatch.start();
    }

    void processingStopped() {
        Preconditions.checkState((boolean)this.totalRuntimeStopwatch.isRunning());
        this.totalRuntimeStopwatch.stop();
    }
}

