/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.MembersInjector;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.MembersInjectionValidator;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class DependencyRequestValidator {
    private final MembersInjectionValidator membersInjectionValidator;

    @Inject
    DependencyRequestValidator(MembersInjectionValidator membersInjectionValidator) {
        this.membersInjectionValidator = membersInjectionValidator;
    }

    void validateDependencyRequest(ValidationReport.Builder<?> report, Element requestElement, TypeMirror requestType) {
        TypeMirror keyType;
        ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(requestElement);
        if (qualifiers.size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                report.addError("A single dependency request may not use more than one @Qualifier", requestElement, qualifier);
            }
        }
        if ((keyType = RequestKinds.extractKeyType(RequestKinds.getRequestKind(requestType), requestType)).getKind().equals((Object)TypeKind.WILDCARD)) {
            report.addError("Dagger does not support injecting Provider<T>, Lazy<T>, Producer<T>, or Produced<T> when T is a wildcard type such as " + keyType, requestElement);
        }
        if (MoreTypes.isType(keyType) && MoreTypes.isTypeOf(MembersInjector.class, keyType)) {
            DeclaredType membersInjectorType = MoreTypes.asDeclared(keyType);
            if (membersInjectorType.getTypeArguments().isEmpty()) {
                report.addError("Cannot inject a raw MembersInjector", requestElement);
            } else {
                report.addSubreport(this.membersInjectionValidator.validateMembersInjectionRequest(requestElement, membersInjectorType.getTypeArguments().get(0)));
            }
        }
    }

    void checkNotProducer(ValidationReport.Builder<?> report, VariableElement requestElement) {
        TypeMirror requestType = requestElement.asType();
        if (FrameworkTypes.isProducerType(requestType)) {
            report.addError(String.format("%s may only be injected in @Produces methods", MoreTypes.asTypeElement(requestType).getSimpleName()), requestElement);
        }
    }
}

