/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import dagger.internal.codegen.ComponentDescriptor;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class ErrorMessages {
    static ComponentBuilderMessages builderMsgsFor(ComponentDescriptor.Kind kind) {
        switch (kind) {
            case COMPONENT: {
                return ComponentBuilderMessages.INSTANCE;
            }
            case SUBCOMPONENT: {
                return SubcomponentBuilderMessages.INSTANCE;
            }
            case PRODUCTION_COMPONENT: {
                return ProductionComponentBuilderMessages.INSTANCE;
            }
            case PRODUCTION_SUBCOMPONENT: {
                return ProductionSubcomponentBuilderMessages.INSTANCE;
            }
        }
        throw new IllegalStateException(kind.toString());
    }

    private ErrorMessages() {
    }

    private static final class ProductionSubcomponentBuilderMessages
    extends ComponentBuilderMessages {
        static final ProductionSubcomponentBuilderMessages INSTANCE = new ProductionSubcomponentBuilderMessages();

        private ProductionSubcomponentBuilderMessages() {
        }

        @Override
        protected String process(String s) {
            return s.replaceAll("component", "production subcomponent").replaceAll("Component", "ProductionSubcomponent");
        }
    }

    private static final class ProductionComponentBuilderMessages
    extends ComponentBuilderMessages {
        static final ProductionComponentBuilderMessages INSTANCE = new ProductionComponentBuilderMessages();

        private ProductionComponentBuilderMessages() {
        }

        @Override
        protected String process(String s) {
            return s.replaceAll("component", "production component").replaceAll("Component", "ProductionComponent");
        }
    }

    static final class SubcomponentBuilderMessages
    extends ComponentBuilderMessages {
        static final SubcomponentBuilderMessages INSTANCE = new SubcomponentBuilderMessages();

        SubcomponentBuilderMessages() {
        }

        @Override
        protected String process(String s) {
            return s.replaceAll("component", "subcomponent").replaceAll("Component", "Subcomponent");
        }

        String builderMethodRequiresNoArgs() {
            return "Methods returning a @Subcomponent.Builder must have no arguments";
        }

        String moreThanOneRefToSubcomponent() {
            return "Only one method can create a given subcomponent. %s is created by: %s";
        }
    }

    static class ComponentBuilderMessages {
        static final ComponentBuilderMessages INSTANCE = new ComponentBuilderMessages();

        ComponentBuilderMessages() {
        }

        protected String process(String s) {
            return s;
        }

        final String moreThanOne() {
            return this.process("@Component has more than one @Component.Builder: %s");
        }

        final String cxtorOnlyOneAndNoArgs() {
            return this.process("@Component.Builder classes must have exactly one constructor, and it must not have any parameters");
        }

        final String generics() {
            return this.process("@Component.Builder types must not have any generic types");
        }

        final String mustBeInComponent() {
            return this.process("@Component.Builder types must be nested within a @Component");
        }

        final String mustBeClassOrInterface() {
            return this.process("@Component.Builder types must be abstract classes or interfaces");
        }

        final String isPrivate() {
            return this.process("@Component.Builder types must not be private");
        }

        final String mustBeStatic() {
            return this.process("@Component.Builder types must be static");
        }

        final String mustBeAbstract() {
            return this.process("@Component.Builder types must be abstract");
        }

        final String missingBuildMethod() {
            return this.process("@Component.Builder types must have exactly one no-args method that  returns the @Component type");
        }

        final String manyMethodsForType() {
            return this.process("@Component.Builder types must not have more than one setter method per type, but %s is set by %s");
        }

        final String extraSetters() {
            return this.process("@Component.Builder has setters for modules or components that aren't required: %s");
        }

        final String missingSetters() {
            return this.process("@Component.Builder is missing setters for required modules or components: %s");
        }

        final String twoBuildMethods() {
            return this.process("@Component.Builder types must have exactly one zero-arg method, and that method must return the @Component type. Already found: %s");
        }

        final String inheritedTwoBuildMethods() {
            return this.process("@Component.Builder types must have exactly one zero-arg method, and that method must return the @Component type. Found %s and %s");
        }

        final String buildMustReturnComponentType() {
            return this.process("@Component.Builder methods that have no arguments must return the @Component type or a supertype of the @Component");
        }

        final String inheritedBuildMustReturnComponentType() {
            return this.buildMustReturnComponentType() + ". Inherited method: %s";
        }

        final String methodsMustTakeOneArg() {
            return this.process("@Component.Builder methods must not have more than one argument");
        }

        final String inheritedMethodsMustTakeOneArg() {
            return this.process("@Component.Builder methods must not have more than one argument. Inherited method: %s");
        }

        final String methodsMustReturnVoidOrBuilder() {
            return this.process("@Component.Builder setter methods must return void, the builder, or a supertype of the builder");
        }

        final String inheritedMethodsMustReturnVoidOrBuilder() {
            return this.process("@Component.Builder setter methods must return void, the builder,or a supertype of the builder. Inherited method: %s");
        }

        final String methodsMayNotHaveTypeParameters() {
            return this.process("@Component.Builder methods must not have type parameters");
        }

        final String inheritedMethodsMayNotHaveTypeParameters() {
            return this.process("@Component.Builder methods must not have type parameters. Inherited method: %s");
        }

        final String nonBindsInstanceMethodsMayNotTakePrimitives() {
            return this.process("@Component.Builder methods that are not annotated with @BindsInstance must take either a module or a component dependency, not a primitive");
        }

        final String inheritedNonBindsInstanceMethodsMayNotTakePrimitives() {
            return this.nonBindsInstanceMethodsMayNotTakePrimitives() + this.process(". Inherited method: %s");
        }

        final String buildMethodReturnsSupertypeWithMissingMethods(TypeElement component, TypeElement componentBuilder, TypeMirror returnType, ExecutableElement buildMethod, Set<ExecutableElement> additionalMethods) {
            return String.format("%1$s.%2$s() returns %3$s, but %4$s declares additional component method(s): %5$s. In order to provide type-safe access to these methods, override %2$s() to return %4$s", componentBuilder.getQualifiedName(), buildMethod.getSimpleName(), returnType, component.getQualifiedName(), Joiner.on((String)", ").join(additionalMethods));
        }
    }
}

