/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.UniqueNameSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class GeneratedComponentBuilderModel {
    private final TypeSpec typeSpec;
    private final ClassName name;
    private final ImmutableMap<ComponentRequirement, FieldSpec> builderFields;

    private GeneratedComponentBuilderModel(TypeSpec typeSpec, ClassName name, ImmutableMap<ComponentRequirement, FieldSpec> builderFields) {
        this.typeSpec = typeSpec;
        this.name = name;
        this.builderFields = builderFields;
    }

    TypeSpec typeSpec() {
        return this.typeSpec;
    }

    ClassName name() {
        return this.name;
    }

    ImmutableMap<ComponentRequirement, FieldSpec> builderFields() {
        return this.builderFields;
    }

    static Optional<GeneratedComponentBuilderModel> create(GeneratedComponentModel generatedComponentModel, BindingGraph graph, Elements elements, Types types) {
        return GeneratedComponentBuilderModel.hasBuilder(graph.componentDescriptor()) ? Optional.of(new Creator(generatedComponentModel, graph, elements, types).create()) : Optional.empty();
    }

    private static boolean hasBuilder(ComponentDescriptor component) {
        return component.kind().isTopLevel() || component.builderSpec().isPresent();
    }

    private static final class Creator {
        private static final String NOOP_BUILDER_METHOD_JAVADOC = "This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://google.github.io/dagger/unused-modules.\n";
        private final BindingGraph graph;
        private final TypeSpec.Builder builder;
        private final GeneratedComponentModel generatedComponentModel;
        private final Elements elements;
        private final Types types;

        Creator(GeneratedComponentModel generatedComponentModel, BindingGraph graph, Elements elements, Types types) {
            this.generatedComponentModel = generatedComponentModel;
            this.builder = TypeSpec.classBuilder((ClassName)generatedComponentModel.getBuilderName());
            this.graph = graph;
            this.elements = elements;
            this.types = types;
        }

        GeneratedComponentBuilderModel create() {
            if (!this.generatedComponentModel.isNested()) {
                this.builder.addModifiers(new Modifier[]{Modifier.STATIC});
            }
            if (this.builderSpec().isPresent()) {
                if (this.generatedComponentModel.isAbstract()) {
                    this.builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
                } else {
                    this.builder.addModifiers(new Modifier[]{Modifier.PRIVATE});
                }
                this.setSupertype();
            } else {
                this.builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
            }
            ImmutableMap<ComponentRequirement, FieldSpec> builderFields = Creator.builderFields(this.graph);
            if (this.generatedComponentModel.isAbstract()) {
                this.builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            } else {
                this.builder.addModifiers(new Modifier[]{Modifier.FINAL});
                this.builder.addMethod(this.buildMethod(builderFields));
            }
            this.builder.addFields((Iterable)builderFields.values()).addMethods(this.builderMethods(builderFields));
            return new GeneratedComponentBuilderModel(this.builder.build(), this.generatedComponentModel.getBuilderName(), builderFields);
        }

        private void setSupertype() {
            if (this.generatedComponentModel.supermodel().isPresent()) {
                this.builder.superclass((TypeName)this.generatedComponentModel.supermodel().get().getBuilderName());
            } else {
                TypeSpecs.addSupertype(this.builder, this.builderSpec().get().builderDefinitionType());
            }
        }

        private static ImmutableMap<ComponentRequirement, FieldSpec> builderFields(BindingGraph graph) {
            UniqueNameSet fieldNames = new UniqueNameSet();
            ImmutableMap.Builder builderFields = ImmutableMap.builder();
            for (ComponentRequirement componentRequirement : graph.componentRequirements()) {
                String name = fieldNames.getUniqueName(componentRequirement.variableName());
                builderFields.put((Object)componentRequirement, (Object)FieldSpec.builder((TypeName)TypeName.get((TypeMirror)componentRequirement.type()), (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            }
            return builderFields.build();
        }

        private MethodSpec buildMethod(ImmutableMap<ComponentRequirement, FieldSpec> builderFields) {
            MethodSpec.Builder buildMethod;
            if (this.builderSpec().isPresent()) {
                ExecutableElement specBuildMethod = this.builderSpec().get().buildMethod();
                buildMethod = MethodSpec.methodBuilder((String)specBuildMethod.getSimpleName().toString()).addAnnotation(Override.class);
            } else {
                buildMethod = MethodSpec.methodBuilder((String)"build");
            }
            buildMethod.returns((TypeName)ClassName.get((TypeElement)this.graph.componentType())).addModifiers(new Modifier[]{Modifier.PUBLIC});
            builderFields.forEach((requirement, builderField) -> {
                switch (requirement.nullPolicy(this.elements, this.types)) {
                    case NEW: {
                        buildMethod.addCode("if ($1N == null) { this.$1N = new $2T(); }", new Object[]{builderField, builderField.type});
                        break;
                    }
                    case THROW: {
                        buildMethod.addCode("if ($N == null) { throw new $T($T.class.getCanonicalName() + $S); }", new Object[]{builderField, IllegalStateException.class, TypeNames.rawTypeName(builderField.type), " must be set"});
                        break;
                    }
                    case ALLOW: {
                        break;
                    }
                    default: {
                        throw new AssertionError(requirement);
                    }
                }
            });
            buildMethod.addStatement("return new $T(this)", new Object[]{this.generatedComponentModel.name()});
            return buildMethod.build();
        }

        private ImmutableSet<MethodSpec> builderMethods(ImmutableMap<ComponentRequirement, FieldSpec> builderFields) {
            ImmutableSet<ComponentRequirement> componentRequirements = this.graph.componentRequirements();
            ImmutableSet.Builder methods = ImmutableSet.builder();
            if (this.builderSpec().isPresent()) {
                UniqueNameSet parameterNames = new UniqueNameSet();
                for (ComponentDescriptor.BuilderRequirementMethod requirementMethod : this.builderSpec().get().requirementMethods()) {
                    ComponentRequirement builderRequirement = requirementMethod.requirement();
                    ExecutableElement specMethod = requirementMethod.method();
                    MethodSpec.Builder builderMethod = this.addBuilderMethodFromSpec(specMethod);
                    VariableElement parameterElement = (VariableElement)Iterables.getOnlyElement(specMethod.getParameters());
                    String parameterName = parameterNames.getUniqueName(parameterElement.getSimpleName());
                    TypeName argType = parameterElement.asType().getKind().isPrimitive() ? TypeName.get((TypeMirror)parameterElement.asType()) : TypeName.get((TypeMirror)builderRequirement.type());
                    builderMethod.addParameter(argType, parameterName, new Modifier[0]);
                    if (componentRequirements.contains((Object)builderRequirement)) {
                        builderMethod.addStatement("this.$N = $L", new Object[]{builderFields.get((Object)builderRequirement), builderRequirement.nullPolicy(this.elements, this.types).equals((Object)ComponentRequirement.NullPolicy.ALLOW) ? parameterName : CodeBlock.of((String)"$T.checkNotNull($L)", (Object[])new Object[]{Preconditions.class, parameterName})});
                        Creator.addBuilderMethodReturnStatementForSpec(specMethod, builderMethod);
                    } else if (this.graph.ownedModuleTypes().contains((Object)builderRequirement.typeElement())) {
                        builderMethod.addJavadoc(NOOP_BUILDER_METHOD_JAVADOC, new Object[0]);
                        Creator.addBuilderMethodReturnStatementForSpec(specMethod, builderMethod);
                    } else {
                        builderMethod.addStatement("throw new $T($T.format($S, $T.class.getCanonicalName()))", new Object[]{UnsupportedOperationException.class, String.class, "%s cannot be set because it is inherited from the enclosing component", TypeNames.rawTypeName(TypeName.get((TypeMirror)builderRequirement.type()))});
                    }
                    methods.add((Object)builderMethod.build());
                }
            } else {
                for (ComponentRequirement componentRequirement : this.graph.componentDescriptor().availableDependencies()) {
                    String componentRequirementName = SourceFiles.simpleVariableName(componentRequirement.typeElement());
                    MethodSpec.Builder builderMethod = MethodSpec.methodBuilder((String)componentRequirementName).returns((TypeName)this.generatedComponentModel.getBuilderName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)componentRequirement.type()), componentRequirementName, new Modifier[0]);
                    if (componentRequirements.contains((Object)componentRequirement)) {
                        builderMethod.addStatement("this.$N = $T.checkNotNull($L)", new Object[]{builderFields.get((Object)componentRequirement), Preconditions.class, componentRequirementName});
                    } else {
                        builderMethod.addStatement("$T.checkNotNull($L)", new Object[]{Preconditions.class, componentRequirementName});
                        builderMethod.addJavadoc("@deprecated This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://google.github.io/dagger/unused-modules.\n", new Object[0]);
                        builderMethod.addAnnotation(Deprecated.class);
                    }
                    builderMethod.addStatement("return this", new Object[0]);
                    methods.add((Object)builderMethod.build());
                }
            }
            return methods.build();
        }

        private MethodSpec.Builder addBuilderMethodFromSpec(ExecutableElement method) {
            TypeMirror returnType = method.getReturnType();
            MethodSpec.Builder builderMethod = MethodSpec.methodBuilder((String)method.getSimpleName().toString()).addAnnotation(Override.class).addModifiers((Iterable)Sets.difference(method.getModifiers(), (Set)ImmutableSet.of((Object)((Object)Modifier.ABSTRACT))));
            if (!returnType.getKind().equals((Object)TypeKind.VOID)) {
                builderMethod.returns((TypeName)this.generatedComponentModel.getBuilderName());
            }
            return builderMethod;
        }

        private static void addBuilderMethodReturnStatementForSpec(ExecutableElement specMethod, MethodSpec.Builder builderMethod) {
            if (!specMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                builderMethod.addStatement("return this", new Object[0]);
            }
        }

        private Optional<ComponentDescriptor.BuilderSpec> builderSpec() {
            return this.graph.componentDescriptor().builderSpec();
        }
    }
}

