/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.UniqueNameSet;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class GeneratedComponentModel {
    private final ComponentDescriptor componentDescriptor;
    private final ClassName name;
    private final NestingKind nestingKind;
    private final boolean isAbstract;
    private final Optional<GeneratedComponentModel> supermodel;
    private final Map<TypeElement, GeneratedComponentModel> subcomponentModels = new HashMap<TypeElement, GeneratedComponentModel>();
    private final TypeSpec.Builder component;
    private final SubcomponentNames subcomponentNames;
    private final UniqueNameSet componentFieldNames = new UniqueNameSet();
    private final UniqueNameSet componentMethodNames = new UniqueNameSet();
    private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
    private final List<CodeBlock> cancellations = new ArrayList<CodeBlock>();
    private final ListMultimap<FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
    private final ListMultimap<MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
    private final ListMultimap<TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
    private final List<Supplier<TypeSpec>> switchingProviderSupplier = new ArrayList<Supplier<TypeSpec>>();
    private final ModifiableBindingMethods modifiableBindingMethods = new ModifiableBindingMethods();
    private final SetMultimap<Key, DependencyRequest> contributionsByMultibinding = HashMultimap.create();
    private ImmutableList<ParameterSpec> constructorParameters;

    private GeneratedComponentModel(ComponentDescriptor componentDescriptor, ClassName name, NestingKind nestingKind, Optional<GeneratedComponentModel> supermodel, SubcomponentNames subcomponentNames, Modifier ... modifiers) {
        GeneratedComponentModel.checkName(name, nestingKind);
        this.componentDescriptor = componentDescriptor;
        this.name = name;
        this.nestingKind = nestingKind;
        this.isAbstract = Arrays.asList(modifiers).contains((Object)Modifier.ABSTRACT);
        this.supermodel = supermodel;
        this.component = TypeSpec.classBuilder((ClassName)name).addModifiers(modifiers);
        this.subcomponentNames = subcomponentNames;
    }

    private static void checkName(ClassName name, NestingKind nestingKind) {
        switch (nestingKind) {
            case TOP_LEVEL: {
                Preconditions.checkArgument((name.enclosingClassName() == null ? 1 : 0) != 0, (String)"must be a top-level class name: %s", (Object)name);
                break;
            }
            case MEMBER: {
                Preconditions.checkNotNull((Object)name.enclosingClassName(), (String)"must not be a top-level class name: %s", (Object)name);
                break;
            }
            default: {
                throw new IllegalArgumentException("nestingKind must be TOP_LEVEL or MEMBER: " + (Object)((Object)nestingKind));
            }
        }
    }

    static GeneratedComponentModel create(ClassName name, BindingGraph graph, KeyFactory keyFactory) {
        return new GeneratedComponentModel(graph.componentDescriptor(), name, NestingKind.TOP_LEVEL, Optional.empty(), new SubcomponentNames(graph, keyFactory), Modifier.PUBLIC, graph.componentDescriptor().kind().isTopLevel() ? Modifier.FINAL : Modifier.ABSTRACT);
    }

    static GeneratedComponentModel forSubcomponent(ComponentDescriptor componentDescriptor, GeneratedComponentModel parentModel) {
        return new GeneratedComponentModel(componentDescriptor, parentModel.getSubcomponentName(componentDescriptor), NestingKind.MEMBER, Optional.empty(), parentModel.subcomponentNames, Modifier.PRIVATE, Modifier.FINAL);
    }

    static GeneratedComponentModel forSubcomponent(ComponentDescriptor componentDescriptor, GeneratedComponentModel parentModel, GeneratedComponentModel supermodel) {
        return new GeneratedComponentModel(componentDescriptor, parentModel.getSubcomponentName(componentDescriptor), NestingKind.MEMBER, Optional.of(supermodel), parentModel.subcomponentNames, Modifier.PUBLIC, parentModel.isAbstract() ? Modifier.ABSTRACT : Modifier.FINAL);
    }

    ComponentDescriptor componentDescriptor() {
        return this.componentDescriptor;
    }

    ClassName name() {
        return this.name;
    }

    boolean isNested() {
        return this.nestingKind.isNested();
    }

    boolean isAbstract() {
        return this.isAbstract;
    }

    Optional<GeneratedComponentModel> supermodel() {
        return this.supermodel;
    }

    ImmutableList<ParameterSpec> constructorParameters() {
        return this.constructorParameters;
    }

    ClassName getBuilderName() {
        return this.isNested() ? this.name.peerClass(this.subcomponentNames.get(this.componentDescriptor) + "Builder") : this.name.nestedClass("Builder");
    }

    private ClassName getSubcomponentName(ComponentDescriptor childDescriptor) {
        Preconditions.checkArgument((boolean)this.componentDescriptor.subcomponents().contains((Object)childDescriptor), (String)"%s is not a child of %s", (Object)childDescriptor.componentDefinitionType(), (Object)this.componentDescriptor.componentDefinitionType());
        return this.name.nestedClass(this.subcomponentNames.get(childDescriptor) + "Impl");
    }

    String getSubcomponentName(Key key) {
        return this.subcomponentNames.get(key);
    }

    Optional<GeneratedComponentModel> subcomponentModel(ComponentDescriptor subcomponent) {
        return Optional.ofNullable(this.subcomponentModels.get(subcomponent.componentDefinitionType()));
    }

    boolean isTypeAccessible(TypeMirror type) {
        return Accessibility.isTypeAccessibleFrom(type, this.name.packageName());
    }

    void addSupertype(TypeElement supertype) {
        TypeSpecs.addSupertype(this.component, supertype);
    }

    void addSuperclass(ClassName className) {
        Preconditions.checkState((boolean)this.supermodel.isPresent(), (String)"Setting the supertype for model [%s] as a class when model has no supermodel.", (Object)this.name);
        this.component.superclass((TypeName)className);
    }

    void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
        this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
    }

    void addFields(FieldSpecKind fieldKind, Iterable<FieldSpec> fieldSpecs) {
        this.fieldSpecsMap.putAll((Object)fieldKind, fieldSpecs);
    }

    void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
        this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
    }

    void addMethods(MethodSpecKind methodKind, Iterable<MethodSpec> methodSpecs) {
        this.methodSpecsMap.putAll((Object)methodKind, methodSpecs);
    }

    void addModifiableBindingMethod(ModifiableBindingType type, BindingRequest request, MethodSpec methodSpec, boolean finalized) {
        this.modifiableBindingMethods.addMethod(type, request, methodSpec, finalized);
        this.methodSpecsMap.put((Object)MethodSpecKind.MODIFIABLE_BINDING_METHOD, (Object)methodSpec);
    }

    void registerModifiableBindingMethod(ModifiableBindingType type, BindingRequest request, MethodSpec methodSpec, boolean finalized) {
        this.modifiableBindingMethods.addMethod(type, request, methodSpec, finalized);
    }

    void addImplementedModifiableBindingMethod(ModifiableBindingMethods.ModifiableBindingMethod method) {
        this.modifiableBindingMethods.methodImplemented(method);
        this.methodSpecsMap.put((Object)MethodSpecKind.MODIFIABLE_BINDING_METHOD, (Object)method.methodSpec());
    }

    void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
        this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
    }

    void addTypes(TypeSpecKind typeKind, Iterable<TypeSpec> typeSpecs) {
        this.typeSpecsMap.putAll((Object)typeKind, typeSpecs);
    }

    void addSubcomponent(ComponentDescriptor subcomponent, GeneratedComponentModel subcomponentModel) {
        this.subcomponentModels.put(subcomponent.componentDefinitionType(), subcomponentModel);
        this.addType(TypeSpecKind.SUBCOMPONENT, subcomponentModel.generate().build());
    }

    void addSwitchingProvider(Supplier<TypeSpec> typeSpecSupplier) {
        this.switchingProviderSupplier.add(typeSpecSupplier);
    }

    void addInitialization(CodeBlock codeBlock) {
        this.initializations.add(codeBlock);
    }

    void addCancellation(CodeBlock codeBlock) {
        this.cancellations.add(codeBlock);
    }

    void setConstructorParameters(ImmutableList<ParameterSpec> parameters) {
        this.constructorParameters = parameters;
    }

    String getUniqueFieldName(String name) {
        return this.componentFieldNames.getUniqueName(name);
    }

    String getUniqueMethodName(String name) {
        return this.componentMethodNames.getUniqueName(name);
    }

    String getUniqueMethodName(BindingRequest request) {
        return this.uniqueMethodName(request, SourceFiles.simpleVariableName(MoreTypes.asTypeElement(request.key().type())));
    }

    String getUniqueMethodName(BindingRequest request, ContributionBinding binding) {
        return this.uniqueMethodName(request, BindingVariableNamer.name(binding));
    }

    private String uniqueMethodName(BindingRequest request, String bindingName) {
        String baseMethodName = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, bindingName) + (request.isRequestKind(RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, request.kindName()));
        return this.getUniqueMethodName(baseMethodName);
    }

    void claimMethodName(CharSequence name) {
        this.componentMethodNames.claim(name);
    }

    ImmutableList<CodeBlock> getInitializations() {
        return ImmutableList.copyOf(this.initializations);
    }

    ImmutableList<CodeBlock> getCancellations() {
        return ImmutableList.copyOf(this.cancellations);
    }

    ImmutableList<ModifiableBindingMethods.ModifiableBindingMethod> getModifiableBindingMethods() {
        ImmutableList.Builder modifiableBindingMethodsBuilder = ImmutableList.builder();
        if (this.supermodel.isPresent()) {
            ImmutableList<ModifiableBindingMethods.ModifiableBindingMethod> superclassModifiableBindingMethods = this.supermodel.get().getModifiableBindingMethods();
            superclassModifiableBindingMethods.stream().filter(method -> !this.modifiableBindingMethods.finalized((ModifiableBindingMethods.ModifiableBindingMethod)method)).forEach(arg_0 -> ((ImmutableList.Builder)modifiableBindingMethodsBuilder).add(arg_0));
        }
        modifiableBindingMethodsBuilder.addAll(this.modifiableBindingMethods.getNonFinalizedMethods());
        return modifiableBindingMethodsBuilder.build();
    }

    Optional<ModifiableBindingMethods.ModifiableBindingMethod> getModifiableBindingMethod(BindingRequest request) {
        Optional<ModifiableBindingMethods.ModifiableBindingMethod> method = this.modifiableBindingMethods.getMethod(request);
        if (!method.isPresent() && this.supermodel.isPresent()) {
            return this.supermodel.get().getModifiableBindingMethod(request);
        }
        return method;
    }

    TypeSpec.Builder generate() {
        this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addFields(arg_0));
        this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addMethods(arg_0));
        this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addTypes(arg_0));
        this.switchingProviderSupplier.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)this.component).addType(arg_0));
        return this.component;
    }

    void registerImplementedMultibinding(ContributionBinding multibinding) {
        Preconditions.checkArgument((boolean)multibinding.isSyntheticMultibinding());
        if (!this.contributionsByMultibinding.containsKey((Object)multibinding.key())) {
            this.contributionsByMultibinding.putAll((Object)multibinding.key(), multibinding.dependencies());
        }
    }

    ImmutableSet<DependencyRequest> superclassContributionsMade(Key key) {
        ImmutableSet.Builder contributionsBuilder = ImmutableSet.builder();
        if (this.supermodel.isPresent()) {
            contributionsBuilder.addAll(this.supermodel.get().getAllMultibindingContributions(key));
        }
        return contributionsBuilder.build();
    }

    private ImmutableSet<DependencyRequest> getAllMultibindingContributions(Key key) {
        ImmutableSet.Builder contributionsBuilder = ImmutableSet.builder();
        if (this.contributionsByMultibinding.containsKey((Object)key)) {
            contributionsBuilder.addAll((Iterable)this.contributionsByMultibinding.get((Object)key));
        }
        return contributionsBuilder.addAll(this.superclassContributionsMade(key)).build();
    }

    static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_BUILDER,
        COMPONENT_PROVISION_FACTORY,
        SUBCOMPONENT;

    }

    static enum MethodSpecKind {
        CONSTRUCTOR,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD,
        MODIFIABLE_BINDING_METHOD,
        CANCELLATION_LISTENER_METHOD;

    }

    static enum FieldSpecKind {
        PRIVATE_METHOD_SCOPED_FIELD,
        COMPONENT_REQUIREMENT_FIELD,
        FRAMEWORK_FIELD,
        REFERENCE_RELEASING_MANAGER_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }
}

