/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.Scopes;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreElements;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

final class IncompatiblyScopedBindingsValidator
implements BindingGraphPlugin {
    private final MethodSignatureFormatter methodSignatureFormatter;

    @Inject
    IncompatiblyScopedBindingsValidator(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    public String pluginName() {
        return "Dagger/IncompatiblyScopedBindings";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        ImmutableSetMultimap.Builder incompatibleBindingNodes = ImmutableSetMultimap.builder();
        for (BindingGraph.BindingNode bindingNode : bindingGraph.bindingNodes()) {
            bindingNode.binding().scope().ifPresent(scope -> {
                if (scope.isReusable()) {
                    return;
                }
                BindingGraph.ComponentNode componentNode = (BindingGraph.ComponentNode)bindingGraph.componentNode(bindingNode.componentPath()).get();
                if (!componentNode.scopes().contains(scope)) {
                    incompatibleBindingNodes.put((Object)componentNode, (Object)bindingNode);
                }
            });
        }
        Multimaps.asMap((SetMultimap)incompatibleBindingNodes.build()).forEach((componentNode, bindingNodes) -> diagnosticReporter.reportComponent(Diagnostic.Kind.ERROR, componentNode, this.incompatibleBindingScopesError((BindingGraph.ComponentNode)componentNode, (Set<BindingGraph.BindingNode>)bindingNodes)));
    }

    private String incompatibleBindingScopesError(BindingGraph.ComponentNode componentNode, Set<BindingGraph.BindingNode> bindingNodes) {
        StringBuilder message = new StringBuilder(componentNode.componentPath().currentComponent().getQualifiedName());
        if (!componentNode.scopes().isEmpty()) {
            message.append(" scoped with ").append(componentNode.scopes().stream().map(Scopes::getReadableSource).collect(Collectors.joining(" "))).append(" may not reference bindings with different scopes:\n");
        } else {
            message.append(" (unscoped) may not reference scoped bindings:\n");
        }
        for (BindingGraph.BindingNode bindingNode : bindingNodes) {
            message.append("    ");
            Binding binding = bindingNode.binding();
            switch (binding.kind()) {
                case DELEGATE: 
                case PROVISION: {
                    message.append(this.methodSignatureFormatter.format(MoreElements.asExecutable((Element)binding.bindingElement().get())));
                    break;
                }
                case INJECTION: {
                    message.append(Scopes.getReadableSource((Scope)binding.scope().get())).append(" class ").append(DaggerElements.closestEnclosingTypeElement((Element)binding.bindingElement().get()).getQualifiedName());
                    break;
                }
                default: {
                    throw new AssertionError(bindingNode);
                }
            }
            message.append("\n");
        }
        return message.toString();
    }
}

