/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ModifiableBindingMethods;
import java.util.Optional;

abstract class MethodBindingExpression
extends BindingExpression {
    private final BindingMethodImplementation methodImplementation;
    private final GeneratedComponentModel generatedComponentModel;
    private final Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod;

    protected MethodBindingExpression(BindingMethodImplementation methodImplementation, GeneratedComponentModel generatedComponentModel, Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod) {
        this.methodImplementation = (BindingMethodImplementation)Preconditions.checkNotNull((Object)methodImplementation);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.matchingModifiableBindingMethod = (Optional)Preconditions.checkNotNull(matchingModifiableBindingMethod);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        this.addMethod();
        return Expression.create(this.methodImplementation.returnType(), requestingClass.equals((Object)this.generatedComponentModel.name()) ? CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodName()}) : CodeBlock.of((String)"$T.this.$N()", (Object[])new Object[]{this.generatedComponentModel.name(), this.methodName()}));
    }

    @Override
    final CodeBlock getModifiableBindingMethodImplementation(ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod, GeneratedComponentModel component) {
        if (this.matchingModifiableBindingMethod.isPresent()) {
            Preconditions.checkState((boolean)this.matchingModifiableBindingMethod.get().fulfillsSameRequestAs(modifiableBindingMethod));
            return this.methodImplementation.body();
        }
        return super.getModifiableBindingMethodImplementation(modifiableBindingMethod, component);
    }

    protected abstract void addMethod();

    protected abstract String methodName();
}

