/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MethodBindingExpression;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ResolvedBindings;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class PrivateMethodBindingExpression
extends MethodBindingExpression {
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final BindingMethodImplementation methodImplementation;
    private final GeneratedComponentModel generatedComponentModel;
    private String methodName;

    PrivateMethodBindingExpression(ResolvedBindings resolvedBindings, BindingRequest request, BindingMethodImplementation methodImplementation, GeneratedComponentModel generatedComponentModel, Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod) {
        super(methodImplementation, generatedComponentModel, matchingModifiableBindingMethod);
        this.binding = resolvedBindings.contributionBinding();
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.methodImplementation = (BindingMethodImplementation)Preconditions.checkNotNull((Object)methodImplementation);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
    }

    @Override
    protected void addMethod() {
        if (this.methodName == null) {
            this.methodName = this.generatedComponentModel.getUniqueMethodName(this.request, this.binding);
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.PRIVATE_METHOD, MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.get((TypeMirror)this.methodImplementation.returnType())).addCode(this.methodImplementation.body()).build());
        }
    }

    @Override
    protected String methodName() {
        Preconditions.checkState((this.methodName != null ? 1 : 0) != 0, (Object)"addMethod() must be called before methodName()");
        return this.methodName;
    }
}

