/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackLayoutPanel
extends Composite
implements HasWidgets,
RequiresResize,
ProvidesResize {
    private static final int ANIMATION_TIME = 250;
    private LayoutPanel layoutPanel;
    private Style.Unit unit;
    private ArrayList<LayoutData> layoutData = new ArrayList();
    private Widget visibleWidget;

    public StackLayoutPanel(Style.Unit unit) {
        this.unit = unit;
        this.layoutPanel = new LayoutPanel();
        this.initWidget(this.layoutPanel);
    }

    @Override
    public void add(Widget w) {
        assert (false) : "Single-argument add() is not supported for this widget";
    }

    public void add(Widget widget, Widget header, double headerSize) {
        ClickWrapper wrapper = new ClickWrapper(widget, header);
        this.layoutPanel.add(wrapper);
        this.layoutPanel.add(widget);
        this.layoutPanel.setWidgetLeftRight(wrapper, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        this.layoutPanel.setWidgetLeftRight(widget, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        LayoutData data = new LayoutData(widget, wrapper, headerSize);
        this.layoutData.add(data);
        if (this.visibleWidget == null) {
            this.visibleWidget = widget;
        }
    }

    @Override
    public void clear() {
        this.layoutPanel.clear();
        this.visibleWidget = null;
    }

    @Override
    public Iterator<Widget> iterator() {
        return new Iterator<Widget>(){
            int i = 0;
            int last = -1;

            @Override
            public boolean hasNext() {
                return this.i < StackLayoutPanel.this.layoutData.size();
            }

            @Override
            public Widget next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.i++;
                return ((LayoutData)((StackLayoutPanel)StackLayoutPanel.this).layoutData.get((int)this.last)).widget;
            }

            @Override
            public void remove() {
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                StackLayoutPanel.this.remove(((LayoutData)((StackLayoutPanel)StackLayoutPanel.this).layoutData.get((int)this.last)).widget);
                this.i = this.last;
                this.last = -1;
            }
        };
    }

    @Override
    public void onResize() {
        this.layoutPanel.onResize();
    }

    @Override
    public boolean remove(Widget child) {
        if (child.getParent() != this) {
            return false;
        }
        LayoutData data = (LayoutData)child.getLayoutData();
        this.layoutPanel.remove(data.header);
        this.layoutPanel.remove(child);
        return true;
    }

    public void showWidget(Widget widget) {
        this.showWidget(widget, 250);
    }

    @Override
    protected void onLoad() {
        this.animate(0);
    }

    private void animate(int duration) {
        int i;
        double top = 0.0;
        double bottom = 0.0;
        int visibleIndex = -1;
        for (i = 0; i < this.layoutData.size(); ++i) {
            LayoutData data = this.layoutData.get(i);
            this.layoutPanel.setWidgetTopHeight(data.header, top, this.unit, data.headerSize, this.unit);
            this.layoutPanel.setWidgetTopHeight(data.widget, top += data.headerSize, this.unit, 0.0, this.unit);
            if (data.widget != this.visibleWidget) continue;
            visibleIndex = i;
            break;
        }
        assert (visibleIndex != -1);
        for (int j = this.layoutData.size() - 1; j > i; --j) {
            LayoutData data = this.layoutData.get(j);
            this.layoutPanel.setWidgetBottomHeight(data.header, bottom, this.unit, data.headerSize, this.unit);
            this.layoutPanel.setWidgetBottomHeight(data.widget, bottom, this.unit, 0.0, this.unit);
            bottom += data.headerSize;
        }
        LayoutData data = this.layoutData.get(visibleIndex);
        this.layoutPanel.setWidgetTopBottom(data.widget, top, this.unit, bottom, this.unit);
        this.layoutPanel.animate(duration);
    }

    private void showWidget(Widget widget, int duration) {
        this.visibleWidget = widget;
        this.animate(duration);
    }

    private static class LayoutData {
        public double headerSize;
        public Widget header;
        public Widget widget;

        public LayoutData(Widget widget, Widget header, double headerSize) {
            this.widget = widget;
            this.header = header;
            this.headerSize = headerSize;
        }
    }

    private class ClickWrapper
    extends Composite {
        private Widget target;

        public ClickWrapper(Widget target, Widget wrappee) {
            this.target = target;
            this.initWidget(wrappee);
            this.sinkEvents(1);
        }

        public void onBrowserEvent(Event event) {
            if (event.getTypeInt() == 1) {
                StackLayoutPanel.this.showWidget(this.target);
            }
        }
    }
}

