/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.daggeradapter.Annotations;
import com.google.inject.daggeradapter.Keys;
import com.google.inject.daggeradapter.SupportedAnnotations;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.MapKey;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import dagger.multibindings.IntoSet;
import dagger.multibindings.Multibinds;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Scope;

final class DaggerMethodScanner
extends ModuleAnnotatedMethodScanner {
    private final Predicate<Method> predicate;
    private static final ImmutableSet<Class<? extends Annotation>> SCOPE_ANNOTATIONS = ImmutableSet.of(Scope.class, jakarta.inject.Scope.class);

    static DaggerMethodScanner create(Predicate<Method> predicate) {
        return new DaggerMethodScanner(predicate);
    }

    public ImmutableSet<Class<? extends Annotation>> annotationClasses() {
        return SupportedAnnotations.supportedBindingAnnotations();
    }

    public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
        Method method = (Method)injectionPoint.getMember();
        if (!this.predicate.apply((Object)method)) {
            return null;
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType.equals(Provides.class)) {
            return DaggerMethodScanner.processMultibindingAnnotations(binder, method, key);
        }
        if (annotationType.equals(Binds.class)) {
            this.configureBindsKey(binder, method, key);
            return null;
        }
        if (annotationType.equals(Multibinds.class)) {
            this.configureMultibindsKey(binder, method, key);
            return null;
        }
        if (annotationType.equals(BindsOptionalOf.class)) {
            OptionalBinder.newOptionalBinder((Binder)binder, key);
            return null;
        }
        throw new UnsupportedOperationException(annotation.toString());
    }

    private <T> void configureBindsKey(Binder binder, Method method, Key<T> key) {
        ScopedBindingBuilder scopedBindingBuilder = binder.bind(DaggerMethodScanner.processMultibindingAnnotations(binder, method, key)).to(Keys.parameterKey(method.getParameters()[0]));
        Annotations.getAnnotatedAnnotation((AnnotatedElement)method, SCOPE_ANNOTATIONS).ifPresent(scope -> scopedBindingBuilder.in(scope.annotationType()));
    }

    private static <T> Key<T> processMultibindingAnnotations(Binder binder, Method method, Key<T> key) {
        if (method.isAnnotationPresent(IntoSet.class)) {
            return DaggerMethodScanner.processSetBinding(binder, key);
        }
        if (method.isAnnotationPresent(IntoMap.class)) {
            return DaggerMethodScanner.processMapBinding(binder, key, method);
        }
        return key;
    }

    private static <T> Key<T> processSetBinding(Binder binder, Key<T> key) {
        Multibinder<T> setBinder = DaggerMethodScanner.newSetBinder(binder, key.getTypeLiteral(), key.getAnnotation());
        Key contributionKey = key.withAnnotation(UniqueAnnotations.create());
        setBinder.addBinding().to(contributionKey);
        return contributionKey;
    }

    private static <K, V> Key<V> processMapBinding(Binder binder, Key<V> key, Method method) {
        MapKeyData<K> mapKeyData = DaggerMethodScanner.mapKeyData(method);
        MapBinder mapBinder = DaggerMethodScanner.newMapBinder(binder, mapKeyData.typeLiteral, key.getTypeLiteral(), key.getAnnotation());
        Key contributionKey = key.withAnnotation(UniqueAnnotations.create());
        mapBinder.addBinding(mapKeyData.key).to(contributionKey);
        return contributionKey;
    }

    private static <K> MapKeyData<K> mapKeyData(Method method) {
        Object mapKeyValue;
        Optional<Annotation> mapKeyOpt = Annotations.getAnnotatedAnnotation((AnnotatedElement)method, MapKey.class);
        Preconditions.checkState((boolean)mapKeyOpt.isPresent(), (String)"Missing @MapKey annotation on method %s (make sure the annotation has RUNTIME rentention)", (Object)method);
        Annotation mapKey = mapKeyOpt.get();
        MapKey mapKeyDefinition = mapKey.annotationType().getAnnotation(MapKey.class);
        if (!mapKeyDefinition.unwrapValue()) {
            return MapKeyData.create(TypeLiteral.get(mapKey.annotationType()), mapKey);
        }
        Method mapKeyValueMethod = (Method)Iterables.getOnlyElement(Arrays.asList(mapKey.annotationType().getDeclaredMethods()));
        try {
            mapKeyValue = mapKeyValueMethod.invoke((Object)mapKey, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException("Cannot extract map key value", e);
        }
        return MapKeyData.create(TypeLiteral.get((Type)mapKeyValueMethod.getGenericReturnType()), mapKeyValue);
    }

    private static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> typeLiteral, Annotation possibleAnnotation) {
        return possibleAnnotation == null ? Multibinder.newSetBinder((Binder)binder, typeLiteral) : Multibinder.newSetBinder((Binder)binder, typeLiteral, (Annotation)possibleAnnotation);
    }

    private static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType, Annotation possibleAnnotation) {
        return possibleAnnotation == null ? MapBinder.newMapBinder((Binder)binder, keyType, valueType) : MapBinder.newMapBinder((Binder)binder, keyType, valueType, (Annotation)possibleAnnotation);
    }

    private <T> void configureMultibindsKey(Binder binder, Method method, Key<T> key) {
        Class<?> rawReturnType = method.getReturnType();
        ImmutableList typeParameters = (ImmutableList)Arrays.stream(((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).map(TypeLiteral::get).collect(ImmutableList.toImmutableList());
        if (rawReturnType.equals(Set.class)) {
            DaggerMethodScanner.newSetBinder(binder, (TypeLiteral)typeParameters.get(0), key.getAnnotation());
        } else if (rawReturnType.equals(Map.class)) {
            DaggerMethodScanner.newMapBinder(binder, (TypeLiteral)typeParameters.get(0), (TypeLiteral)typeParameters.get(1), key.getAnnotation());
        } else {
            throw new AssertionError((Object)("@dagger.Multibinds can only be used with Sets or Map, found: " + method.getGenericReturnType()));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DaggerMethodScanner) {
            DaggerMethodScanner that = (DaggerMethodScanner)((Object)object);
            return this.predicate.equals(that.predicate);
        }
        return false;
    }

    public int hashCode() {
        return this.predicate.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("predicate", this.predicate).toString();
    }

    private DaggerMethodScanner(Predicate<Method> predicate) {
        this.predicate = predicate;
    }

    private static class MapKeyData<K> {
        final TypeLiteral<K> typeLiteral;
        final K key;

        MapKeyData(TypeLiteral<K> typeLiteral, K key) {
            this.typeLiteral = typeLiteral;
            this.key = key;
        }

        static <K> MapKeyData<K> create(TypeLiteral<?> typeLiteral, Object key) {
            return new MapKeyData<Object>(typeLiteral, key);
        }
    }
}

