/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.persist.jpa;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.persist.PersistModule;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.UnitOfWork;
import com.google.inject.persist.finder.DynamicFinder;
import com.google.inject.persist.finder.Finder;
import com.google.inject.persist.jpa.Jpa;
import com.google.inject.persist.jpa.JpaFinderProxy;
import com.google.inject.persist.jpa.JpaLocalTxnInterceptor;
import com.google.inject.persist.jpa.JpaPersistOptions;
import com.google.inject.persist.jpa.JpaPersistService;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public final class JpaPersistModule
extends PersistModule {
    private final String jpaUnit;
    private final JpaPersistOptions options;
    private Map<?, ?> properties;
    private MethodInterceptor transactionInterceptor;
    private final List<Class<?>> dynamicFinders = Lists.newArrayList();

    public JpaPersistModule(String jpaUnit) {
        this(jpaUnit, JpaPersistOptions.builder().build());
    }

    public JpaPersistModule(String jpaUnit, JpaPersistOptions options) {
        Preconditions.checkArgument((null != jpaUnit && jpaUnit.length() > 0 ? 1 : 0) != 0, (Object)"JPA unit name must be a non-empty string.");
        this.jpaUnit = jpaUnit;
        this.options = options;
    }

    @Override
    protected void configurePersistence() {
        this.bindConstant().annotatedWith(Jpa.class).to(this.jpaUnit);
        this.bind(JpaPersistOptions.class).annotatedWith(Jpa.class).toInstance((Object)this.options);
        this.bind(JpaPersistService.class).in(Singleton.class);
        this.bind(PersistService.class).to(JpaPersistService.class);
        this.bind(UnitOfWork.class).to(JpaPersistService.class);
        this.bind(EntityManager.class).toProvider(JpaPersistService.class);
        this.bind(EntityManagerFactory.class).toProvider(JpaPersistService.EntityManagerFactoryProvider.class);
        this.transactionInterceptor = new JpaLocalTxnInterceptor();
        this.requestInjection(this.transactionInterceptor);
        for (Class<?> finder : this.dynamicFinders) {
            this.bindFinder(finder);
        }
    }

    @Override
    protected MethodInterceptor getTransactionInterceptor() {
        return this.transactionInterceptor;
    }

    @Provides
    @Jpa
    Map<?, ?> provideProperties() {
        return this.properties;
    }

    public JpaPersistModule properties(Map<?, ?> properties) {
        this.properties = properties;
        return this;
    }

    public <T> JpaPersistModule addFinder(Class<T> iface) {
        this.dynamicFinders.add(iface);
        return this;
    }

    private <T> void bindFinder(Class<T> iface) {
        if (!this.isDynamicFinderValid(iface)) {
            return;
        }
        InvocationHandler finderInvoker = new InvocationHandler(this){
            @Inject
            JpaFinderProxy finderProxy;

            @Override
            public Object invoke(final Object thisObject, final Method method, final Object[] args) throws Throwable {
                if (!method.isAnnotationPresent(Finder.class)) {
                    return method.invoke((Object)this, args);
                }
                return this.finderProxy.invoke(new MethodInvocation(this){

                    public Method getMethod() {
                        return method;
                    }

                    public Object[] getArguments() {
                        return null == args ? new Object[]{} : args;
                    }

                    public Object proceed() throws Throwable {
                        return method.invoke(thisObject, args);
                    }

                    public Object getThis() {
                        throw new UnsupportedOperationException("Bottomless proxies don't expose a this.");
                    }

                    public AccessibleObject getStaticPart() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
        this.requestInjection(finderInvoker);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{iface}, finderInvoker);
        this.bind(iface).toInstance(proxy);
    }

    private boolean isDynamicFinderValid(Class<?> iface) {
        boolean valid = true;
        if (!iface.isInterface()) {
            this.addError(iface + " is not an interface. Dynamic Finders must be interfaces.", new Object[0]);
            valid = false;
        }
        for (Method method : iface.getMethods()) {
            DynamicFinder finder = DynamicFinder.from(method);
            if (null != finder) continue;
            this.addError("Dynamic Finder methods must be annotated with @Finder, but " + iface + "." + method.getName() + " was not", new Object[0]);
            valid = false;
        }
        return valid;
    }
}

