/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.LinkedList;
import java.util.List;

class ExtractPrototypeMemberDeclarations
implements CompilerPass {
    private static final int GLOBAL_VAR_DECL_OVERHEAD = "var t;".length();
    private static final int PER_EXTRACTION_INSTANCE_OVERHEAD = "t=y.prototype;".length();
    private static final int PER_PROTOTYPE_MEMBER_DELTA = "t.y=".length() - "x[p].y=".length();
    private String prototypeAlias = "JSCompiler_prototypeAlias";
    private final AbstractCompiler compiler;

    public ExtractPrototypeMemberDeclarations(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        GatherExtractionInfo extractionInfo = new GatherExtractionInfo();
        NodeTraversal.traverse(this.compiler, root, extractionInfo);
        if (extractionInfo.shouldExtract()) {
            this.doExtraction(extractionInfo);
            this.compiler.reportCodeChange();
        }
    }

    private void doExtraction(GatherExtractionInfo info) {
        Node injectionPoint = this.compiler.getNodeForCodeInsertion(null);
        Node var = NodeUtil.newVarNode(this.prototypeAlias, null).copyInformationFromForTree(injectionPoint);
        injectionPoint.addChildrenToFront(var);
        for (ExtractionInstance instance : info.instances) {
            this.extractInstance(instance);
        }
    }

    private void extractInstance(ExtractionInstance instance) {
        PrototypeMemberDeclaration first = instance.declarations.getFirst();
        String className = first.qualifiedClassName;
        Node stmt = new Node(first.node.getType(), new Node(86, Node.newString(38, this.prototypeAlias), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), className + ".prototype", instance.parent, className + ".prototype"))).copyInformationFromForTree(first.node);
        instance.parent.addChildBefore(stmt, first.node);
        for (PrototypeMemberDeclaration declar : instance.declarations) {
            this.replacePrototypeMemberDeclaration(declar);
        }
    }

    private void replacePrototypeMemberDeclaration(PrototypeMemberDeclaration declar) {
        Node assignment = declar.node.getFirstChild();
        Node lhs = assignment.getFirstChild();
        Node name = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.prototypeAlias + "." + declar.memberName, declar.node, declar.memberName);
        Node accessNode = declar.lhs.getFirstChild().getFirstChild();
        Object originalName = accessNode.getProp(40);
        String className = "?";
        if (originalName != null) {
            className = originalName.toString();
        }
        NodeUtil.setDebugInformation(name.getFirstChild(), lhs, className + ".prototype");
        assignment.replaceChild(lhs, name);
    }

    static /* synthetic */ int access$400() {
        return GLOBAL_VAR_DECL_OVERHEAD;
    }

    private static class PrototypeMemberDeclaration {
        final String memberName;
        final Node node;
        final String qualifiedClassName;
        final Node lhs;

        private PrototypeMemberDeclaration(Node lhs, Node node) {
            this.lhs = lhs;
            this.memberName = NodeUtil.getPrototypePropertyName(lhs);
            this.node = node;
            this.qualifiedClassName = NodeUtil.getPrototypeClassName(lhs).getQualifiedName();
        }

        private boolean isSameClass(PrototypeMemberDeclaration other) {
            return this.qualifiedClassName.equals(other.qualifiedClassName);
        }

        private static PrototypeMemberDeclaration extractDeclaration(Node n) {
            if (!NodeUtil.isPrototypePropertyDeclaration(n)) {
                return null;
            }
            Node lhs = n.getFirstChild().getFirstChild();
            return new PrototypeMemberDeclaration(lhs, n);
        }
    }

    private static class ExtractionInstance {
        LinkedList<PrototypeMemberDeclaration> declarations = Lists.newLinkedList();
        private int delta = 0;
        private final Node parent;

        private ExtractionInstance(PrototypeMemberDeclaration head, Node parent) {
            this.parent = parent;
            this.declarations.add(head);
            this.delta = PER_EXTRACTION_INSTANCE_OVERHEAD + PER_PROTOTYPE_MEMBER_DELTA;
            for (Node cur = head.node.getNext(); cur != null; cur = cur.getNext()) {
                if (NodeUtil.isFunction(cur)) continue;
                PrototypeMemberDeclaration prototypeMember = PrototypeMemberDeclaration.extractDeclaration(cur);
                if (prototypeMember == null || !head.isSameClass(prototypeMember)) break;
                this.declarations.add(prototypeMember);
                this.delta += PER_PROTOTYPE_MEMBER_DELTA;
            }
        }

        boolean isFavorable() {
            return this.delta <= 0;
        }
    }

    private class GatherExtractionInfo
    extends NodeTraversal.AbstractShallowCallback {
        private List<ExtractionInstance> instances = Lists.newLinkedList();
        private int totalDelta = ExtractPrototypeMemberDeclarations.access$400();

        private GatherExtractionInfo() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() != 132 && n.getType() != 125) {
                return;
            }
            for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
                PrototypeMemberDeclaration prototypeMember = PrototypeMemberDeclaration.extractDeclaration(cur);
                if (prototypeMember == null) continue;
                ExtractionInstance instance = new ExtractionInstance(prototypeMember, n);
                cur = instance.declarations.getLast().node;
                if (!instance.isFavorable()) continue;
                this.instances.add(instance);
                this.totalDelta += instance.delta;
            }
        }

        private boolean shouldExtract() {
            return this.totalDelta < 0;
        }
    }
}

