/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class ReorderConstantExpression
implements CompilerPass {
    private AbstractCompiler compiler;

    ReorderConstantExpression(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node node) {
        if ((NodeUtil.isSymmetricOperation(node) || NodeUtil.isRelationalOperation(node)) && NodeUtil.isImmutableValue(node.getLastChild()) && !NodeUtil.isImmutableValue(node.getFirstChild())) {
            if (NodeUtil.isRelationalOperation(node)) {
                int inverseOperator = NodeUtil.getInverseOperator(node.getType());
                node.setType(inverseOperator);
            }
            Node firstNode = node.getFirstChild().detachFromParent();
            Node lastNode = node.getLastChild().detachFromParent();
            node.addChildrenToFront(lastNode);
            node.addChildrenToBack(firstNode);
            this.compiler.reportCodeChange();
        }
        if (node.hasChildren()) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                this.process(externs, child);
            }
        }
    }
}

