/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Map;
import javax.annotation.Nullable;

class ReplaceCssNames
implements CompilerPass {
    static final String GET_CSS_NAME_FUNCTION = "goog.getCssName";
    static final DiagnosticType INVALID_NUM_ARGUMENTS_ERROR = DiagnosticType.error("JSC_GETCSSNAME_NUM_ARGS", "goog.getCssName called with \"{0}\" arguments, expected 1 or 2.");
    static final DiagnosticType STRING_LITERAL_EXPECTED_ERROR = DiagnosticType.error("JSC_GETCSSNAME_STRING_LITERAL_EXPECTED", "goog.getCssName called with invalid argument, string literal expected.  Was \"{0}\".");
    static final DiagnosticType UNEXPECTED_STRING_LITERAL_ERROR = DiagnosticType.error("JSC_GETCSSNAME_UNEXPECTED_STRING_LITERAL", "goog.getCssName called with invalid arguments, string literal passed as first of two arguments.  Did you mean goog.getCssName(\"{0}-{1}\")?");
    static final DiagnosticType UNKNOWN_SYMBOL_WARNING = DiagnosticType.warning("JSC_GETCSSNAME_UNKNOWN_CSS_SYMBOL", "goog.getCssName called with unrecognized symbol \"{0}\" in class \"{1}\".");
    private final AbstractCompiler compiler;
    private final Map<String, Integer> cssNames;
    private CssRenamingMap symbolMap;
    private final JSType nativeStringType;

    ReplaceCssNames(AbstractCompiler compiler, @Nullable Map<String, Integer> cssNames) {
        this.compiler = compiler;
        this.cssNames = cssNames;
        this.nativeStringType = compiler.getTypeRegistry().getNativeType(JSTypeNative.STRING_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        this.symbolMap = this.getCssRenamingMap();
        NodeTraversal.traverse(this.compiler, root, new Traversal());
    }

    @VisibleForTesting
    protected CssRenamingMap getCssRenamingMap() {
        return this.compiler.getCssRenamingMap();
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback {
        private Traversal() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() == 37 && ReplaceCssNames.GET_CSS_NAME_FUNCTION.equals(n.getFirstChild().getQualifiedName())) {
                int count = n.getChildCount();
                Node first = n.getFirstChild().getNext();
                switch (count) {
                    case 2: {
                        if (first.getType() == 40) {
                            this.processStringNode(t, first);
                            n.removeChild(first);
                            parent.replaceChild(n, first);
                            ReplaceCssNames.this.compiler.reportCodeChange();
                            break;
                        }
                        ReplaceCssNames.this.compiler.report(t.makeError(n, STRING_LITERAL_EXPECTED_ERROR, Token.name(first.getType())));
                        break;
                    }
                    case 3: {
                        Node second = first.getNext();
                        if (second.getType() != 40) {
                            ReplaceCssNames.this.compiler.report(t.makeError(n, STRING_LITERAL_EXPECTED_ERROR, Token.name(second.getType())));
                            break;
                        }
                        if (first.getType() == 40) {
                            ReplaceCssNames.this.compiler.report(t.makeError(n, UNEXPECTED_STRING_LITERAL_ERROR, first.getString(), second.getString()));
                            break;
                        }
                        this.processStringNode(t, second);
                        n.removeChild(first);
                        Node replacement = new Node(21, first, Node.newString("-" + second.getString()).copyInformationFrom(second)).copyInformationFrom(n);
                        replacement.setJSType(ReplaceCssNames.this.nativeStringType);
                        parent.replaceChild(n, replacement);
                        ReplaceCssNames.this.compiler.reportCodeChange();
                        break;
                    }
                    default: {
                        ReplaceCssNames.this.compiler.report(t.makeError(n, INVALID_NUM_ARGUMENTS_ERROR, String.valueOf(count)));
                    }
                }
            }
        }

        private void processStringNode(NodeTraversal t, Node n) {
            String name = n.getString();
            String[] parts = name.split("-");
            if (ReplaceCssNames.this.symbolMap != null) {
                String replacement = null;
                switch (ReplaceCssNames.this.symbolMap.getStyle()) {
                    case BY_WHOLE: {
                        replacement = ReplaceCssNames.this.symbolMap.get(name);
                        if (replacement != null) break;
                        ReplaceCssNames.this.compiler.report(t.makeError(n, UNKNOWN_SYMBOL_WARNING, name, name));
                        return;
                    }
                    case BY_PART: {
                        Object[] replaced = new String[parts.length];
                        for (int i = 0; i < parts.length; ++i) {
                            String part = ReplaceCssNames.this.symbolMap.get(parts[i]);
                            if (part == null) {
                                ReplaceCssNames.this.compiler.report(t.makeError(n, UNKNOWN_SYMBOL_WARNING, parts[i], name));
                                return;
                            }
                            replaced[i] = part;
                        }
                        replacement = Joiner.on((String)"-").join(replaced);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown replacement style: " + (Object)((Object)ReplaceCssNames.this.symbolMap.getStyle()));
                    }
                }
                n.setString(replacement);
            }
            if (ReplaceCssNames.this.cssNames != null) {
                for (int i = 0; i < parts.length; ++i) {
                    Integer count = (Integer)ReplaceCssNames.this.cssNames.get(parts[i]);
                    if (count == null) {
                        count = 0;
                    }
                    ReplaceCssNames.this.cssNames.put(parts[i], count + 1);
                }
            }
        }
    }
}

