/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SimpleRegion;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;

public class SourceFile
implements StaticSourceFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int SOURCE_EXCERPT_REGION_LENGTH = 5;
    private final String fileName;
    private boolean isExternFile = false;
    private String originalPath = null;
    private int[] lineOffsets = null;
    private int lastOffset;
    private int lastLine;
    private String code = null;

    public SourceFile(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("a source must have a name");
        }
        this.fileName = fileName;
        this.lastOffset = 0;
        this.lastLine = 1;
    }

    @Override
    public int getLineOffset(int lineno) {
        if (this.lineOffsets == null) {
            this.findLineOffsets();
        }
        if (lineno < 1 || lineno > this.lineOffsets.length) {
            throw new IllegalArgumentException("Expected line number between 1 and " + this.lineOffsets.length + "\nActual: " + lineno);
        }
        return this.lineOffsets[lineno - 1];
    }

    int getNumLines() {
        if (this.lineOffsets == null) {
            this.findLineOffsets();
        }
        return this.lineOffsets.length;
    }

    private void findLineOffsets() {
        try {
            String[] sourceLines = this.getCode().split("\n");
            this.lineOffsets = new int[sourceLines.length];
            for (int ii = 1; ii < sourceLines.length; ++ii) {
                this.lineOffsets[ii] = this.lineOffsets[ii - 1] + sourceLines[ii - 1].length() + 1;
            }
        }
        catch (IOException e) {
            this.lineOffsets = new int[1];
            this.lineOffsets[0] = 0;
        }
    }

    public String getCode() throws IOException {
        return this.code;
    }

    public Reader getCodeReader() throws IOException {
        return new StringReader(this.getCode());
    }

    @VisibleForTesting
    String getCodeNoCache() {
        return this.code;
    }

    private void setCode(String sourceCode) {
        this.code = sourceCode;
    }

    public String getOriginalPath() {
        return this.originalPath != null ? this.originalPath : this.fileName;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public void clearCachedSource() {
    }

    boolean hasSourceInMemory() {
        return this.code != null;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public boolean isExtern() {
        return this.isExternFile;
    }

    void setIsExtern(boolean newVal) {
        this.isExternFile = newVal;
    }

    public String getLine(int lineNumber) {
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = 0;
        int startLine = 1;
        if (lineNumber >= this.lastLine) {
            pos = this.lastOffset;
            startLine = this.lastLine;
        }
        for (int n = startLine; n < lineNumber; ++n) {
            int nextpos = js.indexOf(10, pos);
            if (nextpos == -1) {
                return null;
            }
            pos = nextpos + 1;
        }
        this.lastOffset = pos;
        this.lastLine = lineNumber;
        return js.indexOf(10, pos) == -1 ? null : js.substring(pos, js.indexOf(10, pos));
    }

    public Region getRegion(int lineNumber) {
        int nextpos;
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = 0;
        int startLine = Math.max(1, lineNumber - 3 + 1);
        for (int n = 1; n < startLine && (nextpos = js.indexOf(10, pos)) != -1; ++n) {
            pos = nextpos + 1;
        }
        int end = pos;
        int endLine = startLine;
        int n = 0;
        while (n < 5 && (end = js.indexOf(10, end)) != -1) {
            ++end;
            ++n;
            ++endLine;
        }
        if (lineNumber >= endLine) {
            return null;
        }
        if (end == -1) {
            int last = js.length() - 1;
            if (js.charAt(last) == '\n') {
                return new SimpleRegion(startLine, endLine, js.substring(pos, last));
            }
            return new SimpleRegion(startLine, endLine, js.substring(pos));
        }
        return new SimpleRegion(startLine, endLine, js.substring(pos, end));
    }

    public String toString() {
        return this.fileName;
    }

    public static SourceFile fromFile(String fileName, Charset c) {
        return SourceFile.fromFile(new File(fileName), c);
    }

    public static SourceFile fromFile(String fileName) {
        return SourceFile.fromFile(new File(fileName));
    }

    public static SourceFile fromFile(File file, Charset c) {
        return new OnDisk(file, c);
    }

    public static SourceFile fromFile(File file) {
        return new OnDisk(file);
    }

    public static SourceFile fromCode(String fileName, String code) {
        return new Preloaded(fileName, code);
    }

    public static SourceFile fromCode(String fileName, String originalPath, String code) {
        return new Preloaded(fileName, originalPath, code);
    }

    public static SourceFile fromInputStream(String fileName, InputStream s) throws IOException {
        return SourceFile.fromCode(fileName, CharStreams.toString((Readable)new InputStreamReader(s, Charsets.UTF_8)));
    }

    public static SourceFile fromInputStream(String fileName, String originalPath, InputStream s) throws IOException {
        return SourceFile.fromCode(fileName, originalPath, CharStreams.toString((Readable)new InputStreamReader(s, Charsets.UTF_8)));
    }

    public static SourceFile fromReader(String fileName, Reader r) throws IOException {
        return SourceFile.fromCode(fileName, CharStreams.toString((Readable)r));
    }

    public static SourceFile fromGenerator(String fileName, Generator generator) {
        return new Generated(fileName, generator);
    }

    static class OnDisk
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private final File file;
        protected String inputCharset = Charsets.UTF_8.name();

        OnDisk(File file, Charset c) {
            this(file);
            if (c != null) {
                this.setCharset(c);
            }
        }

        OnDisk(File file) {
            super(file.getPath());
            this.file = file;
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = Files.toString((File)this.file, (Charset)this.getCharset());
                ((SourceFile)this).setCode(cachedCode);
            }
            return cachedCode;
        }

        @Override
        public Reader getCodeReader() throws IOException {
            if (this.hasSourceInMemory()) {
                return super.getCodeReader();
            }
            return new FileReader(this.file);
        }

        @Override
        public void clearCachedSource() {
            ((SourceFile)this).setCode(null);
        }

        public void setCharset(Charset c) {
            this.inputCharset = c.name();
        }

        public Charset getCharset() {
            return Charset.forName(this.inputCharset);
        }
    }

    static class Generated
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private final Generator generator;

        Generated(String fileName, Generator generator) {
            super(fileName);
            this.generator = generator;
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = this.generator.getCode();
                ((SourceFile)this).setCode(cachedCode);
            }
            return cachedCode;
        }

        @Override
        public void clearCachedSource() {
            ((SourceFile)this).setCode(null);
        }
    }

    static class Preloaded
    extends SourceFile {
        private static final long serialVersionUID = 1L;

        Preloaded(String fileName, String code) {
            this(fileName, fileName, code);
        }

        Preloaded(String fileName, String originalPath, String code) {
            super(fileName);
            super.setOriginalPath(originalPath);
            ((SourceFile)this).setCode(code);
        }
    }

    public static interface Generator {
        public String getCode();
    }
}

