/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.EvaluatorException;
import com.google.javascript.rhino.RhinoException;
import java.util.ArrayList;
import java.util.List;

public class SimpleErrorReporter
implements ErrorReporter {
    private List<String> warnings = null;
    private List<String> errors = null;

    @Override
    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(this.formatDetailedMessage(message, sourceName, line, lineSource, lineOffset));
    }

    @Override
    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(this.formatDetailedMessage(message, sourceName, line, lineSource, lineOffset));
    }

    @Override
    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    public List<String> errors() {
        return this.errors;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    private String formatDetailedMessage(String message, String sourceName, int line, String lineSource, int lineOffset) {
        RhinoException e = new RhinoException(message);
        if (sourceName != null) {
            e.initSourceName(sourceName);
        }
        if (lineSource != null) {
            e.initLineSource(lineSource);
        }
        if (line > 0) {
            e.initLineNumber(line);
        }
        if (lineOffset > 0) {
            e.initColumnNumber(lineOffset);
        }
        return e.getMessage();
    }
}

