/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.Maps;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class RecordType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private final SortedMap<String, JSType> properties = Maps.newTreeMap();
    private boolean isFrozen = false;

    RecordType(JSTypeRegistry registry, Map<String, RecordTypeBuilder.RecordProperty> properties) {
        super(registry, null, null);
        for (String property : properties.keySet()) {
            RecordTypeBuilder.RecordProperty prop = properties.get(property);
            if (prop == null) {
                throw new IllegalStateException("RecordProperty associated with a property should not be null!");
            }
            this.defineDeclaredProperty(property, prop.getType(), prop.getPropertyNode());
        }
        this.isFrozen = true;
    }

    @Override
    public boolean isEquivalentTo(JSType other) {
        if (!(other instanceof RecordType)) {
            return false;
        }
        RecordType otherRecord = (RecordType)other;
        Set<String> keySet = this.properties.keySet();
        SortedMap<String, JSType> otherProps = otherRecord.properties;
        if (!((Object)otherProps.keySet()).equals(keySet)) {
            return false;
        }
        for (String key : keySet) {
            if (((JSType)otherProps.get(key)).isEquivalentTo((JSType)this.properties.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        if (this.isFrozen) {
            return false;
        }
        if (!inferred) {
            this.properties.put(propertyName, type);
        }
        return super.defineProperty(propertyName, type, inferred, propertyNode);
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        if (!that.isRecordType()) {
            return super.getLeastSupertype(that);
        }
        RecordType thatRecord = (RecordType)that;
        RecordTypeBuilder builder = new RecordTypeBuilder(this.registry);
        for (String property : this.properties.keySet()) {
            if (!thatRecord.hasProperty(property) || !thatRecord.getPropertyType(property).isEquivalentTo(this.getPropertyType(property))) continue;
            builder.addProperty(property, this.getPropertyType(property), this.getPropertyNode(property));
        }
        return builder.build();
    }

    @Override
    public JSType getGreatestSubtype(JSType that) {
        if (that.isRecordType()) {
            RecordType thatRecord = (RecordType)that;
            RecordTypeBuilder builder = new RecordTypeBuilder(this.registry);
            for (String property : this.properties.keySet()) {
                if (thatRecord.hasProperty(property) && !thatRecord.getPropertyType(property).isEquivalentTo(this.getPropertyType(property))) {
                    return this.registry.getNativeObjectType(JSTypeNative.NO_TYPE);
                }
                builder.addProperty(property, this.getPropertyType(property), this.getPropertyNode(property));
            }
            for (String property : thatRecord.properties.keySet()) {
                if (this.hasProperty(property)) continue;
                builder.addProperty(property, thatRecord.getPropertyType(property), thatRecord.getPropertyNode(property));
            }
            return builder.build();
        }
        JSType greatestSubtype = super.getGreatestSubtype(that);
        if (greatestSubtype.isNoObjectType() && !that.isNoObjectType()) {
            for (Map.Entry<String, JSType> entry : this.properties.entrySet()) {
                String propName = entry.getKey();
                JSType propType = entry.getValue();
                UnionTypeBuilder builder = new UnionTypeBuilder(this.registry);
                for (ObjectType alt : this.registry.getEachReferenceTypeWithProperty(propName)) {
                    JSType altPropType = alt.getPropertyType(propName);
                    if (altPropType == null || alt.isEquivalentTo(this) || !alt.isSubtype(that) || !propType.isUnknownType() && !altPropType.isUnknownType() && !altPropType.isEquivalentTo(propType)) continue;
                    builder.addAlternate(alt);
                }
                greatestSubtype = greatestSubtype.getLeastSupertype(builder.build());
            }
        }
        return greatestSubtype;
    }

    @Override
    public boolean isRecordType() {
        return true;
    }

    @Override
    public boolean isSubtype(JSType that) {
        if (JSType.isSubtype(this, that)) {
            return true;
        }
        if (this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE).isSubtype(that)) {
            return true;
        }
        if (!that.isRecordType()) {
            return false;
        }
        return RecordType.isSubtype(this, (RecordType)that);
    }

    static boolean isSubtype(ObjectType typeA, RecordType typeB) {
        for (String property : typeB.properties.keySet()) {
            if (!typeA.hasProperty(property)) {
                return false;
            }
            JSType propA = typeA.getPropertyType(property);
            JSType propB = typeB.getPropertyType(property);
            if (propA.isUnknownType() || propB.isUnknownType() || !(typeA.isPropertyTypeDeclared(property) ? !propA.isEquivalentTo(propB) : !propA.isSubtype(propB))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        for (String property : this.properties.keySet()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(property);
            sb.append(": ");
            sb.append(((JSType)this.properties.get(property)).toString());
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        for (Map.Entry<String, JSType> entry : this.properties.entrySet()) {
            JSType resolvedType;
            JSType type = entry.getValue();
            if (type == (resolvedType = type.resolve(t, scope))) continue;
            this.properties.put(entry.getKey(), resolvedType);
        }
        return super.resolveInternal(t, scope);
    }
}

