/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.testing.compile.JavaFileObjects;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

final class InMemoryJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final LoadingCache<URI, JavaFileObject> inMemoryFileObjects = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<URI, JavaFileObject>(){

        public JavaFileObject load(URI key) {
            return new InMemoryJavaFileObject(key);
        }
    });

    InMemoryJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    private static URI uriForFileObject(JavaFileManager.Location location, String packageName, String relativeName) {
        return URI.create("mem:///" + location.getName() + '/' + CharMatcher.is((char)'.').replaceFrom((CharSequence)packageName, '/') + '/' + relativeName);
    }

    private static URI uriForJavaFileObject(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
        return URI.create("mem:///" + location.getName() + '/' + CharMatcher.is((char)'.').replaceFrom((CharSequence)className, '/') + kind.extension);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        if (a instanceof InMemoryJavaFileObject && b instanceof InMemoryJavaFileObject) {
            return ((InMemoryJavaFileObject)a).toUri().equals(((InMemoryJavaFileObject)b).toUri());
        }
        if (b instanceof InMemoryJavaFileObject) {
            return false;
        }
        return super.isSameFile(a, b);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        if (location.isOutputLocation()) {
            return (FileObject)this.inMemoryFileObjects.getIfPresent((Object)InMemoryJavaFileManager.uriForFileObject(location, packageName, relativeName));
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location.isOutputLocation()) {
            return (JavaFileObject)this.inMemoryFileObjects.getIfPresent((Object)InMemoryJavaFileManager.uriForJavaFileObject(location, className, kind));
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        URI uri = InMemoryJavaFileManager.uriForFileObject(location, packageName, relativeName);
        return (FileObject)this.inMemoryFileObjects.getUnchecked((Object)uri);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        URI uri = InMemoryJavaFileManager.uriForJavaFileObject(location, className, kind);
        return (JavaFileObject)this.inMemoryFileObjects.getUnchecked((Object)uri);
    }

    ImmutableList<JavaFileObject> getGeneratedSources() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry entry : this.inMemoryFileObjects.asMap().entrySet()) {
            if (!((URI)entry.getKey()).getPath().startsWith("/" + StandardLocation.SOURCE_OUTPUT.name()) || ((JavaFileObject)entry.getValue()).getKind() != JavaFileObject.Kind.SOURCE) continue;
            result.add(entry.getValue());
        }
        return result.build();
    }

    ImmutableList<JavaFileObject> getOutputFiles() {
        return ImmutableList.copyOf(this.inMemoryFileObjects.asMap().values());
    }

    private static final class InMemoryJavaFileObject
    extends SimpleJavaFileObject
    implements JavaFileObject {
        private long lastModified = 0L;
        private Optional<ByteSource> data = Optional.absent();

        InMemoryJavaFileObject(URI uri) {
            super(uri, JavaFileObjects.deduceKind(uri));
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.data.isPresent()) {
                return ((ByteSource)this.data.get()).openStream();
            }
            throw new FileNotFoundException();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    InMemoryJavaFileObject.this.data = Optional.of((Object)ByteSource.wrap((byte[])this.toByteArray()));
                    InMemoryJavaFileObject.this.lastModified = System.currentTimeMillis();
                }
            };
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            if (this.data.isPresent()) {
                return ((ByteSource)this.data.get()).asCharSource(Charset.defaultCharset()).openStream();
            }
            throw new FileNotFoundException();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            if (this.data.isPresent()) {
                return ((ByteSource)this.data.get()).asCharSource(Charset.defaultCharset()).read();
            }
            throw new FileNotFoundException();
        }

        @Override
        public Writer openWriter() throws IOException {
            return new StringWriter(){

                @Override
                public void close() throws IOException {
                    super.close();
                    InMemoryJavaFileObject.this.data = Optional.of((Object)ByteSource.wrap((byte[])this.toString().getBytes(Charset.defaultCharset())));
                    InMemoryJavaFileObject.this.lastModified = System.currentTimeMillis();
                }
            };
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public boolean delete() {
            this.data = Optional.absent();
            this.lastModified = 0L;
            return true;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper((Object)this).add("uri", (Object)this.toUri()).add("kind", (Object)this.kind).toString();
        }
    }
}

