/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSource;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompileTester;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.ProcessedCompileTesterFactory;
import com.google.testing.compile.TreeContext;
import com.google.testing.compile.TreeDiffer;
import com.google.testing.compile.TreeDifference;
import com.google.testing.compile.TypeEnumerator;
import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public final class JavaSourcesSubject
extends Subject<JavaSourcesSubject, Iterable<? extends JavaFileObject>>
implements CompileTester,
ProcessedCompileTesterFactory {
    private final Set<String> options = Sets.newHashSet();

    JavaSourcesSubject(FailureStrategy failureStrategy, Iterable<? extends JavaFileObject> subject) {
        super(failureStrategy, subject);
    }

    @Override
    public ProcessedCompileTesterFactory withCompilerOptions(Iterable<String> options) {
        Iterables.addAll(this.options, options);
        return this;
    }

    @Override
    public ProcessedCompileTesterFactory withCompilerOptions(String ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    @Override
    public CompileTester processedWith(Processor first, Processor ... rest) {
        return this.processedWith(Lists.asList((Object)first, (Object[])rest));
    }

    @Override
    public CompileTester processedWith(Iterable<? extends Processor> processors) {
        return new CompilationClause(processors);
    }

    @Override
    public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
        new CompilationClause().parsesAs(first, rest);
    }

    @Override
    public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
        return new CompilationClause().compilesWithoutError();
    }

    @Override
    public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
        return new CompilationClause().failsToCompile();
    }

    private CompilationClause newCompilationClause(Iterable<? extends Processor> processors) {
        return new CompilationClause(processors);
    }

    public static final class SingleSourceAdapter
    extends Subject<SingleSourceAdapter, JavaFileObject>
    implements CompileTester,
    ProcessedCompileTesterFactory {
        private final JavaSourcesSubject delegate;

        SingleSourceAdapter(FailureStrategy failureStrategy, JavaFileObject subject) {
            super(failureStrategy, (Object)subject);
            this.delegate = new JavaSourcesSubject(failureStrategy, (Iterable<? extends JavaFileObject>)ImmutableList.of((Object)subject));
        }

        @Override
        public ProcessedCompileTesterFactory withCompilerOptions(Iterable<String> options) {
            return this.delegate.withCompilerOptions(options);
        }

        @Override
        public ProcessedCompileTesterFactory withCompilerOptions(String ... options) {
            return this.delegate.withCompilerOptions(options);
        }

        @Override
        public CompileTester processedWith(Processor first, Processor ... rest) {
            return this.delegate.newCompilationClause(Lists.asList((Object)first, (Object[])rest));
        }

        @Override
        public CompileTester processedWith(Iterable<? extends Processor> processors) {
            return this.delegate.newCompilationClause(processors);
        }

        @Override
        public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
            return this.delegate.compilesWithoutError();
        }

        @Override
        public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
            return this.delegate.failsToCompile();
        }

        @Override
        public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
            this.delegate.parsesAs(first, rest);
        }
    }

    private final class SuccessfulFileBuilder
    implements CompileTester.SuccessfulFileClause {
        private final SuccessfulCompilationBuilder compilationClause;
        private final String generatedFilePath;
        private final ByteSource generatedByteSource;

        SuccessfulFileBuilder(SuccessfulCompilationBuilder compilationClause, String generatedFilePath, ByteSource generatedByteSource) {
            this.compilationClause = compilationClause;
            this.generatedFilePath = generatedFilePath;
            this.generatedByteSource = generatedByteSource;
        }

        @Override
        public CompileTester.GeneratedPredicateClause and() {
            return this.compilationClause;
        }

        @Override
        public CompileTester.SuccessfulFileClause withContents(ByteSource expectedByteSource) {
            try {
                if (!expectedByteSource.contentEquals(this.generatedByteSource)) {
                    JavaSourcesSubject.this.failureStrategy.fail("The contents in " + this.generatedFilePath + " did not match the expected contents");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }
    }

    private final class SuccessfulCompilationBuilder
    implements CompileTester.SuccessfulCompilationClause,
    CompileTester.GeneratedPredicateClause {
        private final Compilation.Result result;

        SuccessfulCompilationBuilder(Compilation.Result result) {
            Preconditions.checkArgument((boolean)result.successful());
            this.result = result;
        }

        @Override
        public CompileTester.GeneratedPredicateClause and() {
            return this;
        }

        @Override
        public CompileTester.SuccessfulCompilationClause generatesSources(JavaFileObject first, JavaFileObject ... rest) {
            new JavaSourcesSubject(JavaSourcesSubject.this.failureStrategy, (Iterable<? extends JavaFileObject>)this.result.generatedSources()).parsesAs(first, rest);
            return this;
        }

        @Override
        public CompileTester.SuccessfulCompilationClause generatesFiles(JavaFileObject first, JavaFileObject ... rest) {
            for (JavaFileObject expected : Lists.asList((Object)first, (Object[])rest)) {
                if (this.wasGenerated(this.result, expected)) continue;
                JavaSourcesSubject.this.failureStrategy.fail("Did not find a generated file corresponding to " + expected.getName());
            }
            return this;
        }

        boolean wasGenerated(Compilation.Result result, JavaFileObject expected) {
            ByteSource expectedByteSource = JavaFileObjects.asByteSource(expected);
            for (JavaFileObject generated : result.generatedFilesByKind().get((Object)expected.getKind())) {
                try {
                    ByteSource generatedByteSource = JavaFileObjects.asByteSource(generated);
                    if (!expectedByteSource.contentEquals(generatedByteSource)) continue;
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        @Override
        public CompileTester.SuccessfulFileClause generatesFileNamed(JavaFileManager.Location location, String packageName, String relativeName) {
            String expectedFilename = location.getName() + '/' + packageName.replace('.', '/') + '/' + relativeName;
            for (JavaFileObject generated : this.result.generatedFilesByKind().values()) {
                if (!generated.toUri().getPath().endsWith(expectedFilename)) continue;
                return new SuccessfulFileBuilder(this, generated.toUri().getPath(), JavaFileObjects.asByteSource(generated));
            }
            StringBuilder encounteredFiles = new StringBuilder();
            for (JavaFileObject generated : this.result.generatedFilesByKind().values()) {
                if (!generated.toUri().getPath().contains(location.getName())) continue;
                encounteredFiles.append("  ").append(generated.toUri().getPath()).append('\n');
            }
            JavaSourcesSubject.this.failureStrategy.fail("Did not find a generated file corresponding to " + relativeName + " in package " + packageName + "; Found: " + encounteredFiles.toString());
            return new SuccessfulFileBuilder(this, null, null);
        }
    }

    private final class UnsuccessfulCompilationBuilder
    implements CompileTester.UnsuccessfulCompilationClause {
        private final Compilation.Result result;

        UnsuccessfulCompilationBuilder(Compilation.Result result) {
            Preconditions.checkArgument((!result.successful() ? 1 : 0) != 0);
            this.result = result;
        }

        @Override
        public CompileTester.FileClause withErrorContaining(final String messageFragment) {
            FluentIterable diagnostics = FluentIterable.from((Iterable)this.result.diagnosticsByKind().get((Object)Diagnostic.Kind.ERROR));
            final FluentIterable diagnosticsWithMessage = diagnostics.filter(new Predicate<Diagnostic<?>>(){

                public boolean apply(Diagnostic<?> input) {
                    return input.getMessage(null).contains(messageFragment);
                }
            });
            if (diagnosticsWithMessage.isEmpty()) {
                JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected an error containing \"%s\", but only found %s", messageFragment, diagnostics.transform(new Function<Diagnostic<?>, String>(){

                    public String apply(Diagnostic<?> input) {
                        return "\"" + input.getMessage(null) + "\"";
                    }
                })));
            }
            return new CompileTester.FileClause(){

                @Override
                public CompileTester.UnsuccessfulCompilationClause and() {
                    return UnsuccessfulCompilationBuilder.this;
                }

                @Override
                public CompileTester.LineClause in(final JavaFileObject file) {
                    final FluentIterable diagnosticsInFile = diagnosticsWithMessage.filter((Predicate)new Predicate<Diagnostic<? extends FileObject>>(){

                        public boolean apply(Diagnostic<? extends FileObject> input) {
                            return input.getSource() != null && file.toUri().getPath().equals(input.getSource().toUri().getPath());
                        }
                    });
                    if (diagnosticsInFile.isEmpty()) {
                        JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected an error in %s, but only found errors in %s", file.getName(), diagnosticsWithMessage.transform((Function)new Function<Diagnostic<? extends FileObject>, String>(){

                            public String apply(Diagnostic<? extends FileObject> input) {
                                return input.getSource() != null ? input.getSource().getName() : "(no associated file)";
                            }
                        }).toSet()));
                    }
                    return new CompileTester.LineClause(){

                        @Override
                        public CompileTester.UnsuccessfulCompilationClause and() {
                            return UnsuccessfulCompilationBuilder.this;
                        }

                        @Override
                        public CompileTester.ColumnClause onLine(final long lineNumber) {
                            final FluentIterable diagnosticsOnLine = diagnosticsWithMessage.filter(new Predicate<Diagnostic<?>>(){

                                public boolean apply(Diagnostic<?> input) {
                                    return lineNumber == input.getLineNumber();
                                }
                            });
                            if (diagnosticsOnLine.isEmpty()) {
                                JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected an error on line %d of %s, but only found errors on line(s) %s", lineNumber, file.getName(), diagnosticsInFile.transform(new Function<Diagnostic<?>, String>(){

                                    public String apply(Diagnostic<?> input) {
                                        long errLine = input.getLineNumber();
                                        return errLine != -1L ? errLine + "" : "(no associated position)";
                                    }
                                }).toSet()));
                            }
                            return new CompileTester.ColumnClause(){

                                @Override
                                public CompileTester.UnsuccessfulCompilationClause and() {
                                    return UnsuccessfulCompilationBuilder.this;
                                }

                                @Override
                                public CompileTester.ChainingClause<CompileTester.UnsuccessfulCompilationClause> atColumn(final long columnNumber) {
                                    FluentIterable diagnosticsAtColumn = diagnosticsOnLine.filter(new Predicate<Diagnostic<?>>(){

                                        public boolean apply(Diagnostic<?> input) {
                                            return columnNumber == input.getColumnNumber();
                                        }
                                    });
                                    if (diagnosticsAtColumn.isEmpty()) {
                                        JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected an error at %d:%d of %s, but only found errors at column(s) %s", lineNumber, columnNumber, file.getName(), diagnosticsOnLine.transform(new Function<Diagnostic<?>, String>(){

                                            public String apply(Diagnostic<?> input) {
                                                long errCol = input.getColumnNumber();
                                                return errCol != -1L ? errCol + "" : "(no associated position)";
                                            }
                                        }).toSet()));
                                    }
                                    return new CompileTester.ChainingClause<CompileTester.UnsuccessfulCompilationClause>(){

                                        @Override
                                        public CompileTester.UnsuccessfulCompilationClause and() {
                                            return UnsuccessfulCompilationBuilder.this;
                                        }
                                    };
                                }
                            };
                        }
                    };
                }
            };
        }
    }

    private final class CompilationClause
    implements CompileTester {
        private final ImmutableSet<Processor> processors;

        private CompilationClause() {
            this((Iterable<? extends Processor>)ImmutableSet.of());
        }

        private CompilationClause(Iterable<? extends Processor> processors) {
            this.processors = ImmutableSet.copyOf(processors);
        }

        private String reportFileGenerated(JavaFileObject generatedFile) {
            try {
                StringBuilder entry = new StringBuilder().append(String.format("\n%s:\n", generatedFile.toUri().getPath()));
                if (generatedFile.getKind().equals((Object)JavaFileObject.Kind.CLASS)) {
                    entry.append(String.format("[generated class file (%s bytes)]", JavaFileObjects.asByteSource(generatedFile).size()));
                } else {
                    entry.append(generatedFile.getCharContent(true));
                }
                return entry.append("\n").toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read from JavaFileObject when it was already in memory.", e);
            }
        }

        private String reportFilesGenerated(Compilation.Result result) {
            FluentIterable generatedFiles = FluentIterable.from(result.generatedSources());
            StringBuilder message = new StringBuilder("\n\n");
            if (generatedFiles.isEmpty()) {
                return message.append("(No files were generated.)\n").toString();
            }
            message.append("Generated Files\n").append("===============\n");
            for (JavaFileObject generatedFile : generatedFiles) {
                message.append(this.reportFileGenerated(generatedFile));
            }
            return message.toString();
        }

        @Override
        public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
            Compilation.ParseResult actualResult = Compilation.parse((Iterable)JavaSourcesSubject.this.getSubject());
            ImmutableList errors = actualResult.diagnosticsByKind().get((Object)Diagnostic.Kind.ERROR);
            if (!errors.isEmpty()) {
                StringBuilder message = new StringBuilder("Parsing produced the following errors:\n");
                for (Diagnostic error : errors) {
                    message.append('\n');
                    message.append(error);
                }
                JavaSourcesSubject.this.failureStrategy.fail(message.toString());
            }
            Compilation.ParseResult expectedResult = Compilation.parse(Lists.asList((Object)first, (Object[])rest));
            final FluentIterable actualTrees = FluentIterable.from(actualResult.compilationUnits());
            FluentIterable expectedTrees = FluentIterable.from(expectedResult.compilationUnits());
            Function<CompilationUnitTree, ImmutableSet<String>> getTypesFunction = new Function<CompilationUnitTree, ImmutableSet<String>>(){

                public ImmutableSet<String> apply(CompilationUnitTree compilationUnit) {
                    return TypeEnumerator.getTopLevelTypes(compilationUnit);
                }
            };
            final ImmutableMap expectedTreeTypes = Maps.toMap((Iterable)expectedTrees, (Function)getTypesFunction);
            final ImmutableMap actualTreeTypes = Maps.toMap((Iterable)actualTrees, (Function)getTypesFunction);
            ImmutableMap matchedTrees = Maps.toMap((Iterable)expectedTrees, (Function)new Function<CompilationUnitTree, Optional<? extends CompilationUnitTree>>(){

                public Optional<? extends CompilationUnitTree> apply(final CompilationUnitTree expectedTree) {
                    return Iterables.tryFind((Iterable)actualTrees, (Predicate)new Predicate<CompilationUnitTree>(){

                        public boolean apply(CompilationUnitTree actualTree) {
                            return ((ImmutableSet)expectedTreeTypes.get((Object)expectedTree)).equals(actualTreeTypes.get((Object)actualTree));
                        }
                    });
                }
            });
            for (Map.Entry matchedTreePair : matchedTrees.entrySet()) {
                CompilationUnitTree expectedTree = (CompilationUnitTree)matchedTreePair.getKey();
                if (!((Optional)matchedTreePair.getValue()).isPresent()) {
                    this.failNoCandidates((ImmutableSet<String>)((ImmutableSet)expectedTreeTypes.get((Object)expectedTree)), expectedTree, (ImmutableMap<? extends CompilationUnitTree, ImmutableSet<String>>)actualTreeTypes, (FluentIterable<? extends CompilationUnitTree>)actualTrees);
                    continue;
                }
                CompilationUnitTree actualTree = (CompilationUnitTree)((Optional)matchedTreePair.getValue()).get();
                TreeDifference treeDifference = TreeDiffer.diffCompilationUnits(expectedTree, actualTree);
                if (treeDifference.isEmpty()) continue;
                String diffReport = treeDifference.getDiffReport(new TreeContext(expectedTree, expectedResult.trees()), new TreeContext(actualTree, actualResult.trees()));
                this.failWithCandidate(expectedTree.getSourceFile(), actualTree.getSourceFile(), diffReport);
            }
        }

        private void failNoCandidates(ImmutableSet<String> expectedTypes, CompilationUnitTree expectedTree, final ImmutableMap<? extends CompilationUnitTree, ImmutableSet<String>> actualTypes, FluentIterable<? extends CompilationUnitTree> actualTrees) {
            String generatedTypesReport = Joiner.on((char)'\n').join((Iterable)actualTrees.transform((Function)new Function<CompilationUnitTree, String>(){

                public String apply(CompilationUnitTree generated) {
                    return String.format("- %s in <%s>", actualTypes.get((Object)generated), generated.getSourceFile().toUri().getPath());
                }
            }).toList());
            JavaSourcesSubject.this.failureStrategy.fail(Joiner.on((char)'\n').join((Object)"", (Object)"An expected source declared one or more top-level types that were not present.", new Object[]{"", String.format("Expected top-level types: <%s>", expectedTypes), String.format("Declared by expected file: <%s>", expectedTree.getSourceFile().toUri().getPath()), "", "The top-level types that were present are as follows: ", "", generatedTypesReport, ""}));
        }

        private void failWithCandidate(JavaFileObject expectedSource, JavaFileObject actualSource, String diffReport) {
            try {
                JavaSourcesSubject.this.failureStrategy.fail(Joiner.on((char)'\n').join((Object)"", (Object)"Source declared the same top-level types of an expected source, but", new Object[]{"didn't match exactly.", "", String.format("Expected file: <%s>", expectedSource.toUri().getPath()), String.format("Actual file: <%s>", actualSource.toUri().getPath()), "", "Diffs:", "======", "", diffReport, "", "Expected Source: ", "================", "", expectedSource.getCharContent(false).toString(), "", "Actual Source:", "=================", "", actualSource.getCharContent(false).toString()}));
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read from JavaFileObject when it was already in memory.", e);
            }
        }

        @Override
        public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
            Compilation.Result result = Compilation.compile(this.processors, (Set<String>)ImmutableSet.copyOf((Collection)JavaSourcesSubject.this.options), (Iterable)JavaSourcesSubject.this.getSubject());
            if (!result.successful()) {
                ImmutableList errors = result.diagnosticsByKind().get((Object)Diagnostic.Kind.ERROR);
                StringBuilder message = new StringBuilder("Compilation produced the following errors:\n");
                for (Diagnostic error : errors) {
                    message.append('\n');
                    message.append(error);
                }
                message.append('\n');
                message.append(this.reportFilesGenerated(result));
                JavaSourcesSubject.this.failureStrategy.fail(message.toString());
            }
            return new SuccessfulCompilationBuilder(result);
        }

        @Override
        public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
            Compilation.Result result = Compilation.compile(this.processors, (Set<String>)ImmutableSet.copyOf((Collection)JavaSourcesSubject.this.options), (Iterable)JavaSourcesSubject.this.getSubject());
            if (result.successful()) {
                String message = Joiner.on((char)'\n').join((Object)"Compilation was expected to fail, but contained no errors.", (Object)"", new Object[]{this.reportFilesGenerated(result)});
                JavaSourcesSubject.this.failureStrategy.fail(message);
            }
            return new UnsuccessfulCompilationBuilder(result);
        }
    }
}

