/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.testing.compile.Breadcrumbs;
import com.google.testing.compile.TreeContext;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.annotation.Nullable;

final class TreeDifference {
    private static final String NO_LINE = "[unavailable]";
    private final ImmutableList<OneWayDiff> extraExpectedNodes;
    private final ImmutableList<OneWayDiff> extraActualNodes;
    private final ImmutableList<TwoWayDiff> differingNodes;

    TreeDifference() {
        this.extraExpectedNodes = ImmutableList.of();
        this.extraActualNodes = ImmutableList.of();
        this.differingNodes = ImmutableList.of();
    }

    TreeDifference(ImmutableList<OneWayDiff> extraExpectedNodes, ImmutableList<OneWayDiff> extraActualNodes, ImmutableList<TwoWayDiff> differingNodes) {
        this.extraExpectedNodes = extraExpectedNodes;
        this.extraActualNodes = extraActualNodes;
        this.differingNodes = differingNodes;
    }

    boolean isEmpty() {
        return this.extraExpectedNodes.isEmpty() && this.extraActualNodes.isEmpty() && this.differingNodes.isEmpty();
    }

    ImmutableList<OneWayDiff> getExtraExpectedNodes() {
        return this.extraExpectedNodes;
    }

    ImmutableList<OneWayDiff> getExtraActualNodes() {
        return this.extraActualNodes;
    }

    ImmutableList<TwoWayDiff> getDifferingNodes() {
        return this.differingNodes;
    }

    String getDiffReport() {
        return this.getDiffReport(null, null);
    }

    String getDiffReport(@Nullable TreeContext expectedContext, @Nullable TreeContext actualContext) {
        ImmutableList.Builder reportLines = new ImmutableList.Builder();
        if (!this.extraExpectedNodes.isEmpty()) {
            reportLines.add((Object)String.format("Found %s unmatched nodes in the expected tree. %n", this.extraExpectedNodes.size()));
            for (Object diff : this.extraExpectedNodes) {
                reportLines.add((Object)this.createMessage(((OneWayDiff)diff).getDetails(), ((OneWayDiff)diff).getNodePath(), expectedContext, true));
            }
        }
        if (!this.extraActualNodes.isEmpty()) {
            reportLines.add((Object)String.format("Found %s unmatched nodes in the actual tree. %n", this.extraActualNodes.size()));
            for (Object diff : this.extraActualNodes) {
                reportLines.add((Object)this.createMessage(((OneWayDiff)diff).getDetails(), ((OneWayDiff)diff).getNodePath(), actualContext, false));
            }
        }
        if (!this.differingNodes.isEmpty()) {
            reportLines.add((Object)String.format("Found %s nodes that differed in expected and actual trees. %n", this.differingNodes.size()));
            for (Object diff : this.differingNodes) {
                reportLines.add((Object)this.createMessage(((TwoWayDiff)diff).getDetails(), ((TwoWayDiff)diff).getExpectedNodePath(), expectedContext, ((TwoWayDiff)diff).getActualNodePath(), actualContext));
            }
        }
        return Joiner.on((char)'\n').join((Iterable)reportLines.build());
    }

    private String createMessage(String details, TreePath nodePath, @Nullable TreeContext treeContext, boolean onExpected) {
        long startLine = treeContext == null ? -1L : treeContext.getNodeStartLine(nodePath.getLeaf());
        String contextStr = String.format("Line %s %s", startLine == -1L ? NO_LINE : Long.valueOf(startLine), Breadcrumbs.describeTreePath(nodePath));
        return Joiner.on((char)'\n').join((Object)String.format("> Extra node in %s tree.", onExpected ? "expected" : "actual"), (Object)String.format("  %s", contextStr), new Object[]{String.format("  Node contents: <%s>.", this.nodeContents(nodePath.getLeaf())), String.format("  %s", details), ""});
    }

    private String createMessage(String details, TreePath expectedNodePath, @Nullable TreeContext expectedTreeContext, TreePath actualNodePath, @Nullable TreeContext actualTreeContext) {
        long expectedTreeStartLine = expectedTreeContext == null ? -1L : expectedTreeContext.getNodeStartLine(expectedNodePath.getLeaf());
        String expectedContextStr = String.format("Line %s %s", expectedTreeStartLine == -1L ? NO_LINE : Long.valueOf(expectedTreeStartLine), Breadcrumbs.describeTreePath(expectedNodePath));
        long actualTreeStartLine = actualTreeContext == null ? -1L : actualTreeContext.getNodeStartLine(actualNodePath.getLeaf());
        String actualContextStr = String.format("Line %s %s", actualTreeStartLine == -1L ? NO_LINE : Long.valueOf(actualTreeStartLine), Breadcrumbs.describeTreePath(actualNodePath));
        return Joiner.on((char)'\n').join((Object)"> Difference in expected tree and actual tree.", (Object)String.format("  Expected node: %s", expectedContextStr), new Object[]{String.format("  Actual node: %s", actualContextStr), String.format("  %s", details), ""});
    }

    private String nodeContents(Tree node) {
        return node.toString().replaceFirst("\n", "");
    }

    static final class TwoWayDiff {
        private final TreePath expectedNodePath;
        private final TreePath actualNodePath;
        private String details;

        TwoWayDiff(TreePath expectedNodePath, TreePath actualNodePath, String details) {
            this.expectedNodePath = expectedNodePath;
            this.actualNodePath = actualNodePath;
            this.details = details;
        }

        TreePath getExpectedNodePath() {
            return this.expectedNodePath;
        }

        TreePath getActualNodePath() {
            return this.actualNodePath;
        }

        String getDetails() {
            return this.details;
        }
    }

    static final class OneWayDiff {
        private final TreePath nodePath;
        private String details;

        OneWayDiff(TreePath nodePath, String details) {
            this.nodePath = nodePath;
            this.details = details;
        }

        TreePath getNodePath() {
            return this.nodePath;
        }

        String getDetails() {
            return this.details;
        }
    }

    static final class Builder {
        private final ImmutableList.Builder<OneWayDiff> extraExpectedNodesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<OneWayDiff> extraActualNodesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<TwoWayDiff> differingNodesBuilder = new ImmutableList.Builder();

        Builder() {
        }

        Builder addExtraExpectedNode(TreePath extraNode) {
            return this.addExtraExpectedNode(extraNode, "");
        }

        Builder addExtraExpectedNode(TreePath extraNode, String message) {
            this.extraExpectedNodesBuilder.add((Object)new OneWayDiff(extraNode, message));
            return this;
        }

        Builder addExtraActualNode(TreePath extraNode, String message) {
            this.extraActualNodesBuilder.add((Object)new OneWayDiff(extraNode, message));
            return this;
        }

        Builder addExtraActualNode(TreePath extraNode) {
            return this.addExtraActualNode(extraNode, "");
        }

        Builder addDifferingNodes(TreePath expectedNode, TreePath actualNode) {
            return this.addDifferingNodes(expectedNode, actualNode, "");
        }

        Builder addDifferingNodes(TreePath expectedNode, TreePath actualNode, String message) {
            this.differingNodesBuilder.add((Object)new TwoWayDiff(expectedNode, actualNode, message));
            return this;
        }

        TreeDifference build() {
            return new TreeDifference((ImmutableList<OneWayDiff>)this.extraExpectedNodesBuilder.build(), (ImmutableList<OneWayDiff>)this.extraActualNodesBuilder.build(), (ImmutableList<TwoWayDiff>)this.differingNodesBuilder.build());
        }
    }
}

