/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.RecordComponentInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.RecordComponentInfoVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InterfaceDeleter;
import proguard.classfile.editor.SubclassAdder;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.SubclassFilter;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.peephole.ClassMerger;
import proguard.util.ArrayUtil;

public class TargetClassChanger
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
RecordComponentInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final Logger logger = LogManager.getLogger(TargetClassChanger.class);

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        Clazz targetClass;
        programClass.constantPoolEntriesAccept((ConstantVisitor)this);
        programClass.fieldsAccept((MemberVisitor)this);
        programClass.methodsAccept((MemberVisitor)this);
        programClass.attributesAccept((AttributeVisitor)this);
        boolean[] delete = null;
        for (int index = 0; index < programClass.u2interfacesCount; ++index) {
            Clazz interfaceClass = programClass.getInterface(index);
            if (interfaceClass == null || !programClass.equals(interfaceClass) && !this.containsInterfaceClass((Clazz)programClass, index, interfaceClass)) continue;
            if (delete == null) {
                delete = new boolean[programClass.u2interfacesCount];
            }
            delete[index] = true;
        }
        if (delete != null) {
            new InterfaceDeleter(delete, false).visitProgramClass(programClass);
        }
        if ((targetClass = ClassMerger.getTargetClass((Clazz)programClass)) != null) {
            programClass.u2thisClass = this.addNewClassConstant(programClass, programClass.getName(), (Clazz)programClass);
            programClass.subClassCount = 0;
            Arrays.fill(programClass.subClasses, null);
        } else {
            programClass.subClassCount = this.updateUniqueReferencedClasses(programClass.subClasses, programClass.subClassCount, (Clazz)programClass);
        }
        ReferencedClassVisitor subclassAdder = new ReferencedClassVisitor((ClassVisitor)new SubclassFilter((Clazz)programClass, (ClassVisitor)new SubclassAdder((Clazz)programClass)));
        programClass.superClassConstantAccept((ConstantVisitor)subclassAdder);
        programClass.interfaceConstantsAccept((ConstantVisitor)subclassAdder);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.subClassCount = this.updateUniqueReferencedClasses(libraryClass.subClasses, libraryClass.subClassCount, (Clazz)libraryClass);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.referencedClass = this.updateReferencedClass(programField.referencedClass);
        programField.attributesAccept(programClass, (AttributeVisitor)this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.updateReferencedClasses(programMethod.referencedClasses);
        programMethod.attributesAccept(programClass, (AttributeVisitor)this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Clazz referencedClass = stringConstant.referencedClass;
        Clazz newReferencedClass = this.updateReferencedClass(referencedClass);
        if (referencedClass != newReferencedClass) {
            stringConstant.referencedClass = newReferencedClass;
            stringConstant.referencedMember = this.updateReferencedMember(stringConstant.referencedMember, stringConstant.getString(clazz), null, newReferencedClass);
        }
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.updateReferencedClasses(invokeDynamicConstant.referencedClasses);
    }

    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant refConstant) {
        Clazz referencedClass = refConstant.referencedClass;
        Clazz newReferencedClass = this.updateReferencedClass(referencedClass);
        if (referencedClass != newReferencedClass) {
            logger.debug("TargetClassChanger:");
            logger.debug("  [{}] changing reference from [{}.{}{}]", (Object)clazz.getName(), (Object)refConstant.referencedClass.getName(), (Object)refConstant.referencedMethod.getName(refConstant.referencedClass), (Object)refConstant.referencedMethod.getDescriptor(refConstant.referencedClass));
            refConstant.referencedClass = newReferencedClass;
            refConstant.referencedMethod = (Method)this.updateReferencedMember((Member)refConstant.referencedMethod, refConstant.getName(clazz), refConstant.getType(clazz), newReferencedClass);
            logger.debug("  [{}]                    to   [{}.{}]", (Object)clazz.getName(), (Object)refConstant.referencedClass, (Object)refConstant.referencedMethod);
        }
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant refConstant) {
        Clazz referencedClass = refConstant.referencedClass;
        Clazz newReferencedClass = this.updateReferencedClass(referencedClass);
        if (referencedClass != newReferencedClass) {
            logger.debug("TargetClassChanger:");
            logger.debug("  [{}] changing reference from [{}.{}{}]", (Object)clazz.getName(), (Object)refConstant.referencedClass.getName(), (Object)refConstant.referencedField.getName(refConstant.referencedClass), (Object)refConstant.referencedField.getDescriptor(refConstant.referencedClass));
            refConstant.referencedClass = newReferencedClass;
            refConstant.referencedField = (Field)this.updateReferencedMember((Member)refConstant.referencedField, refConstant.getName(clazz), refConstant.getType(clazz), newReferencedClass);
            logger.debug("  [{}]                    to   [{}.{}]", (Object)clazz.getName(), (Object)refConstant.referencedClass, (Object)refConstant.referencedField);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.updateReferencedClass(classConstant.referencedClass);
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.updateReferencedClasses(methodTypeConstant.referencedClasses);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, (AttributeVisitor)this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableInfoVisitor)this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableTypeInfoVisitor)this);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        try {
            this.updateReferencedClasses(signatureAttribute.referencedClasses);
        }
        catch (RuntimeException e) {
            logger.error("Unexpected error while adapting signatures for merged classes:");
            logger.error("  Class     = [{}]", (Object)clazz.getName());
            logger.error("  Signature = [{}]", (Object)signatureAttribute.getSignature(clazz));
            Clazz[] referencedClasses = signatureAttribute.referencedClasses;
            if (referencedClasses != null) {
                for (int index = 0; index < referencedClasses.length; ++index) {
                    Clazz referencedClass = referencedClasses[index];
                    logger.error("  Referenced class #{} = {}", (Object)index, (Object)referencedClass);
                    if (referencedClass == null) continue;
                    ClassOptimizationInfo info = ClassOptimizationInfo.getClassOptimizationInfo(referencedClass);
                    logger.error("                         info        = {}", (Object)info);
                    if (info == null) continue;
                    logger.error("                         target      = {}", (Object)info.getTargetClass());
                }
            }
            logger.error("  Exception = [{}] ({})", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw e;
        }
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, (AnnotationVisitor)this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, (AnnotationVisitor)this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, (ElementValueVisitor)this);
    }

    public void visitRecordComponentInfo(Clazz clazz, RecordComponentInfo recordComponentInfo) {
        recordComponentInfo.attributesAccept(clazz, (AttributeVisitor)this);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.referencedClass = this.updateReferencedClass(localVariableInfo.referencedClass);
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.updateReferencedClasses(localVariableTypeInfo.referencedClasses);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.updateReferencedClasses(annotation.referencedClasses);
        annotation.elementValuesAccept(clazz, (ElementValueVisitor)this);
    }

    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        Clazz referencedClass = elementValue.referencedClass;
        Clazz newReferencedClass = this.updateReferencedClass(referencedClass);
        if (referencedClass != newReferencedClass) {
            elementValue.referencedClass = newReferencedClass;
            elementValue.referencedMethod = (Method)this.updateReferencedMember((Member)elementValue.referencedMethod, elementValue.getMethodName(clazz), null, newReferencedClass);
        }
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.visitAnyElementValue(clazz, annotation, (ElementValue)constantElementValue);
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.visitAnyElementValue(clazz, annotation, (ElementValue)enumConstantElementValue);
        this.updateReferencedClasses(enumConstantElementValue.referencedClasses);
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.visitAnyElementValue(clazz, annotation, (ElementValue)classElementValue);
        this.updateReferencedClasses(classElementValue.referencedClasses);
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.visitAnyElementValue(clazz, annotation, (ElementValue)annotationElementValue);
        annotationElementValue.annotationAccept(clazz, (AnnotationVisitor)this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.visitAnyElementValue(clazz, annotation, (ElementValue)arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, (ElementValueVisitor)this);
    }

    private boolean containsInterfaceClass(Clazz clazz, int interfaceCount, Clazz interfaceClass) {
        for (int index = 0; index < interfaceCount; ++index) {
            if (!interfaceClass.equals(clazz.getInterface(index))) continue;
            return true;
        }
        return false;
    }

    private int updateUniqueReferencedClasses(Clazz[] referencedClasses, int referencedClassCount, Clazz avoidClass) {
        int newIndex = 0;
        for (int index = 0; index < referencedClassCount; ++index) {
            Clazz referencedClass = referencedClasses[index];
            Clazz targetClass = ClassMerger.getTargetClass(referencedClasses[index]);
            if (targetClass == null) {
                referencedClasses[newIndex++] = referencedClass;
                continue;
            }
            if (targetClass.equals(avoidClass) || ArrayUtil.indexOf((Object[])referencedClasses, (int)referencedClassCount, (Object)targetClass) >= 0) continue;
            referencedClasses[newIndex++] = targetClass;
        }
        Arrays.fill(referencedClasses, newIndex, referencedClassCount, null);
        return newIndex;
    }

    private void updateReferencedClasses(Clazz[] referencedClasses) {
        if (referencedClasses == null) {
            return;
        }
        for (int index = 0; index < referencedClasses.length; ++index) {
            referencedClasses[index] = this.updateReferencedClass(referencedClasses[index]);
        }
    }

    private Clazz updateReferencedClass(Clazz referencedClass) {
        if (referencedClass == null) {
            return null;
        }
        Clazz targetClazz = ClassMerger.getTargetClass(referencedClass);
        return targetClazz != null ? targetClazz : referencedClass;
    }

    private Member updateReferencedMember(Member referencedMember, String name, String type, Clazz newReferencedClass) {
        if (referencedMember == null) {
            return null;
        }
        return referencedMember instanceof Field ? newReferencedClass.findField(name, type) : newReferencedClass.findMethod(name, type);
    }

    private int addNewClassConstant(ProgramClass programClass, String className, Clazz referencedClass) {
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
        int nameIndex = constantPoolEditor.addUtf8Constant(className);
        int classConstantIndex = constantPoolEditor.addConstant((Constant)new ClassConstant(nameIndex, referencedClass));
        return classConstantIndex;
    }
}

