/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.signature.TypeArgumentNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class SimpleClassTypeSignatureNode {
    @NotNull
    private String identifier;
    @NotNull
    private List<TypeArgumentNode> typeArguments;

    public SimpleClassTypeSignatureNode(@NotNull String identifier, @NotNull List<TypeArgumentNode> typeArguments) {
        if (identifier == null || typeArguments == null) {
            throw new ASTStructureException("Arguments must not be null.");
        }
        this.identifier = identifier;
        this.typeArguments = typeArguments;
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.identifier = identifier;
    }

    @NotNull
    public List<TypeArgumentNode> getTypeArguments() {
        return this.typeArguments;
    }

    public void setTypeArguments(@NotNull List<TypeArgumentNode> typeArguments) {
        if (typeArguments == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.typeArguments = typeArguments;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    @NotNull
    public String toString() {
        return this.identifier + (this.typeArguments.isEmpty() ? "" : "<" + this.typeArguments.stream().map(TypeArgumentNode::toString).collect(Collectors.joining()) + ">");
    }
}

