/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.signature.ClassTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.TypeVariableSignatureNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class ThrowsSignatureNode {
    @Nullable
    private ClassTypeSignatureNode classType;
    @Nullable
    private TypeVariableSignatureNode typeVariable;

    public ThrowsSignatureNode(@NotNull ClassTypeSignatureNode signature) {
        if (signature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.classType = signature;
        this.typeVariable = null;
    }

    public ThrowsSignatureNode(@NotNull TypeVariableSignatureNode signature) {
        if (signature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.classType = null;
        this.typeVariable = signature;
    }

    public boolean isClassType() {
        return this.classType != null;
    }

    @Nullable
    public ClassTypeSignatureNode getClassType() {
        return this.classType;
    }

    public void changeToClassType(@NotNull ClassTypeSignatureNode classTypeSignature) {
        if (classTypeSignature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.classType = classTypeSignature;
        this.typeVariable = null;
    }

    public boolean isTypeVariable() {
        return this.typeVariable != null;
    }

    @Nullable
    public TypeVariableSignatureNode getTypeVariable() {
        return this.typeVariable;
    }

    public void changeToTypeVariable(@NotNull TypeVariableSignatureNode typeVariableSignature) {
        if (typeVariableSignature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.typeVariable = typeVariableSignature;
        this.classType = null;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    @NotNull
    public String toString() {
        if (this.typeVariable != null) {
            return this.typeVariable.toString();
        }
        if (this.classType != null) {
            return this.classType.toString();
        }
        throw new ASTStructureException("at least one of the fields must be non-null");
    }
}

