/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;

public class ClassPresenceFilter
implements ClassVisitor {
    private final ClassPool classPool;
    private final ClassVisitor presentClassVisitor;
    private final ClassVisitor missingClassVisitor;

    public ClassPresenceFilter(ClassPool classPool, ClassVisitor presentClassVisitor, ClassVisitor missingClassVisitor) {
        this.classPool = classPool;
        this.presentClassVisitor = presentClassVisitor;
        this.missingClassVisitor = missingClassVisitor;
    }

    public ClassPresenceFilter(ClassPool classPool, ClassVisitor presentClassVisitor) {
        this(classPool, presentClassVisitor, null);
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        ClassVisitor classFileVisitor = this.classFileVisitor(clazz);
        if (classFileVisitor != null) {
            clazz.accept(classFileVisitor);
        }
    }

    private ClassVisitor classFileVisitor(Clazz clazz) {
        return this.classPool.getClass(clazz.getName()) != null ? this.presentClassVisitor : this.missingClassVisitor;
    }
}

