/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassCollector;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.MultiTypedReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;

public class MultiTypedReferenceValueFactory
extends TypedReferenceValueFactory {
    private boolean addSubClasses;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;

    public MultiTypedReferenceValueFactory() {
        this(false, null, null);
    }

    public MultiTypedReferenceValueFactory(boolean addSubClasses, ClassPool programClassPool, ClassPool libraryClassPool) {
        this.addSubClasses = addSubClasses;
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
    }

    private MultiTypedReferenceValue wrap(ReferenceValue base) {
        if (base instanceof MultiTypedReferenceValue) {
            return (MultiTypedReferenceValue)base;
        }
        if (base instanceof TypedReferenceValue) {
            return new MultiTypedReferenceValue((TypedReferenceValue)base, false);
        }
        throw new IllegalStateException("Can't handle value of type " + base.getClass().getSimpleName());
    }

    @Override
    public ReferenceValue createReferenceValueNull() {
        return this.wrap(super.createReferenceValueNull());
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        return this.wrap(super.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull));
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        return this.wrap(super.createArrayReferenceValue(type, referencedClass, arrayLength));
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength, Object elementValues) {
        return this.wrap(super.createArrayReferenceValue(type, referencedClass, arrayLength, elementValues));
    }

    @Override
    public Value createValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        Value ret = super.createValue(type, referencedClass, mayBeExtension, mayBeNull);
        if (!this.addSubClasses) {
            return ret;
        }
        if (ret instanceof MultiTypedReferenceValue) {
            MultiTypedReferenceValue multiTypedRet = (MultiTypedReferenceValue)ret;
            HashSet<Clazz> subClasses = new HashSet<Clazz>();
            for (TypedReferenceValue t : multiTypedRet.getPotentialTypes()) {
                if (t.type.equals("Ljava/lang/Object;")) {
                    return ret;
                }
                Clazz realReferencedClass = this.programClassPool.getClass(ClassUtil.internalClassNameFromClassType(t.type));
                if (realReferencedClass == null) {
                    realReferencedClass = this.libraryClassPool.getClass(ClassUtil.internalClassNameFromClassType(t.type));
                }
                if (realReferencedClass == null) {
                    return ret;
                }
                realReferencedClass.hierarchyAccept(true, false, false, true, new ClassCollector(subClasses));
            }
            Set possibleTypes = subClasses.stream().map(cls -> new TypedReferenceValue(ClassUtil.internalTypeFromClassName(cls.getName()), (Clazz)cls, mayBeExtension, mayBeNull)).collect(Collectors.toCollection(HashSet::new));
            possibleTypes.addAll(multiTypedRet.getPotentialTypes());
            ret = new MultiTypedReferenceValue(possibleTypes, multiTypedRet.mayBeUnknown);
        }
        return ret;
    }
}

