/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.type.ITypedObject;
import com.helger.datetime.util.PDTHelper;
import com.helger.tenancy.datetime.IHasCreationInfo;
import com.helger.tenancy.datetime.IHasDeletionInfo;
import com.helger.tenancy.datetime.IHasLastModificationInfo;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IBusinessObject
extends ITypedObject<String>,
IHasCreationInfo,
IHasLastModificationInfo,
IHasDeletionInfo {
    @Nullable
    default public LocalDateTime getLastChangeDateTime() {
        LocalDateTime localDateTime;
        LocalDateTime localDateTime2;
        LocalDateTime localDateTime3 = localDateTime2 = this.getCreationDateTime();
        LocalDateTime localDateTime4 = this.getLastModificationDateTime();
        if (localDateTime4 != null) {
            localDateTime3 = localDateTime3 != null ? PDTHelper.getMax((LocalDateTime)localDateTime3, (LocalDateTime)localDateTime4) : localDateTime4;
        }
        if ((localDateTime = this.getDeletionDateTime()) != null) {
            localDateTime3 = localDateTime3 != null ? PDTHelper.getMax((LocalDateTime)localDateTime3, (LocalDateTime)localDateTime) : localDateTime;
        }
        return localDateTime3;
    }

    default public boolean isLastChangeAfter(@Nonnull LocalDateTime localDateTime) {
        LocalDateTime localDateTime2 = this.getLastChangeDateTime();
        return localDateTime2 != null && localDateTime2.isAfter(localDateTime);
    }

    default public boolean isDeleted() {
        return this.hasDeletionDateTime();
    }

    default public boolean isNotDeleted() {
        return !this.hasDeletionDateTime();
    }

    @Nonnull
    @ReturnsMutableObject
    public IStringMap attrs();
}

