/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy.accarea;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tenancy.accarea.IAccountingArea;
import com.helger.tenancy.accarea.IAccountingAreaObject;
import com.helger.tenancy.accarea.IHasAccountingArea;
import com.helger.tenancy.tenant.AbstractHasTenant;
import com.helger.tenancy.tenant.ITenant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractHasAccountingAreaObject
extends AbstractHasTenant
implements IHasAccountingArea {
    private final IAccountingArea m_aAccountingArea;

    protected AbstractHasAccountingAreaObject(@Nonnull IAccountingAreaObject iAccountingAreaObject) {
        super(iAccountingAreaObject.getTenant());
        this.m_aAccountingArea = iAccountingAreaObject.getAccountingArea();
    }

    public AbstractHasAccountingAreaObject(@Nonnull IAccountingArea iAccountingArea) {
        this(iAccountingArea.getTenant(), iAccountingArea);
    }

    public AbstractHasAccountingAreaObject(@Nonnull ITenant iTenant, @Nonnull IAccountingArea iAccountingArea) {
        super(iTenant);
        ValueEnforcer.notNull((Object)iAccountingArea, (String)"AccountingArea");
        ValueEnforcer.isTrue((boolean)iAccountingArea.hasSameTenant(iTenant), () -> "The passed accounting area '" + (String)iAccountingArea.getID() + "' does not belong to the passed tenant '" + (String)iTenant.getID() + "'!");
        this.m_aAccountingArea = iAccountingArea;
    }

    @Override
    @Nonnull
    public final IAccountingArea getAccountingArea() {
        return this.m_aAccountingArea;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getAccountingAreaID() {
        return (String)this.m_aAccountingArea.getID();
    }

    @Override
    public final boolean hasSameTenantAndAccountingAreaID(@Nullable IAccountingArea iAccountingArea) {
        return iAccountingArea != null && this.hasSameTenantID(iAccountingArea) && this.hasSameAccountingAreaID((String)iAccountingArea.getID());
    }

    @Override
    public final boolean hasSameTenantAndAccountingAreaID(@Nullable IAccountingAreaObject iAccountingAreaObject) {
        return iAccountingAreaObject != null && this.hasSameTenantID(iAccountingAreaObject) && this.hasSameAccountingAreaID(iAccountingAreaObject.getAccountingAreaID());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractHasAccountingAreaObject abstractHasAccountingAreaObject = (AbstractHasAccountingAreaObject)object;
        return this.m_aAccountingArea.equals(abstractHasAccountingAreaObject.m_aAccountingArea);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aAccountingArea).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("accoutingArea", (Object)this.m_aAccountingArea).getToString();
    }
}

