/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy.tenant;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tenancy.tenant.IHasTenant;
import com.helger.tenancy.tenant.ITenant;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractHasTenant
implements IHasTenant,
Serializable {
    @Nonnull
    private final ITenant m_aTenant;

    public AbstractHasTenant(@Nonnull ITenant iTenant) {
        this.m_aTenant = (ITenant)ValueEnforcer.notNull((Object)iTenant, (String)"Tenant");
    }

    @Override
    @Nonnull
    public final ITenant getTenant() {
        return this.m_aTenant;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getTenantID() {
        return (String)this.m_aTenant.getID();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractHasTenant abstractHasTenant = (AbstractHasTenant)object;
        return this.m_aTenant.equals(abstractHasTenant.m_aTenant);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aTenant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Tenant", (Object)this.m_aTenant).getToString();
    }
}

