/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.schematron;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.Since;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.error.IError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.maven.schematron.PluginErrorListener;
import com.helger.schematron.ESchematronMode;
import com.helger.schematron.ISchematronResource;
import com.helger.schematron.pure.SchematronResourcePure;
import com.helger.schematron.pure.errorhandler.CollectingPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.sch.SchematronResourceSCH;
import com.helger.schematron.schxslt.xslt2.SchematronResourceSchXslt_XSLT2;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.xslt.SchematronResourceXSLT;
import com.helger.xml.transform.CollectingTransformErrorListener;
import com.helger.xml.transform.TransformSourceFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.impl.StaticLoggerBinder;
import org.sonatype.plexus.build.incremental.BuildContext;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"})
@Mojo(name="validate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public final class SchematronValidationMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(name="schematronFile", required=true)
    private File m_aSchematronFile;
    @Parameter(name="schematronProcessingEngine", required=true)
    private String m_sSchematronProcessingEngine = ESchematronMode.SCHEMATRON.getID();
    @Parameter(name="xmlDirectory", required=true)
    private File m_aXmlDirectory;
    @Parameter(name="xmlIncludes", defaultValue="**/*.xml", required=true)
    private String[] m_aXmlIncludes;
    @Parameter(name="xmlExcludes")
    private String[] m_aXmlExcludes;
    @Parameter(name="svrlDirectory")
    private File m_aSvrlDirectory;
    @Parameter(name="xmlErrorDirectory")
    private File m_aXmlErrorDirectory;
    @Parameter(name="xmlErrorIncludes", defaultValue="**/*.xml")
    private String[] m_aXmlErrorIncludes;
    @Parameter(name="xmlErrorExcludes")
    private String[] m_aXmlErrorExcludes;
    @Parameter(name="svrlErrorDirectory")
    private File m_aSvrlErrorDirectory;
    @Parameter(name="phaseName")
    private String m_sPhaseName;
    @Parameter(name="languageCode")
    private String m_sLanguageCode;
    @Parameter(name="parameters")
    @Since(value="5.0.2")
    private Map<String, String> m_aCustomParameters;
    @Parameter(name="failFast", defaultValue="true", required=true)
    @Since(value="5.0.5")
    private boolean m_bFailFast = true;
    @Parameter(name="forceCacheResult", defaultValue="false")
    @Since(value="5.2.1")
    private boolean m_bForceCacheResult = false;
    @Parameter(name="lenient", defaultValue="false")
    @Since(value="5.4.1")
    private boolean m_bLenient = false;

    public void setSchematronFile(@Nonnull File file) {
        this.m_aSchematronFile = file;
        if (!this.m_aSchematronFile.isAbsolute()) {
            this.m_aSchematronFile = new File(this.project.getBasedir(), file.getPath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using Schematron file '" + this.m_aSchematronFile + "'"));
        }
    }

    public void setSchematronProcessingEngine(@Nullable String string) {
        ESchematronMode eSchematronMode = ESchematronMode.getFromIDOrNull((String)string);
        String string2 = this.m_sSchematronProcessingEngine = eSchematronMode == null ? null : eSchematronMode.getID();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Schematron processing mode set to '" + eSchematronMode + "'"));
        }
    }

    public void setXmlDirectory(@Nonnull File file) {
        this.m_aXmlDirectory = file;
        if (!this.m_aXmlDirectory.isAbsolute()) {
            this.m_aXmlDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Searching XML files in the directory '" + this.m_aXmlDirectory + "'"));
        }
    }

    public void setXmlIncludes(@Nullable String[] stringArray) {
        this.m_aXmlIncludes = stringArray;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Setting XML file includes to " + StringHelper.imploder().source((Object[])stringArray, string -> "'" + string + "'").separator(", ").build()));
        }
    }

    public void setXmlExcludes(@Nullable String[] stringArray) {
        this.m_aXmlExcludes = stringArray;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Setting XML file excludes to " + StringHelper.imploder().source((Object[])stringArray, string -> "'" + string + "'").separator(", ").build()));
        }
    }

    public void setSvrlDirectory(@Nonnull File file) {
        this.m_aSvrlDirectory = file;
        if (!this.m_aSvrlDirectory.isAbsolute()) {
            this.m_aSvrlDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Writing SVRL files to directory '" + this.m_aSvrlDirectory + "'"));
        }
    }

    public void setXmlErrorDirectory(@Nonnull File file) {
        this.m_aXmlErrorDirectory = file;
        if (!this.m_aXmlErrorDirectory.isAbsolute()) {
            this.m_aXmlErrorDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Searching erroneous XML files in the directory '" + this.m_aXmlDirectory + "'"));
        }
    }

    public void setXmlErrorIncludes(@Nullable String[] stringArray) {
        this.m_aXmlErrorIncludes = stringArray;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Setting erroneous XML file includes to " + StringHelper.imploder().source((Object[])stringArray, string -> "'" + string + "'").separator(", ").build()));
        }
    }

    public void setXmlErrorExcludes(@Nullable String[] stringArray) {
        this.m_aXmlErrorExcludes = stringArray;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Setting erroneous XML file excludes to " + StringHelper.imploder().source((Object[])stringArray, string -> "'" + string + "'").separator(", ").build()));
        }
    }

    public void setSvrlErrorDirectory(@Nonnull File file) {
        this.m_aSvrlErrorDirectory = file;
        if (!this.m_aSvrlErrorDirectory.isAbsolute()) {
            this.m_aSvrlErrorDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Writing erroneous SVRL files to directory '" + this.m_aSvrlErrorDirectory + "'"));
        }
    }

    public void setPhaseName(@Nullable String string) {
        this.m_sPhaseName = string;
        if (this.getLog().isDebugEnabled()) {
            if (this.m_sPhaseName == null) {
                this.getLog().debug((CharSequence)"Using default phase");
            } else {
                this.getLog().debug((CharSequence)("Using the phase '" + this.m_sPhaseName + "'"));
            }
        }
    }

    public void setLanguageCode(@Nullable String string) {
        this.m_sLanguageCode = string;
        if (this.getLog().isDebugEnabled()) {
            if (this.m_sLanguageCode == null) {
                this.getLog().debug((CharSequence)"Using default language code");
            } else {
                this.getLog().debug((CharSequence)("Using the language code '" + this.m_sLanguageCode + "'"));
            }
        }
    }

    public void setParameters(@Nullable Map<String, String> map) {
        this.m_aCustomParameters = map;
        if (this.m_aCustomParameters == null || this.m_aCustomParameters.isEmpty()) {
            this.getLog().debug((CharSequence)"Using no custom parameters");
        } else {
            this.getLog().debug((CharSequence)("Using custom parameters " + this.m_aCustomParameters.toString()));
        }
    }

    public void setFailFast(boolean bl) {
        this.m_bFailFast = bl;
        if (bl) {
            this.getLog().debug((CharSequence)"Failing at the first erroneous file");
        } else {
            this.getLog().debug((CharSequence)"Failing after validating all files");
        }
    }

    public void setForceCacheResult(boolean bl) {
        this.m_bForceCacheResult = bl;
        if (this.m_bForceCacheResult) {
            this.getLog().debug((CharSequence)"Results are forcebly cached");
        } else {
            this.getLog().debug((CharSequence)"Results not not forcebly cached");
        }
    }

    public void setLenient(boolean bl) {
        this.m_bLenient = bl;
        if (this.m_bLenient) {
            this.getLog().debug((CharSequence)"Old deprecated namespace URIs are supported");
        } else {
            this.getLog().debug((CharSequence)"Old deprecated namespace URIs are not supported");
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    ICommonsMap<String, String> getParameters() {
        return new CommonsHashMap(this.m_aCustomParameters);
    }

    private void _performValidation(@Nonnull ISchematronResource iSchematronResource, @Nonnull File file, @Nullable String[] stringArray, @Nullable String[] stringArray2, @Nullable File file2, boolean bl, @Nonnull ICommonsList<String> iCommonsList) throws MojoExecutionException, MojoFailureException {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(file);
        if (ArrayHelper.isNotEmpty((Object[])stringArray)) {
            directoryScanner.setIncludes(stringArray);
        }
        if (ArrayHelper.isNotEmpty((Object[])stringArray2)) {
            directoryScanner.setExcludes(stringArray2);
        }
        directoryScanner.setCaseSensitive(true);
        directoryScanner.scan();
        String[] stringArray3 = directoryScanner.getIncludedFiles();
        if (stringArray3 != null) {
            for (String string : stringArray3) {
                Object object;
                File file3 = new File(file, string);
                this.getLog().info((CharSequence)("Validating XML file '" + file3.getPath() + "' against Schematron rules from '" + this.m_aSchematronFile + "' expecting " + (bl ? "success" : "failure")));
                try {
                    Object object2;
                    SchematronOutputType schematronOutputType = iSchematronResource.applySchematronValidationToSVRL((Source)TransformSourceFactory.create((File)file3));
                    if (file2 != null) {
                        object = new File(file2, string + ".svrl");
                        object2 = FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(((File)object).getParentFile());
                        if (object2.isFailure()) {
                            this.getLog().error((CharSequence)("Failed to create parent directory of '" + ((File)object).getAbsolutePath() + "': " + object2.toString()));
                        }
                        if (new SVRLMarshaller().write((Object)schematronOutputType, (File)object).isSuccess()) {
                            this.getLog().info((CharSequence)("Successfully saved SVRL file '" + ((File)object).getPath() + "'"));
                        } else {
                            this.getLog().error((CharSequence)("Error saving SVRL file '" + ((File)object).getPath() + "'"));
                        }
                    }
                    object = SVRLHelper.getAllFailedAssertionsAndSuccessfulReports((SchematronOutputType)schematronOutputType);
                    if (bl) {
                        if (!object.isNotEmpty()) continue;
                        object2 = object.size() + " failed Schematron assertions for XML file '" + file3.getPath() + "'";
                        this.getLog().error((CharSequence)object2);
                        object.forEach(abstractSVRLMessage -> this.getLog().error((CharSequence)abstractSVRLMessage.getAsResourceError(file3.getPath()).getAsString(Locale.US)));
                        if (this.m_bFailFast) {
                            throw new MojoFailureException((String)object2);
                        }
                        iCommonsList.add(object2);
                        continue;
                    }
                    if (!object.isEmpty()) continue;
                    object2 = "No failed Schematron assertions for erroneous XML file '" + file3.getPath() + "'";
                    this.getLog().error((CharSequence)object2);
                    if (this.m_bFailFast) {
                        throw new MojoFailureException((String)object2);
                    }
                    iCommonsList.add(object2);
                }
                catch (MojoExecutionException | MojoFailureException throwable) {
                    throw throwable;
                }
                catch (Exception exception) {
                    object = "Exception validating XML '" + file3.getPath() + "' against Schematron rules from '" + this.m_aSchematronFile + "'";
                    this.getLog().error((CharSequence)object, (Throwable)exception);
                    throw new MojoExecutionException((String)object, exception);
                }
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ErrorList errorList;
        SchematronResourcePure schematronResourcePure;
        Object object;
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.m_aSchematronFile == null) {
            throw new MojoExecutionException("No Schematron file specified!");
        }
        if (this.m_aSchematronFile.exists() && !this.m_aSchematronFile.isFile()) {
            throw new MojoExecutionException("The specified Schematron file " + this.m_aSchematronFile + " is not a file!");
        }
        if (this.m_sSchematronProcessingEngine == null) {
            throw new MojoExecutionException("An invalid Schematron processing instance is specified! Only one of the following values is allowed: " + StringHelper.getImplodedMapped((String)", ", (Object[])ESchematronMode.values(), eSchematronMode -> "'" + eSchematronMode.getID() + "'"));
        }
        if (this.m_aXmlDirectory == null && this.m_aXmlErrorDirectory == null) {
            throw new MojoExecutionException("No XML directory specified - positive or negative directory must be present!");
        }
        if (this.m_aXmlDirectory != null) {
            if (this.m_aXmlDirectory.exists() && !this.m_aXmlDirectory.isDirectory()) {
                throw new MojoExecutionException("The specified XML directory " + this.m_aXmlDirectory + " is not a directory!");
            }
            if (ArrayHelper.isEmpty((Object[])this.m_aXmlIncludes)) {
                throw new MojoExecutionException("No XML include pattern specified!");
            }
            if (this.m_aSvrlDirectory != null && !this.m_aSvrlDirectory.exists() && !this.m_aSvrlDirectory.mkdirs()) {
                throw new MojoExecutionException("Failed to create the SVRL directory " + this.m_aSvrlDirectory);
            }
        }
        if (this.m_aXmlErrorDirectory != null) {
            if (this.m_aXmlErrorDirectory.exists() && !this.m_aXmlErrorDirectory.isDirectory()) {
                throw new MojoExecutionException("The specified erroneous XML directory " + this.m_aXmlErrorDirectory + " is not a directory!");
            }
            if (ArrayHelper.isEmpty((Object[])this.m_aXmlErrorIncludes)) {
                throw new MojoExecutionException("No erroneous XML include pattern specified!");
            }
            if (this.m_aSvrlErrorDirectory != null && !this.m_aSvrlErrorDirectory.exists() && !this.m_aSvrlErrorDirectory.mkdirs()) {
                throw new MojoExecutionException("Failed to create the erroneous SVRL directory " + this.m_aSvrlErrorDirectory);
            }
        }
        switch (ESchematronMode.getFromIDOrNull((String)this.m_sSchematronProcessingEngine)) {
            case PURE: {
                CollectingPSErrorHandler collectingPSErrorHandler = new CollectingPSErrorHandler();
                object = new SchematronResourcePure((IReadableResource)new FileSystemResource(this.m_aSchematronFile));
                object.setPhase(this.m_sPhaseName);
                object.setLenient(this.m_bLenient);
                object.setErrorHandler((IPSErrorHandler)collectingPSErrorHandler);
                object.validateCompletely();
                schematronResourcePure = object;
                errorList = collectingPSErrorHandler.getAllErrors();
                break;
            }
            case SCHEMATRON: {
                CollectingPSErrorHandler collectingPSErrorHandler = new CollectingTransformErrorListener();
                object = new SchematronResourceSCH((IReadableResource)new FileSystemResource(this.m_aSchematronFile));
                object.setPhase(this.m_sPhaseName);
                object.setLanguageCode(this.m_sLanguageCode);
                object.setForceCacheResult(this.m_bForceCacheResult);
                object.parameters().setAll(this.m_aCustomParameters);
                object.setErrorListener((ErrorListener)collectingPSErrorHandler);
                object.isValidSchematron();
                schematronResourcePure = object;
                errorList = collectingPSErrorHandler.getErrorList();
                break;
            }
            case SCHXSLT_XSLT2: {
                CollectingPSErrorHandler collectingPSErrorHandler = new CollectingTransformErrorListener();
                object = new SchematronResourceSchXslt_XSLT2((IReadableResource)new FileSystemResource(this.m_aSchematronFile));
                object.setPhase(this.m_sPhaseName);
                object.setLanguageCode(this.m_sLanguageCode);
                object.setForceCacheResult(this.m_bForceCacheResult);
                object.parameters().setAll(this.m_aCustomParameters);
                object.setErrorListener((ErrorListener)collectingPSErrorHandler);
                object.isValidSchematron();
                schematronResourcePure = object;
                errorList = collectingPSErrorHandler.getErrorList();
                break;
            }
            case XSLT: {
                CollectingPSErrorHandler collectingPSErrorHandler = new CollectingTransformErrorListener();
                object = new SchematronResourceXSLT((IReadableResource)new FileSystemResource(this.m_aSchematronFile));
                object.parameters().setAll(this.m_aCustomParameters);
                object.setErrorListener((ErrorListener)collectingPSErrorHandler);
                object.isValidSchematron();
                schematronResourcePure = object;
                errorList = collectingPSErrorHandler.getErrorList();
                break;
            }
            default: {
                throw new MojoExecutionException("No handler for processing engine '" + this.m_sSchematronProcessingEngine + "'");
            }
        }
        if (errorList != null) {
            boolean bl = false;
            for (IError iError : errorList) {
                if (iError.getErrorLevel().isGE((IErrorLevel)EErrorLevel.ERROR)) {
                    bl = true;
                }
                PluginErrorListener.logIError(this.buildContext, this.m_aSchematronFile, iError);
            }
            if (bl) {
                throw new MojoExecutionException("The provided Schematron file contains errors. See log for details.");
            }
        }
        this.getLog().info((CharSequence)("Successfully parsed Schematron file '" + this.m_aSchematronFile.getPath() + "'"));
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (this.m_aXmlDirectory != null) {
            this._performValidation((ISchematronResource)schematronResourcePure, this.m_aXmlDirectory, this.m_aXmlIncludes, this.m_aXmlExcludes, this.m_aSvrlDirectory, true, (ICommonsList<String>)commonsArrayList);
        }
        if (this.m_aXmlErrorDirectory != null) {
            this._performValidation((ISchematronResource)schematronResourcePure, this.m_aXmlErrorDirectory, this.m_aXmlErrorIncludes, this.m_aXmlErrorExcludes, this.m_aSvrlErrorDirectory, false, (ICommonsList<String>)commonsArrayList);
        }
        if (!this.m_bFailFast && commonsArrayList.isNotEmpty()) {
            commonsArrayList.add(0, (Object)(commonsArrayList.size() + " errors found:"));
            object = StringHelper.getImploded((String)"\n  ", (Iterable)commonsArrayList);
            throw new MojoFailureException((String)object);
        }
    }
}

